function KM = Polynomial_Userkernel(x,y,gap,p1,p2)
% Polynomial kernel for two vectors.
% Using it to calculate the polynomail kernel for two aligned sequence;
%  
% Copyright 2009, Xiaojian SHAO
%
% USAGE:
% KM=Polynomial_Userkernel(x,y,gap,p1,p2)
%   
%  %INPUT%
%%%%%%%%%%%%%%%%%%%%
% x,y   : The aligned sequences for two parts with the same length of sequence;
%          x,y could be the matrix with same columns;
% gap   : The gap index for the gap in the aligned sequence, e.g., '-' in aligned sequence;
% p1,p2 : The parameters for polynomial kernel;
%           K_polynomail(x, y) = (K_baseline(x,y)+p1)^p2, 

% % OUTPUT %
%%%%%%%%%%%%%%%%%%%%
%
% KM    : the returned kernel matrix for x and y.
%
%%%%%%%%%%%%%%%%%%%%


[Lx,Nx] = size(x);
[Ly,Ny] = size(y);

%% The column for x,y must be the same.
if Nx~=Ny
    error('The dimension of the input vector is not equal! Please double check!');
    % else: Nothing to do! Continue;
end

%% Initilized the returned kernel matrix;
KM=zeros(Lx,Ly);

for i =1:Lx
    % calulate the self kernel function of the sequence x without gap;
    Kx=(sum(x(i,:)~=gap)+p1)^p2;
    
    for j=1:Ly
        % calulate the self kernel function of the sequence y without gap;
        Ky=(sum(y(j,:)~=gap)+p1)^p2;
        % calulate the kernel function between sequence x and y without gap;
        KM(i,j)=(sum(x(i,:)==y(j,:)&x(i,:)~=gap)+p1)^p2;
        % Normalized kernel function;
        KM(i,j)= KM(i,j)/sqrt(Kx*Ky);
    end
    
end

