/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.gui.sequence.SequenceViewerListener;
import org.biojava.bio.gui.sequence.SequenceViewerMotionListener;
import org.biojava.bio.gui.sequence.SequenceViewerMotionSupport;
import org.biojava.bio.gui.sequence.SequenceViewerSupport;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeAdapter;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class SequencePanel
extends JComponent
implements SwingConstants,
SequenceRenderContext,
Changeable {
    public static final ChangeType RENDERER = new ChangeType("The renderer for this SequencePanel has changed", "org.biojava.bio.gui.sequence.SequencePanel", "RENDERER", SequenceRenderContext.LAYOUT);
    private SymbolList sequence;
    private RangeLocation range;
    private int direction = 0;
    private double scale = 12.0;
    private double pixelOffset = 0.0;
    private SequenceRenderContext.Border leadingBorder;
    private SequenceRenderContext.Border trailingBorder;
    private SequenceRenderer renderer;
    private RendererMonitor theMonitor;
    private RenderingHints hints = null;
    private transient ChangeSupport changeSupport = null;
    private SequenceViewerSupport svSupport = new SequenceViewerSupport();
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent me) {
            if (!SequencePanel.this.isActive()) {
                return;
            }
            int[] dist = SequencePanel.this.calcDist();
            me.translatePoint(dist[0], dist[1]);
            SequenceViewerEvent sve = SequencePanel.this.renderer.processMouseEvent(SequencePanel.this, me, new ArrayList());
            me.translatePoint(-dist[0], -dist[1]);
            SequencePanel.this.svSupport.fireMouseClicked(sve);
        }

        public void mousePressed(MouseEvent me) {
            if (!SequencePanel.this.isActive()) {
                return;
            }
            int[] dist = SequencePanel.this.calcDist();
            me.translatePoint(dist[0], dist[1]);
            SequenceViewerEvent sve = SequencePanel.this.renderer.processMouseEvent(SequencePanel.this, me, new ArrayList());
            me.translatePoint(-dist[0], -dist[1]);
            SequencePanel.this.svSupport.fireMousePressed(sve);
        }

        public void mouseReleased(MouseEvent me) {
            if (!SequencePanel.this.isActive()) {
                return;
            }
            int[] dist = SequencePanel.this.calcDist();
            me.translatePoint(dist[0], dist[1]);
            SequenceViewerEvent sve = SequencePanel.this.renderer.processMouseEvent(SequencePanel.this, me, new ArrayList());
            me.translatePoint(-dist[0], -dist[1]);
            SequencePanel.this.svSupport.fireMouseReleased(sve);
        }
    };
    private SequenceViewerMotionSupport svmSupport = new SequenceViewerMotionSupport();
    private MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        public void mouseDragged(MouseEvent me) {
            if (!SequencePanel.this.isActive()) {
                return;
            }
            int[] dist = SequencePanel.this.calcDist();
            me.translatePoint(dist[0], dist[1]);
            SequenceViewerEvent sve = SequencePanel.this.renderer.processMouseEvent(SequencePanel.this, me, new ArrayList());
            me.translatePoint(-dist[0], -dist[1]);
            SequencePanel.this.svmSupport.fireMouseDragged(sve);
        }

        public void mouseMoved(MouseEvent me) {
            if (!SequencePanel.this.isActive()) {
                return;
            }
            int[] dist = SequencePanel.this.calcDist();
            me.translatePoint(dist[0], dist[1]);
            SequenceViewerEvent sve = SequencePanel.this.renderer.processMouseEvent(SequencePanel.this, me, new ArrayList());
            me.translatePoint(-dist[0], -dist[1]);
            SequencePanel.this.svmSupport.fireMouseMoved(sve);
        }
    };
    private ChangeListener layoutListener = new ChangeAdapter(){

        public void postChange(ChangeEvent ce) {
            System.err.println("Layout event");
            SequencePanel.this.resizeAndValidate();
        }
    };
    private ChangeListener repaintListener = new ChangeAdapter(){

        public void postChange(ChangeEvent ce) {
            System.err.println("Repaint event for " + this.hashCode());
            SequencePanel.this.repaint();
        }
    };

    public void setRenderingHints(RenderingHints hints) {
        this.hints = hints;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void addSequenceViewerListener(SequenceViewerListener svl) {
        this.svSupport.addSequenceViewerListener(svl);
    }

    public void removeSequenceViewerListener(SequenceViewerListener svl) {
        this.svSupport.removeSequenceViewerListener(svl);
    }

    public void addSequenceViewerMotionListener(SequenceViewerMotionListener svml) {
        this.svmSupport.addSequenceViewerMotionListener(svml);
    }

    public void removeSequenceViewerMotionListener(SequenceViewerMotionListener svml) {
        this.svmSupport.removeSequenceViewerMotionListener(svml);
    }

    protected boolean hasChangeListeners() {
        return this.changeSupport != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChangeSupport getChangeSupport(ChangeType ct) {
        if (this.changeSupport != null) {
            return this.changeSupport;
        }
        SequencePanel sequencePanel = this;
        synchronized (sequencePanel) {
            if (this.changeSupport == null) {
                this.changeSupport = new ChangeSupport();
            }
            return this.changeSupport;
        }
    }

    protected boolean hasListeners() {
        return this.changeSupport != null;
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        ChangeSupport cs = this.getChangeSupport(ct);
        cs.addChangeListener(cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(ct);
            cs.removeChangeListener(cl, ct);
        }
    }

    public boolean isUnchanging(ChangeType ct) {
        ChangeSupport cs = this.getChangeSupport(ct);
        return cs.isUnchanging(ct);
    }

    public SequencePanel() {
        this.theMonitor = new RendererMonitor();
        this.leadingBorder = new SequenceRenderContext.Border();
        this.trailingBorder = new SequenceRenderContext.Border();
        if (this.getFont() == null) {
            this.setFont(new Font("serif", 0, 12));
        }
        this.addPropertyChangeListener(this.theMonitor);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
    }

    public void setSequence(SymbolList s) {
        SymbolList oldSequence = this.sequence;
        if (oldSequence != null) {
            oldSequence.removeChangeListener(this.layoutListener, ChangeType.UNKNOWN);
        }
        this.sequence = s;
        if (s != null) {
            this.sequence.addChangeListener(this.layoutListener, ChangeType.UNKNOWN);
        }
        this.resizeAndValidate();
        this.firePropertyChange("sequence", oldSequence, s);
    }

    public SymbolList getSequence() {
        return this.sequence;
    }

    public SymbolList getSymbols() {
        return this.sequence;
    }

    public FeatureHolder getFeatures() {
        if (this.sequence instanceof FeatureHolder) {
            return (FeatureHolder)((Object)this.sequence);
        }
        return FeatureHolder.EMPTY_FEATURE_HOLDER;
    }

    public void setRange(RangeLocation range) {
        RangeLocation oldRange = this.range;
        this.range = range;
        this.resizeAndValidate();
        this.firePropertyChange("range", oldRange, range);
    }

    public RangeLocation getRange() {
        return this.range;
    }

    public void setDirection(int dir) throws IllegalArgumentException {
        if (dir != 0 && dir != 1) {
            throw new IllegalArgumentException("Direction must be either HORIZONTAL or VERTICAL");
        }
        int oldDirection = this.direction;
        this.direction = dir;
        this.resizeAndValidate();
        this.firePropertyChange("direction", oldDirection, this.direction);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setScale(double scale) {
        double oldScale = this.scale;
        this.scale = scale;
        this.resizeAndValidate();
        this.firePropertyChange("scale", oldScale, scale);
    }

    public double getScale() {
        return this.scale;
    }

    public SequenceRenderContext.Border getLeadingBorder() {
        return this.leadingBorder;
    }

    public SequenceRenderContext.Border getTrailingBorder() {
        return this.trailingBorder;
    }

    public synchronized void paintComponent(Graphics g) {
        if (!this.isActive()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.hints != null) {
            g2.setRenderingHints(this.hints);
        }
        super.paintComponent(g);
        AffineTransform oldTransform = g2.getTransform();
        Insets insets = this.getInsets();
        if (this.isOpaque()) {
            g2.setPaint(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.adjustOffset(this.sequenceToGraphics(this.range.getMin()));
        double minAcross = this.sequenceToGraphics(this.range.getMin()) - this.renderer.getMinimumLeader(this);
        double maxAcross = this.sequenceToGraphics(this.range.getMax()) + 1.0 + this.renderer.getMinimumTrailer(this);
        double alongDim = maxAcross - minAcross;
        double depth = this.renderer.getDepth(this);
        Rectangle2D.Double clip = new Rectangle2D.Double();
        if (this.direction == 0) {
            clip.x = minAcross;
            clip.y = 0.0;
            clip.width = alongDim;
            clip.height = depth;
            g2.translate(this.leadingBorder.getSize() - minAcross + (double)insets.left, (double)insets.top);
        } else {
            clip.x = 0.0;
            clip.y = minAcross;
            clip.width = depth;
            clip.height = alongDim;
            g2.translate((double)insets.left, this.leadingBorder.getSize() - minAcross + (double)insets.top);
        }
        Shape oldClip = g2.getClip();
        g2.clip(clip);
        this.renderer.paint(g2, new PaintContext());
        g2.setClip(oldClip);
        g2.setTransform(oldTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderer(SequenceRenderer r) throws ChangeVetoException {
        if (this.hasChangeListeners()) {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RENDERER, r, this.renderer);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RENDERER);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this._setRenderer(r);
                cs.firePostChangeEvent(ce);
            }
        } else {
            this._setRenderer(r);
        }
        this.resizeAndValidate();
    }

    protected void _setRenderer(SequenceRenderer r) {
        Changeable c;
        if (this.renderer != null && this.renderer instanceof Changeable) {
            c = (Changeable)((Object)this.renderer);
            c.removeChangeListener(this.layoutListener, SequenceRenderContext.LAYOUT);
            c.removeChangeListener(this.repaintListener, SequenceRenderContext.REPAINT);
        }
        this.renderer = r;
        if (r != null && r instanceof Changeable) {
            c = (Changeable)((Object)r);
            c.addChangeListener(this.layoutListener, SequenceRenderContext.LAYOUT);
            c.addChangeListener(this.repaintListener, SequenceRenderContext.REPAINT);
        }
    }

    private void adjustOffset(double newOrigin) {
        this.pixelOffset -= newOrigin;
    }

    public double sequenceToGraphics(int seqPos) {
        return (double)(seqPos - 1) * this.scale + this.pixelOffset;
    }

    public int graphicsToSequence(double gPos) {
        return (int)((gPos - this.pixelOffset) / this.scale) + 1;
    }

    public int graphicsToSequence(Point2D point) {
        if (this.direction == 0) {
            return this.graphicsToSequence(point.getX());
        }
        return this.graphicsToSequence(point.getY());
    }

    public void resizeAndValidate() {
        Dimension mind = null;
        Dimension maxd = null;
        if (!this.isActive()) {
            this.leadingBorder.setSize(0.0);
            this.trailingBorder.setSize(0.0);
            mind = maxd = new Dimension(0, 0);
        } else {
            double minAcross = this.sequenceToGraphics(this.range.getMin());
            double maxAcross = this.sequenceToGraphics(this.range.getMax());
            double maxDropAcross = this.sequenceToGraphics(this.range.getMax() - 1);
            double lb = this.renderer.getMinimumLeader(this);
            double tb = this.renderer.getMinimumTrailer(this) + this.trailingBorder.getSize();
            double alongDim = maxAcross - minAcross + lb + tb;
            double alongDropDim = maxDropAcross - minAcross + lb + tb;
            double depth = this.renderer.getDepth(this);
            if (this.direction == 0) {
                mind = new Dimension((int)Math.ceil(alongDropDim), (int)Math.ceil(depth));
                maxd = new Dimension((int)Math.ceil(alongDim), (int)Math.ceil(depth));
            } else {
                mind = new Dimension((int)Math.ceil(depth), (int)Math.ceil(alongDropDim));
                maxd = new Dimension((int)Math.ceil(depth), (int)Math.ceil(alongDim));
            }
        }
        this.setMinimumSize(mind);
        this.setPreferredSize(maxd);
        this.setMaximumSize(maxd);
        this.revalidate();
    }

    protected int[] calcDist() {
        double minAcross = this.sequenceToGraphics(this.range.getMin()) - this.renderer.getMinimumLeader(this);
        Insets insets = this.getInsets();
        int[] dist = new int[2];
        if (this.direction == 0) {
            dist[0] = (int)minAcross - insets.left;
            dist[1] = -insets.top;
        } else {
            dist[0] = -insets.left;
            dist[1] = (int)minAcross - insets.top;
        }
        return dist;
    }

    protected boolean isActive() {
        return this.sequence != null && this.renderer != null && this.range != null;
    }

    private boolean eq(Object a, Object b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SequencePanel)) {
            return false;
        }
        SequencePanel osp = (SequencePanel)o;
        return this.eq(this.getSymbols(), osp.getSymbols()) && this.eq(this.getRange(), osp.getRange());
    }

    public int hashCode() {
        RangeLocation l;
        int hc = 653;
        SymbolList sl = this.getSymbols();
        if (sl != null) {
            hc ^= sl.hashCode();
        }
        if ((l = this.getRange()) != null) {
            hc ^= ((Object)l).hashCode();
        }
        return hc;
    }

    private class PaintContext
    implements SequenceRenderContext {
        private final RangeLocation range;

        public PaintContext() {
            this.range = (RangeLocation)LocationTools.intersection(SequencePanel.this.getRange(), new RangeLocation(1, SequencePanel.this.getSequence().length()));
        }

        public RangeLocation getRange() {
            return this.range;
        }

        public int getDirection() {
            return SequencePanel.this.getDirection();
        }

        public double getScale() {
            return SequencePanel.this.getScale();
        }

        public double sequenceToGraphics(int i) {
            return SequencePanel.this.sequenceToGraphics(i);
        }

        public int graphicsToSequence(double d) {
            return SequencePanel.this.graphicsToSequence(d);
        }

        public int graphicsToSequence(Point2D point) {
            return SequencePanel.this.graphicsToSequence(point);
        }

        public SymbolList getSymbols() {
            return SequencePanel.this.getSymbols();
        }

        public FeatureHolder getFeatures() {
            return SequencePanel.this.getFeatures();
        }

        public SequenceRenderContext.Border getLeadingBorder() {
            return SequencePanel.this.getLeadingBorder();
        }

        public SequenceRenderContext.Border getTrailingBorder() {
            return SequencePanel.this.getTrailingBorder();
        }

        public Font getFont() {
            return SequencePanel.this.getFont();
        }
    }

    public class Border
    implements Serializable,
    SwingConstants {
        protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private double size = 0.0;
        private int alignment = 0;

        public double getSize() {
            return this.size;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public void setAlignment(int alignment) throws IllegalArgumentException {
            if (alignment != 10 && alignment != 11 && alignment != 0) {
                throw new IllegalArgumentException("Alignment must be one of the constants LEADING, TRAILING or CENTER");
            }
            int old = this.alignment;
            this.alignment = alignment;
            this.pcs.firePropertyChange("alignment", old, alignment);
        }

        private Border() {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    private class RendererMonitor
    implements PropertyChangeListener {
        private RendererMonitor() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            SequencePanel.this.repaint();
        }
    }
}

