/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class LinearAlphabetIndex
extends AbstractChangeable
implements AlphabetIndex,
Serializable {
    private Reference alphaRef;
    private Symbol[] symbols;

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        return super.getChangeSupport(ct);
    }

    public LinearAlphabetIndex(FiniteAlphabet alpha) {
        alpha.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
        this.alphaRef = new WeakReference<FiniteAlphabet>(alpha);
        this.symbols = this.buildIndex(alpha);
        alpha.removeChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    public LinearAlphabetIndex(Symbol[] syms) throws BioException {
        HashSet<Symbol> si = new HashSet<Symbol>();
        Symbol[] symbols = new Symbol[syms.length];
        for (int i = 0; i < syms.length; ++i) {
            Symbol s;
            symbols[i] = s = syms[i];
            si.add(s);
        }
        SimpleAlphabet alpha = new SimpleAlphabet(si);
        this.alphaRef = new WeakReference<SimpleAlphabet>(alpha);
        alpha.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
        this.symbols = symbols;
    }

    private Symbol[] buildIndex(FiniteAlphabet alpha) {
        Symbol[] symbols = new Symbol[alpha.size()];
        int i = 0;
        Iterator s = alpha.iterator();
        while (s.hasNext()) {
            symbols[i++] = (Symbol)s.next();
        }
        return symbols;
    }

    public FiniteAlphabet getAlphabet() {
        return (FiniteAlphabet)this.alphaRef.get();
    }

    public Symbol symbolForIndex(int i) throws IndexOutOfBoundsException {
        try {
            return this.symbols[i];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Can't find symbol for index " + i);
        }
    }

    public int indexForSymbol(Symbol s) throws IllegalSymbolException {
        for (int i = 0; i < this.symbols.length; ++i) {
            if (s != this.symbols[i]) continue;
            return i;
        }
        this.getAlphabet().validate(s);
        if (s instanceof AtomicSymbol) {
            throw new BioError("Assertion Failure: Symbol " + s.getName() + " was not an indexed member of the alphabet " + this.getAlphabet().getName() + " despite being in the alphabet.");
        }
        throw new IllegalSymbolException("Symbol must be atomic to be indexed.");
    }

    protected class IndexRebuilder
    extends ChangeForwarder {
        public IndexRebuilder() {
            super(LinearAlphabetIndex.this, LinearAlphabetIndex.this.getChangeSupport(AlphabetIndex.INDEX));
        }

        public ChangeEvent generateEvent(ChangeEvent ce) throws ChangeVetoException {
            if (ce.getType() != Alphabet.SYMBOLS) {
                return null;
            }
            return new ChangeEvent(this.getSource(), AlphabetIndex.INDEX, LinearAlphabetIndex.this.buildIndex((FiniteAlphabet)ce.getSource()), LinearAlphabetIndex.this.symbols, ce);
        }
    }
}

