/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.regex;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.regex.Matcher;
import org.biojava.utils.regex.Pattern;
import org.biojava.utils.regex.PatternFactory;
import org.biojava.utils.regex.RegexException;

public class Search {
    private Listener listener = null;
    private PatternFactory factory;
    private Set patterns = new HashSet();

    public Search(FiniteAlphabet alfa) {
        this.factory = PatternFactory.makeFactory(alfa);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void addPattern(String patternString, boolean overlap) throws RegexException, IllegalAlphabetException {
        Pattern pattern = this.factory.compile(patternString);
        PatternInfo info = new PatternInfo();
        info.patternString = patternString;
        info.pattern = pattern;
        info.overlap = overlap;
        this.patterns.add(info);
    }

    public void addPattern(String label, String patternString, boolean overlap) throws RegexException, IllegalAlphabetException {
        Pattern pattern = this.factory.compile(patternString, label);
        PatternInfo info = new PatternInfo();
        info.patternString = patternString;
        info.pattern = pattern;
        info.overlap = overlap;
        this.patterns.add(info);
    }

    public void clearPatterns() {
        this.patterns.clear();
    }

    public char charValue(Symbol sym) throws IllegalSymbolException {
        return this.factory.charValue(sym);
    }

    public void search(SymbolList seq) {
        this.search(seq, 1, seq.length());
    }

    public void search(SymbolList seq, int loLimit, int hiLimit) {
        Iterator patternsI = this.patterns.iterator();
        block0: while (patternsI.hasNext()) {
            PatternInfo info = (PatternInfo)patternsI.next();
            if (info.matcher == null) {
                info.matcher = info.pattern.matcher(seq);
            } else {
                info.matcher = info.matcher.reset(seq);
            }
            int begin = loLimit;
            while (info.matcher.find(begin)) {
                int start = info.matcher.start();
                int end = info.matcher.end();
                if (this.listener != null && start <= hiLimit && !this.listener.reportMatch(seq, info.pattern, start, end)) {
                    return;
                }
                begin = info.overlap ? start + 1 : end;
                if (begin < hiLimit) continue;
                continue block0;
            }
        }
    }

    private class PatternInfo {
        private String patternString;
        private Pattern pattern = null;
        private Matcher matcher = null;
        private boolean overlap;

        private PatternInfo() {
        }

        public boolean equals(Object o) {
            if (o instanceof PatternInfo) {
                PatternInfo other = (PatternInfo)o;
                return this.patternString.equals(other.patternString);
            }
            return false;
        }

        public int hashCode() {
            return this.patternString.hashCode();
        }
    }

    public static interface Listener {
        public boolean reportMatch(SymbolList var1, Pattern var2, int var3, int var4);
    }
}

