/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.walker;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ClassTools;
import org.biojava.utils.bytecode.ByteCode;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.GeneratedClassLoader;
import org.biojava.utils.bytecode.GeneratedCodeClass;
import org.biojava.utils.bytecode.GeneratedCodeMethod;
import org.biojava.utils.bytecode.IfExpression;
import org.biojava.utils.bytecode.InstructionVector;
import org.biojava.utils.bytecode.IntrospectedCodeClass;
import org.biojava.utils.bytecode.LocalVariable;
import org.biojava.utils.walker.Visitor;
import org.biojava.utils.walker.Walker;

public class WalkerFactory {
    private static Map factories = new HashMap();
    private final Map walkers = new HashMap();
    private final GeneratedClassLoader classLoader = new GeneratedClassLoader(ClassTools.getClassLoader(this));
    private final List typesWithParents = new ArrayList();
    private final Class typeClazz;

    public static synchronized WalkerFactory getInstance(Class typeClazz) {
        String typeName = typeClazz.getName();
        WalkerFactory instance = (WalkerFactory)factories.get(typeName);
        if (instance == null) {
            instance = new WalkerFactory(typeClazz);
            factories.put(typeName, instance);
        }
        return instance;
    }

    public static synchronized WalkerFactory getInstance() {
        return WalkerFactory.getInstance(FeatureFilter.class);
    }

    private WalkerFactory(Class typeClazz) {
        this.typeClazz = typeClazz;
    }

    public Class getTypeClass() {
        return this.typeClazz;
    }

    public synchronized void addTypeWithParent(Class type) {
        if (!this.typesWithParents.contains(type)) {
            this.typesWithParents.add(type);
        }
    }

    public synchronized Walker getWalker(Visitor visitor) throws BioException {
        Class walkerClass = (Class)this.walkers.get(visitor.getClass());
        if (walkerClass == null) {
            walkerClass = this.generateWalker(visitor.getClass());
            this.walkers.put(visitor.getClass(), walkerClass);
        }
        try {
            return (Walker)walkerClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new AssertionFailure("Could not instantiate walker for class: " + walkerClass, ie);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionFailure("Could not instantiate walker for class: " + walkerClass, iae);
        }
    }

    private Class generateWalker(Class visitorClass) throws BioException {
        try {
            String vcn = visitorClass.getName().replaceAll("\\$", "_");
            String walkerClassName = vcn + "_walker";
            CodeClass c_Visitor = IntrospectedCodeClass.forClass((Class)Visitor.class);
            CodeClass c_ourVisitor = IntrospectedCodeClass.forClass((Class)visitorClass);
            CodeClass c_Walker = IntrospectedCodeClass.forClass((Class)Walker.class);
            CodeClass c_WalkerBase = IntrospectedCodeClass.forClass((Class)Object.class);
            CodeClass c_Object = IntrospectedCodeClass.forClass((Class)Object.class);
            GeneratedCodeClass walkerClass = new GeneratedCodeClass(walkerClassName, c_WalkerBase, new CodeClass[]{c_Walker}, 33);
            Method[] methods = visitorClass.getMethods();
            ArrayList<Method> visitorMeths = new ArrayList<Method>();
            Class<Void> retClass = null;
            for (int mi = 0; mi < methods.length; ++mi) {
                Method method = methods[mi];
                Class<?> ret = method.getReturnType();
                Class<?>[] args = method.getParameterTypes();
                if (args.length <= 0) continue;
                Class<?> arg0 = args[0];
                String methName = method.getName();
                String arg0Name = arg0.getName();
                int doli = arg0Name.lastIndexOf(36);
                if (doli >= 0) {
                    arg0Name = arg0Name.substring(doli + 1);
                }
                if ((doli = arg0Name.lastIndexOf(46)) >= 0) {
                    arg0Name = arg0Name.substring(doli + 1);
                }
                if (!(arg0Name = arg0Name.substring(0, 1).toLowerCase() + arg0Name.substring(1)).equals(methName) || !this.typeClazz.isAssignableFrom(arg0)) continue;
                if (retClass == null) {
                    retClass = ret;
                } else if (retClass != ret) {
                    throw new BioException("Return type of all methods must agree. We were expecting: " + retClass.getName() + " but found: " + ret.getName());
                }
                for (int ai = 1; ai < args.length; ++ai) {
                    Class<?> argI = args[ai];
                    if (argI == retClass) continue;
                    throw new BioException("The first argument to a handler method must be a " + this.typeClazz.toString() + "All subsequent arguments must match the return type.  In: " + method);
                }
                visitorMeths.add(method);
            }
            if (retClass == null) {
                retClass = Void.TYPE;
            }
            Collections.sort(visitorMeths, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Method m2;
                    Class<?> c2;
                    Method m1 = (Method)o1;
                    Class<?> c1 = m1.getParameterTypes()[0];
                    if (c1.isAssignableFrom(c2 = (m2 = (Method)o2).getParameterTypes()[0])) {
                        return 1;
                    }
                    if (c2.isAssignableFrom(c1)) {
                        return -1;
                    }
                    return 0;
                }
            });
            CodeClass c_retClass = IntrospectedCodeClass.forClass(retClass);
            CodeClass[] walkParams = new CodeClass[]{c_Object, c_Visitor};
            GeneratedCodeMethod doWalk = walkerClass.createMethod("doWalk", c_retClass, walkParams, new String[]{"target", "visitor"}, 1);
            InstructionVector walkIV = new InstructionVector();
            LocalVariable lv_target = doWalk.getVariable("target");
            LocalVariable lv_visitor = doWalk.getVariable("visitor");
            LocalVariable lv_visitor2 = new LocalVariable(c_ourVisitor, "visitor2");
            walkIV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)lv_visitor));
            walkIV.add((CodeGenerator)ByteCode.make_checkcast((CodeClass)c_ourVisitor));
            walkIV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)lv_visitor2));
            ArrayList<LocalVariable> wrappedLVs = new ArrayList<LocalVariable>();
            InstructionVector wrapperIV = new InstructionVector();
            Iterator fwpi = this.typesWithParents.iterator();
            while (fwpi.hasNext()) {
                InstructionVector wfiv = new InstructionVector();
                Class filtClass = (Class)fwpi.next();
                CodeClass c_ourType = IntrospectedCodeClass.forClass((Class)filtClass);
                Method[] filtMeth = filtClass.getMethods();
                int lvi = 0;
                for (int mi = 0; mi < filtMeth.length; ++mi) {
                    Method m = filtMeth[mi];
                    if (m.getParameterTypes().length != 0 || !this.typeClazz.isAssignableFrom(m.getReturnType())) continue;
                    CodeMethod m_getChild = IntrospectedCodeClass.forMethod((Method)m);
                    LocalVariable lv = null;
                    if (c_retClass != CodeUtils.TYPE_VOID) {
                        if (lvi < wrappedLVs.size()) {
                            lv = (LocalVariable)wrappedLVs.get(lvi);
                        } else {
                            lv = new LocalVariable(c_retClass);
                            wrappedLVs.add(lv);
                        }
                        ++lvi;
                    }
                    wfiv.add((CodeGenerator)ByteCode.make_aload((LocalVariable)doWalk.getThis()));
                    wfiv.add((CodeGenerator)ByteCode.make_aload((LocalVariable)lv_target));
                    wfiv.add((CodeGenerator)ByteCode.make_checkcast((CodeClass)c_ourType));
                    wfiv.add((CodeGenerator)ByteCode.make_invokevirtual((CodeMethod)m_getChild));
                    wfiv.add((CodeGenerator)ByteCode.make_aload((LocalVariable)lv_visitor));
                    wfiv.add((CodeGenerator)ByteCode.make_invokevirtual((CodeMethod)doWalk));
                    if (c_retClass == CodeUtils.TYPE_VOID) continue;
                    wfiv.add((CodeGenerator)ByteCode.make_astore((LocalVariable)lv));
                }
                wrapperIV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)lv_target));
                wrapperIV.add((CodeGenerator)ByteCode.make_instanceof((CodeClass)c_ourType));
                wrapperIV.add((CodeGenerator)new IfExpression(-102, (CodeGenerator)wfiv, CodeUtils.DO_NOTHING));
            }
            Iterator lvi = wrappedLVs.iterator();
            while (lvi.hasNext()) {
                LocalVariable lv = (LocalVariable)lvi.next();
                walkIV.add((CodeGenerator)ByteCode.make_aconst_null());
                walkIV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)lv));
            }
            walkIV.add((CodeGenerator)wrapperIV);
            Iterator mi = visitorMeths.iterator();
            while (mi.hasNext()) {
                Method meth = (Method)mi.next();
                CodeMethod ourMeth = IntrospectedCodeClass.forMethod((Method)meth);
                CodeClass c_thisFiltType = ourMeth.getParameterType(0);
                InstructionVector bodyIV = new InstructionVector();
                bodyIV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)lv_visitor2));
                bodyIV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)lv_target));
                bodyIV.add((CodeGenerator)ByteCode.make_checkcast((CodeClass)c_thisFiltType));
                for (int ai = 1; ai < ourMeth.numParameters(); ++ai) {
                    bodyIV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)((LocalVariable)wrappedLVs.get(ai - 1))));
                }
                bodyIV.add((CodeGenerator)ByteCode.make_invokevirtual((CodeMethod)ourMeth));
                bodyIV.add((CodeGenerator)ByteCode.make_return((CodeMethod)doWalk));
                walkIV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)lv_target));
                walkIV.add((CodeGenerator)ByteCode.make_instanceof((CodeClass)c_thisFiltType));
                walkIV.add((CodeGenerator)new IfExpression(-102, (CodeGenerator)bodyIV, CodeUtils.DO_NOTHING));
            }
            if (c_retClass == CodeUtils.TYPE_VOID) {
                walkIV.add((CodeGenerator)ByteCode.make_return());
            } else {
                walkIV.add((CodeGenerator)ByteCode.make_aconst_null());
                walkIV.add((CodeGenerator)ByteCode.make_areturn());
            }
            walkerClass.setCodeGenerator((CodeMethod)doWalk, (CodeGenerator)walkIV);
            CodeField f_value = null;
            if (c_retClass != CodeUtils.TYPE_VOID) {
                f_value = walkerClass.createField("value", CodeUtils.TYPE_OBJECT, 2);
            }
            GeneratedCodeMethod walkImpl = walkerClass.createMethod("walk", CodeUtils.TYPE_VOID, walkParams, 1);
            InstructionVector wiIV = new InstructionVector();
            if (c_retClass != CodeUtils.TYPE_VOID) {
                wiIV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)walkImpl.getThis()));
            }
            wiIV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)walkImpl.getThis()));
            wiIV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)walkImpl.getVariable(0)));
            wiIV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)walkImpl.getVariable(1)));
            wiIV.add((CodeGenerator)ByteCode.make_invokevirtual((CodeMethod)doWalk));
            if (c_retClass != CodeUtils.TYPE_VOID) {
                wiIV.add((CodeGenerator)ByteCode.make_putfield((CodeField)f_value));
            }
            wiIV.add((CodeGenerator)ByteCode.make_return());
            walkerClass.setCodeGenerator((CodeMethod)walkImpl, (CodeGenerator)wiIV);
            GeneratedCodeMethod getValue = walkerClass.createMethod("getValue", CodeUtils.TYPE_OBJECT, CodeUtils.EMPTY_LIST, 1);
            InstructionVector gvIV = new InstructionVector();
            if (c_retClass == CodeUtils.TYPE_VOID) {
                gvIV.add((CodeGenerator)ByteCode.make_aconst_null());
            } else {
                gvIV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)getValue.getThis()));
                gvIV.add((CodeGenerator)ByteCode.make_getfield((CodeField)f_value));
            }
            gvIV.add((CodeGenerator)ByteCode.make_areturn());
            walkerClass.setCodeGenerator((CodeMethod)getValue, (CodeGenerator)gvIV);
            CodeMethod m_WalkerBase_init = c_WalkerBase.getConstructor(CodeUtils.EMPTY_LIST);
            GeneratedCodeMethod init = walkerClass.createMethod("<init>", CodeUtils.TYPE_VOID, CodeUtils.EMPTY_LIST, 1);
            InstructionVector initIV = new InstructionVector();
            initIV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)init.getThis()));
            initIV.add((CodeGenerator)ByteCode.make_invokespecial((CodeMethod)m_WalkerBase_init));
            if (c_retClass != CodeUtils.TYPE_VOID) {
                initIV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)init.getThis()));
                initIV.add((CodeGenerator)ByteCode.make_aconst_null());
                initIV.add((CodeGenerator)ByteCode.make_putfield((CodeField)f_value));
            }
            initIV.add((CodeGenerator)ByteCode.make_return());
            walkerClass.setCodeGenerator((CodeMethod)init, (CodeGenerator)initIV);
            return this.classLoader.defineClass(walkerClass);
        }
        catch (CodeException ce) {
            throw new AssertionFailure("Unable to generate walker code", ce);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionFailure("Unable to generate walker code", nsme);
        }
    }
}

