/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import java.nio.ByteBuffer;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLSparse
extends MLNumericArray<Double> {
    int nzmax;
    private SortedSet<IndexMN> indexSet;
    private SortedMap<IndexMN, Double> real;
    private SortedMap<IndexMN, Double> imaginary;

    public MLSparse(String string, int[] nArray, int n, int n2) {
        super(string, nArray, 5, n);
        this.nzmax = n2;
        this.real = new TreeMap<IndexMN, Double>();
        this.imaginary = new TreeMap<IndexMN, Double>();
        this.indexSet = new TreeSet<IndexMN>();
    }

    public int getMaxNZ() {
        return this.nzmax;
    }

    public int[] getIR() {
        int[] nArray = new int[this.nzmax];
        int n = 0;
        for (IndexMN indexMN : this.indexSet) {
            nArray[n++] = indexMN.m;
        }
        return nArray;
    }

    public int[] getJC() {
        int[] nArray = new int[this.getN() + 1];
        for (IndexMN indexMN : this.indexSet) {
            int n = indexMN.n + 1;
            while (n < nArray.length) {
                int n2 = n++;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        return nArray;
    }

    public Double[] createArray(int n, int n2) {
        return null;
    }

    @Override
    public Double getReal(int n, int n2) {
        IndexMN indexMN = new IndexMN(n, n2);
        if (this.real.containsKey(indexMN)) {
            return (Double)this.real.get(indexMN);
        }
        return new Double(0.0);
    }

    @Override
    public Double getReal(int n) {
        throw new IllegalArgumentException("Can't get Sparse array elements by index. Please use getReal(int index) instead.");
    }

    @Override
    public void setReal(Double d, int n, int n2) {
        IndexMN indexMN = new IndexMN(n, n2);
        this.indexSet.add(indexMN);
        this.real.put(indexMN, d);
    }

    @Override
    public void setReal(Double d, int n) {
        throw new IllegalArgumentException("Can't set Sparse array elements by index. Please use setReal(Double value, int m, int n) instead.");
    }

    @Override
    public void setImaginary(Double d, int n, int n2) {
        IndexMN indexMN = new IndexMN(n, n2);
        this.indexSet.add(indexMN);
        this.imaginary.put(indexMN, d);
    }

    @Override
    public void setImaginary(Double d, int n) {
        throw new IllegalArgumentException("Can't set Sparse array elements by index. Please use setImaginary(Double value, int m, int n) instead.");
    }

    @Override
    public Double getImaginary(int n, int n2) {
        IndexMN indexMN = new IndexMN(n, n2);
        if (this.imaginary.containsKey(indexMN)) {
            return (Double)this.imaginary.get(indexMN);
        }
        return new Double(0.0);
    }

    @Override
    public Double getImaginary(int n) {
        throw new IllegalArgumentException("Can't get Sparse array elements by index. Please use getImaginary(int index) instead.");
    }

    public Double[] exportReal() {
        Double[] doubleArray = new Double[this.indexSet.size()];
        int n = 0;
        for (IndexMN indexMN : this.indexSet) {
            doubleArray[n] = this.real.containsKey(indexMN) ? (Double)this.real.get(indexMN) : Double.valueOf(0.0);
            ++n;
        }
        return doubleArray;
    }

    public Double[] exportImaginary() {
        Double[] doubleArray = new Double[this.indexSet.size()];
        int n = 0;
        for (IndexMN indexMN : this.indexSet) {
            doubleArray[n] = this.imaginary.containsKey(indexMN) ? (Double)this.imaginary.get(indexMN) : Double.valueOf(0.0);
            ++n;
        }
        return doubleArray;
    }

    @Override
    public String contentToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name + " = \n");
        for (IndexMN indexMN : this.indexSet) {
            stringBuffer.append("\t(");
            stringBuffer.append(indexMN.m + "," + indexMN.n);
            stringBuffer.append(")");
            stringBuffer.append("\t" + this.getReal(indexMN.m, indexMN.n));
            if (this.isComplex()) {
                stringBuffer.append("+" + this.getImaginary(indexMN.m, indexMN.n));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public int getBytesAllocated() {
        return 512;
    }

    @Override
    public Double buldFromBytes(byte[] byArray) {
        if (byArray.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return ByteBuffer.wrap(byArray).getDouble();
    }

    @Override
    public byte[] getByteArray(Double d) {
        int n = this.getBytesAllocated();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.putDouble(d);
        return byteBuffer.array();
    }

    @Override
    public Class<Double> getStorageClazz() {
        return Double.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexMN
    implements Comparable<IndexMN> {
        int m;
        int n;

        public IndexMN(int n, int n2) {
            this.m = n;
            this.n = n2;
        }

        @Override
        public int compareTo(IndexMN indexMN) {
            return MLSparse.this.getIndex(this.m, this.n) - MLSparse.this.getIndex(indexMN.m, indexMN.n);
        }

        public boolean equals(Object object) {
            if (object instanceof IndexMN) {
                return this.m == ((IndexMN)object).m && this.n == ((IndexMN)object).n;
            }
            return super.equals(object);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("m=" + this.m);
            stringBuffer.append(", ");
            stringBuffer.append("n=" + this.n);
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }
}

