/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.alignment.SequenceAlignment;
import org.biojava.bio.alignment.SubstitutionMatrix;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.impl.SimpleGappedSequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;

public class NeedlemanWunsch
extends SequenceAlignment {
    protected double[][] CostMatrix;
    protected SubstitutionMatrix subMatrix;
    protected Alignment pairalign;
    protected String alignment;
    private double insert;
    private double delete;
    private double gapExt;
    private double match;
    private double replace;

    public NeedlemanWunsch(double match, double replace, double insert, double delete, double gapExtend, SubstitutionMatrix subMat) {
        this.subMatrix = subMat;
        this.insert = insert;
        this.delete = delete;
        this.gapExt = gapExtend;
        this.match = match;
        this.replace = replace;
        this.alignment = "";
    }

    public void setSubstitutionMatrix(SubstitutionMatrix matrix) {
        this.subMatrix = matrix;
    }

    public void setInsert(double ins) {
        this.insert = ins;
    }

    public void setDelete(double del) {
        this.delete = del;
    }

    public void setGapExt(double ge) {
        this.gapExt = ge;
    }

    public void setMatch(double ma) {
        this.match = ma;
    }

    public void setReplace(double rep) {
        this.replace = rep;
    }

    public double getInsert() {
        return this.insert;
    }

    public double getDelete() {
        return this.delete;
    }

    public double getGapExt() {
        return this.gapExt;
    }

    public double getMatch() {
        return this.match;
    }

    public double getReplace() {
        return this.replace;
    }

    public static String printCostMatrix(double[][] CostMatrix, char[] queryChar, char[] targetChar) {
        int line;
        int col;
        String output = "\t";
        for (col = 0; col <= targetChar.length; ++col) {
            output = col == 0 ? output + "[" + col + "]\t" : output + "[" + targetChar[col - 1] + "]\t";
        }
        for (line = 0; line <= queryChar.length; ++line) {
            output = line == 0 ? output + "\n[" + line + "]\t" : output + "\n[" + queryChar[line - 1] + "]\t";
            for (col = 0; col <= targetChar.length; ++col) {
                output = output + CostMatrix[line][col] + "\t";
            }
        }
        output = output + "\ndelta[Edit] = " + CostMatrix[line - 1][col - 1] + "\n";
        return output;
    }

    public static void printAlignment(String align) {
        System.out.print(align);
    }

    public Alignment getAlignment(Sequence query, Sequence target) throws Exception {
        this.pairwiseAlignment(query, target);
        return this.pairalign;
    }

    public double getEditDistance() {
        return this.CostMatrix[this.CostMatrix.length - 1][this.CostMatrix[this.CostMatrix.length - 1].length - 1];
    }

    protected static double min(double x, double y, double z) {
        if (x < y && x < z) {
            return x;
        }
        if (y < z) {
            return y;
        }
        return z;
    }

    public String getAlignmentString() throws BioException {
        return this.alignment;
    }

    public List alignAll(SequenceIterator source, SequenceDB subjectDB) throws NoSuchElementException, BioException {
        LinkedList<Alignment> l = new LinkedList<Alignment>();
        while (source.hasNext()) {
            Sequence query = source.nextSequence();
            SequenceIterator target = subjectDB.sequenceIterator();
            while (target.hasNext()) {
                try {
                    l.add(this.getAlignment(query, target.nextSequence()));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        return l;
    }

    public double pairwiseAlignment(Sequence query, Sequence subject) throws BioRuntimeException {
        if (query.getAlphabet().equals(subject.getAlphabet()) && query.getAlphabet().equals(this.subMatrix.getAlphabet())) {
            int j;
            int i;
            long time = System.currentTimeMillis();
            this.CostMatrix = new double[query.length() + 1][subject.length() + 1];
            String[] align = new String[]{"", ""};
            String path = "";
            this.CostMatrix[0][0] = 0.0;
            if (this.gapExt != this.delete || this.gapExt != this.insert) {
                int j2;
                int i2;
                double[][] E = new double[query.length() + 1][subject.length() + 1];
                double[][] F = new double[query.length() + 1][subject.length() + 1];
                F[0][0] = Double.MAX_VALUE;
                E[0][0] = Double.MAX_VALUE;
                for (i2 = 1; i2 <= query.length(); ++i2) {
                    E[i2][0] = Double.POSITIVE_INFINITY;
                    double d = this.delete + (double)i2 * this.gapExt;
                    F[i2][0] = d;
                    this.CostMatrix[i2][0] = d;
                }
                for (j2 = 1; j2 <= subject.length(); ++j2) {
                    F[0][j2] = Double.POSITIVE_INFINITY;
                    double d = this.insert + (double)j2 * this.gapExt;
                    E[0][j2] = d;
                    this.CostMatrix[0][j2] = d;
                }
                for (i2 = 1; i2 <= query.length(); ++i2) {
                    for (j2 = 1; j2 <= subject.length(); ++j2) {
                        E[i2][j2] = Math.min(E[i2][j2 - 1], this.CostMatrix[i2][j2 - 1] + this.insert) + this.gapExt;
                        F[i2][j2] = Math.min(F[i2 - 1][j2], this.CostMatrix[i2 - 1][j2] + this.delete) + this.gapExt;
                        this.CostMatrix[i2][j2] = NeedlemanWunsch.min(E[i2][j2], F[i2][j2], this.CostMatrix[i2 - 1][j2 - 1] - this.matchReplace(query, subject, i2, j2));
                    }
                }
                try {
                    boolean[] gap_extend = new boolean[]{false, false};
                    j2 = this.CostMatrix[this.CostMatrix.length - 1].length - 1;
                    SymbolTokenization st = this.subMatrix.getAlphabet().getTokenization("default");
                    i2 = this.CostMatrix.length - 1;
                    while (i2 > 0) {
                        do {
                            if (i2 == 0) {
                                align[0] = '~' + align[0];
                                align[1] = st.tokenizeSymbol(subject.symbolAt(j2--)) + align[1];
                                path = ' ' + path;
                                continue;
                            }
                            if (j2 == 0) {
                                align[0] = st.tokenizeSymbol(query.symbolAt(i2--)) + align[0];
                                align[1] = '~' + align[1];
                                path = ' ' + path;
                                continue;
                            }
                            if (this.CostMatrix[i2][j2] == this.CostMatrix[i2 - 1][j2 - 1] - this.matchReplace(query, subject, i2, j2) && !gap_extend[0] && !gap_extend[1]) {
                                path = query.symbolAt(i2) == subject.symbolAt(j2) ? '|' + path : ' ' + path;
                                align[0] = st.tokenizeSymbol(query.symbolAt(i2--)) + align[0];
                                align[1] = st.tokenizeSymbol(subject.symbolAt(j2--)) + align[1];
                                continue;
                            }
                            if (this.CostMatrix[i2][j2] == E[i2][j2] || gap_extend[0]) {
                                gap_extend[0] = E[i2][j2] != this.CostMatrix[i2][j2 - 1] + this.insert + this.gapExt;
                                align[0] = '-' + align[0];
                                align[1] = st.tokenizeSymbol(subject.symbolAt(j2--)) + align[1];
                                path = ' ' + path;
                                continue;
                            }
                            gap_extend[1] = F[i2][j2] != this.CostMatrix[i2 - 1][j2] + this.delete + this.gapExt;
                            align[0] = st.tokenizeSymbol(query.symbolAt(i2--)) + align[0];
                            align[1] = '-' + align[1];
                            path = ' ' + path;
                        } while (j2 > 0);
                    }
                }
                catch (BioException exc) {
                    throw new BioRuntimeException(exc);
                }
            }
            for (i = 1; i <= query.length(); ++i) {
                this.CostMatrix[i][0] = this.CostMatrix[i - 1][0] + this.delete;
            }
            for (j = 1; j <= subject.length(); ++j) {
                this.CostMatrix[0][j] = this.CostMatrix[0][j - 1] + this.insert;
            }
            for (i = 1; i <= query.length(); ++i) {
                for (j = 1; j <= subject.length(); ++j) {
                    this.CostMatrix[i][j] = NeedlemanWunsch.min(this.CostMatrix[i - 1][j] + this.delete, this.CostMatrix[i][j - 1] + this.insert, this.CostMatrix[i - 1][j - 1] - this.matchReplace(query, subject, i, j));
                }
            }
            try {
                j = this.CostMatrix[this.CostMatrix.length - 1].length - 1;
                SymbolTokenization st = this.subMatrix.getAlphabet().getTokenization("default");
                i = this.CostMatrix.length - 1;
                while (i > 0) {
                    do {
                        if (i == 0) {
                            align[0] = '~' + align[0];
                            align[1] = st.tokenizeSymbol(subject.symbolAt(j--)) + align[1];
                            path = ' ' + path;
                            continue;
                        }
                        if (j == 0) {
                            align[0] = st.tokenizeSymbol(query.symbolAt(i--)) + align[0];
                            align[1] = '~' + align[1];
                            path = ' ' + path;
                            continue;
                        }
                        if (this.CostMatrix[i][j] == this.CostMatrix[i - 1][j - 1] - this.matchReplace(query, subject, i, j)) {
                            path = query.symbolAt(i) == subject.symbolAt(j) ? '|' + path : ' ' + path;
                            align[0] = st.tokenizeSymbol(query.symbolAt(i--)) + align[0];
                            align[1] = st.tokenizeSymbol(subject.symbolAt(j--)) + align[1];
                            continue;
                        }
                        if (this.CostMatrix[i][j] == this.CostMatrix[i][j - 1] + this.insert) {
                            align[0] = '-' + align[0];
                            align[1] = st.tokenizeSymbol(subject.symbolAt(j--)) + align[1];
                            path = ' ' + path;
                            continue;
                        }
                        align[0] = st.tokenizeSymbol(query.symbolAt(i--)) + align[0];
                        align[1] = '-' + align[1];
                        path = ' ' + path;
                    } while (j > 0);
                }
            }
            catch (BioException exc) {
                throw new BioRuntimeException(exc);
            }
            try {
                query = new SimpleGappedSequence(new SimpleSequence(new SimpleSymbolList(query.getAlphabet().getTokenization("token"), align[0]), query.getURN(), query.getName(), query.getAnnotation()));
                subject = new SimpleGappedSequence(new SimpleSequence(new SimpleSymbolList(subject.getAlphabet().getTokenization("token"), align[1]), subject.getURN(), subject.getName(), subject.getAnnotation()));
                HashMap<String, Sequence> m = new HashMap<String, Sequence>();
                m.put(query.getName(), query);
                m.put(subject.getName(), subject);
                this.pairalign = new SimpleAlignment(m);
                this.alignment = NeedlemanWunsch.formatOutput(query.getName(), subject.getName(), align, path, 0, this.CostMatrix.length - 1, this.CostMatrix.length - 1, 0, this.CostMatrix[0].length - 1, this.CostMatrix[0].length - 1, this.getEditDistance(), System.currentTimeMillis() - time) + "\n";
                return this.getEditDistance();
            }
            catch (BioException exc) {
                throw new BioRuntimeException(exc);
            }
        }
        throw new BioRuntimeException("Alphabet missmatch occured: sequences with different alphabet cannot be aligned.");
    }

    private double matchReplace(Sequence query, Sequence subject, int i, int j) {
        try {
            return this.subMatrix.getValueAt(query.symbolAt(i), subject.symbolAt(j));
        }
        catch (Exception exc) {
            if (query.symbolAt(i).getMatches().contains(subject.symbolAt(j)) || subject.symbolAt(j).getMatches().contains(query.symbolAt(i))) {
                return -this.match;
            }
            return -this.replace;
        }
    }
}

