/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelName;
import cytoscape.view.cytopanels.CytoPanelState;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.event.MenuEvent;

public class CytoPanelAction
extends CytoscapeAction {
    protected static String SHOW = "Show";
    protected static String HIDE = "Hide";
    protected String title;
    protected int position;

    public CytoPanelAction(JCheckBoxMenuItem menuItem, CytoPanel cytoPanel) {
        this(cytoPanel.getTitle(), cytoPanel.getCompassDirection(), menuItem.isSelected());
    }

    public CytoPanelAction(CytoPanelName cp, boolean show) {
        this(cp.getTitle(), cp.getCompassDirection(), show);
    }

    private CytoPanelAction(String title, int position, boolean show) {
        super(show ? HIDE + " " + title : SHOW + " " + title);
        this.title = title;
        this.position = position;
        this.setPreferredMenu("View");
    }

    public void actionPerformed(ActionEvent ev) {
        CytoPanelState curState = Cytoscape.getDesktop().getCytoPanel(this.position).getState();
        if (curState == CytoPanelState.HIDE) {
            Cytoscape.getDesktop().getCytoPanel(this.position).setState(CytoPanelState.DOCK);
        } else {
            Cytoscape.getDesktop().getCytoPanel(this.position).setState(CytoPanelState.HIDE);
        }
    }

    public void menuSelected(MenuEvent me) {
        CytoPanelState curState = Cytoscape.getDesktop().getCytoPanel(this.position).getState();
        if (curState == CytoPanelState.HIDE) {
            this.putValue("Name", SHOW + " " + this.title);
        } else {
            this.putValue("Name", HIDE + " " + this.title);
        }
    }
}

