/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.actions.DeleteEdit;
import cytoscape.logger.CyLogger;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.undo.CyUndo;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.GraphObject;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.MenuEvent;

public class DeleteAction
extends CytoscapeAction {
    private static final long serialVersionUID = -5769255815829787466L;
    public static final String ACTION_TITLE = "Delete Selected Nodes and Edges";
    private GraphObject graphObj = null;

    public DeleteAction() {
        this((GraphObject)null);
    }

    public DeleteAction(GraphObject obj) {
        super(ACTION_TITLE);
        CyLogger.getLogger().info("starting delete action");
        this.setPreferredMenu("Edit");
        this.setAcceleratorCombo(127, 0);
        this.graphObj = obj;
        CyLogger.getLogger().info("ending delete action");
    }

    public void actionPerformed(ActionEvent ae) {
        int i;
        EdgeView ev;
        CyEdge cyEdge;
        NodeView nv;
        CyNode cyNode;
        CyNetworkView myView = Cytoscape.getCurrentNetworkView();
        CyNetwork cyNet = myView.getNetwork();
        List edgeViews = myView.getSelectedEdges();
        List nodeViews = myView.getSelectedNodes();
        if (this.graphObj != null) {
            if (this.graphObj instanceof Node) {
                cyNode = (CyNode)this.graphObj;
                nv = Cytoscape.getCurrentNetworkView().getNodeView(cyNode);
                if (!nodeViews.contains(nv)) {
                    nodeViews.add(nv);
                }
            } else if (this.graphObj instanceof Edge) {
                cyEdge = (CyEdge)this.graphObj;
                ev = Cytoscape.getCurrentNetworkView().getEdgeView(cyEdge);
                if (!edgeViews.contains(ev)) {
                    edgeViews.add(ev);
                }
            }
        }
        HashSet<Integer> edgeIndices = new HashSet<Integer>();
        HashSet<Integer> nodeIndices = new HashSet<Integer>();
        for (i = 0; i < nodeViews.size(); ++i) {
            nv = (NodeView)nodeViews.get(i);
            cyNode = (CyNode)nv.getNode();
            nodeIndices.add(cyNode.getRootGraphIndex());
            int[] edgesList = cyNet.getAdjacentEdgeIndicesArray(cyNode.getRootGraphIndex(), true, true, true);
            for (int x = 0; x < edgesList.length; ++x) {
                edgeIndices.add(edgesList[x]);
            }
        }
        for (i = 0; i < edgeViews.size(); ++i) {
            ev = (EdgeView)edgeViews.get(i);
            cyEdge = (CyEdge)ev.getEdge();
            edgeIndices.add(cyEdge.getRootGraphIndex());
        }
        i = 0;
        int[] edgeInd = new int[edgeIndices.size()];
        for (Integer ei : edgeIndices) {
            edgeInd[i++] = ei;
        }
        i = 0;
        int[] nodeInd = new int[nodeIndices.size()];
        for (Integer ni : nodeIndices) {
            nodeInd[i++] = ni;
        }
        CyUndo.getUndoableEditSupport().postEdit(new DeleteEdit(cyNet, nodeInd, edgeInd, this));
        cyNet.hideEdges(edgeInd);
        cyNet.hideNodes(nodeInd);
        Cytoscape.firePropertyChange("NETWORK_MODIFIED", null, cyNet);
    }

    public void menuSelected(MenuEvent me) {
        CyNetwork n = Cytoscape.getCurrentNetwork();
        if (n == null || n == Cytoscape.getNullNetwork()) {
            this.setEnabled(false);
            return;
        }
        Set nodes = n.getSelectedNodes();
        Set edges = n.getSelectedEdges();
        if (nodes != null && nodes.size() > 0 || edges != null && edges.size() > 0) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

