/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.readers.GraphReader;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.logger.CyLogger;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTask;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.view.CyNetworkView;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.JOptionPane;

public class LoadNetworkTask
implements Task {
    private URI uri;
    private TaskMonitor taskMonitor;
    private GraphReader reader;
    private String name;
    private URL url;
    private Thread myThread = null;
    private boolean interrupted = false;
    private CyLayoutAlgorithm layoutAlgorithm = null;

    public static void loadURL(URL u, boolean skipMessage) {
        LoadNetworkTask.loadURL(u, skipMessage, null);
    }

    public static void loadFile(File file, boolean skipMessage) {
        LoadNetworkTask.loadFile(file, skipMessage, null);
    }

    public static void loadURL(URL u, boolean skipMessage, CyLayoutAlgorithm layoutAlgorithm) {
        LoadNetworkTask task = new LoadNetworkTask(u, layoutAlgorithm);
        LoadNetworkTask.setupTask(task, skipMessage, true);
    }

    public static void loadFile(File file, boolean skipMessage, CyLayoutAlgorithm layoutAlgorithm) {
        LoadNetworkTask task = new LoadNetworkTask(file, layoutAlgorithm);
        LoadNetworkTask.setupTask(task, skipMessage, true);
    }

    private static void setupTask(LoadNetworkTask task, boolean skipMessage, boolean cancelable) {
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.setOwner((Container)Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(true);
        if (cancelable) {
            jTaskConfig.displayCancelButton(true);
        }
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(skipMessage);
        TaskManager.executeTask((Task)task, (JTaskConfig)jTaskConfig);
    }

    private LoadNetworkTask(URL u, CyLayoutAlgorithm layout) {
        this.url = u;
        this.name = u.toString();
        this.reader = null;
        this.layoutAlgorithm = layout;
    }

    private LoadNetworkTask(File file, CyLayoutAlgorithm layout) {
        this.reader = Cytoscape.getImportHandler().getReader(file.getAbsolutePath());
        this.uri = file.toURI();
        this.name = file.getName();
        this.layoutAlgorithm = layout;
        if (this.reader == null) {
            this.uri = null;
            this.url = null;
            JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Unable to open file " + this.name, "File Open Error", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.reader == null && this.url == null) {
            return;
        }
        this.myThread = Thread.currentThread();
        if (this.reader == null && this.url != null) {
            try {
                this.taskMonitor.setStatus("Opening URL " + this.url);
                this.reader = Cytoscape.getImportHandler().getReader(this.url);
                if (this.interrupted) {
                    return;
                }
                this.uri = this.url.toURI();
            }
            catch (Exception e) {
                this.uri = null;
                this.taskMonitor.setException((Throwable)e, "Unable to connect to URL " + this.name + ": " + e.getMessage());
                return;
            }
            if (this.reader == null) {
                this.uri = null;
                this.taskMonitor.setException(null, "Unable to connect to URL " + this.name);
                return;
            }
            ((JTask)this.taskMonitor).setCancel(false);
        }
        this.taskMonitor.setStatus("Reading in Network Data...");
        if (CytoscapeInit.getCyInitParams().getMode() == 1 || CytoscapeInit.getCyInitParams().getMode() == 4) {
            Cytoscape.getDesktop().getSwingPropertyChangeSupport().removePropertyChangeListener(Cytoscape.getDesktop().getBirdsEyeViewHandler());
        }
        try {
            this.taskMonitor.setPercentCompleted(-1);
            this.taskMonitor.setStatus("Creating Cytoscape Network...");
            CyNetwork cyNetwork = Cytoscape.createNetwork(this.reader, true, null);
            CyNetworkView view = Cytoscape.getNetworkView(cyNetwork.getIdentifier());
            if (this.layoutAlgorithm != null && view != null) {
                ((JTask)this.taskMonitor).setCancel(true);
                this.taskMonitor.setStatus("Performing layout...");
                this.layoutAlgorithm.doLayout(view, this.taskMonitor);
                this.taskMonitor.setStatus("Layout complete");
            }
            Object[] ret_val = new Object[]{cyNetwork, this.uri};
            if (CytoscapeInit.getCyInitParams().getMode() == 1 || CytoscapeInit.getCyInitParams().getMode() == 4) {
                Cytoscape.getDesktop().getSwingPropertyChangeSupport().addPropertyChangeListener(Cytoscape.getDesktop().getBirdsEyeViewHandler());
                Cytoscape.getDesktop().getNetworkViewManager().firePropertyChange("NETWORK_VIEW_FOCUSED", null, Cytoscape.getCurrentNetworkView().getNetwork().getIdentifier());
            }
            Cytoscape.firePropertyChange("NETWORK_LOADED", null, ret_val);
            if (cyNetwork != null) {
                this.informUserOfGraphStats(cyNetwork);
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("Could not read network from: ");
                sb.append(this.name);
                sb.append("\nThis file may not be a valid file format.");
                this.taskMonitor.setException((Throwable)new IOException(sb.toString()), sb.toString());
            }
            this.taskMonitor.setPercentCompleted(100);
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "Unable to load network.");
            return;
        }
        finally {
            this.reader = null;
        }
    }

    private void informUserOfGraphStats(CyNetwork newNetwork) {
        DecimalFormat formatter = new DecimalFormat("#,###,###");
        StringBuffer sb = new StringBuffer();
        sb.append("Successfully loaded network from:  ");
        sb.append(this.name);
        sb.append("\n\nNetwork contains " + formatter.format(newNetwork.getNodeCount()));
        sb.append(" nodes and " + formatter.format(newNetwork.getEdgeCount()));
        sb.append(" edges.\n\n");
        if (newNetwork.getNodeCount() < Integer.parseInt(CytoscapeInit.getProperties().getProperty("viewThreshold"))) {
            sb.append("Network is under " + CytoscapeInit.getProperties().getProperty("viewThreshold") + " nodes.  A view will be automatically created.");
        } else {
            sb.append("Network is over " + CytoscapeInit.getProperties().getProperty("viewThreshold") + " nodes.  A view has not been created." + "  If you wish to view this network, use " + "\"Create View\" from the \"Edit\" menu.");
        }
        this.taskMonitor.setStatus(sb.toString());
    }

    public void halt() {
        CyLogger.getLogger().info("Halt called");
        if (this.myThread != null) {
            this.myThread.interrupt();
            this.interrupted = true;
            ((JTask)this.taskMonitor).setDone();
        }
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Loading Network");
    }
}

