/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.util.CyNetworkNaming;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.VisualStyle;
import giny.model.Node;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.MenuEvent;

public class NewWindowSelectedNodesEdgesAction
extends CytoscapeAction {
    public NewWindowSelectedNodesEdgesAction() {
        super("From selected nodes, selected edges");
        this.setPreferredMenu("File.New.Network");
        this.setAcceleratorCombo(78, 3);
    }

    public void actionPerformed(ActionEvent e) {
        CyNetwork current_network = Cytoscape.getCurrentNetwork();
        CyNetworkView current_network_view = Cytoscape.getCurrentNetworkView();
        if (current_network == null || current_network == Cytoscape.getNullNetwork()) {
            return;
        }
        Set nodes = current_network.getSelectedNodes();
        Set edges = current_network.getSelectedEdges();
        CyNetwork new_network = Cytoscape.createNetwork(nodes, edges, CyNetworkNaming.getSuggestedSubnetworkTitle(current_network), current_network);
        String title = " selection";
        CyNetworkView new_network_view = Cytoscape.createNetworkView(new_network, title);
        String vsName = "default";
        if (current_network_view != Cytoscape.getNullNetworkView()) {
            Iterator i = new_network.nodesIterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                new_network_view.getNodeView(node).setOffset(current_network_view.getNodeView(node).getXPosition(), current_network_view.getNodeView(node).getYPosition());
            }
            new_network_view.fitContent();
            VisualStyle newVS = current_network_view.getVisualStyle();
            if (newVS != null) {
                vsName = newVS.getName();
            }
        }
        Cytoscape.getVisualMappingManager().setVisualStyle(vsName);
    }

    public void menuSelected(MenuEvent e) {
        CyNetwork n = Cytoscape.getCurrentNetwork();
        if (n == null || n == Cytoscape.getNullNetwork()) {
            this.setEnabled(false);
            return;
        }
        Set edges = n.getSelectedEdges();
        Set nodes = n.getSelectedNodes();
        if (nodes != null && nodes.size() > 0 || edges != null && edges.size() > 0) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

