/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.actions.OpenSessionAction;
import cytoscape.data.readers.CytoscapeSessionReader;
import cytoscape.data.readers.XGMMLException;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;

class OpenSessionTask
implements Task {
    private String fileName;
    private TaskMonitor taskMonitor;

    OpenSessionTask(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.taskMonitor.setStatus("Opening Session File.\n\nIt may take a while.\nPlease wait...");
        this.taskMonitor.setPercentCompleted(0);
        try {
            CytoscapeSessionReader sr = new CytoscapeSessionReader(this.fileName, this.taskMonitor);
            sr.read();
        }
        catch (IOException e) {
            this.taskMonitor.setException((Throwable)e, "Cannot open the session file: " + e.getMessage());
            OpenSessionAction.logger.error("Cannot open the session file: " + e.getMessage(), e);
        }
        catch (JAXBException e) {
            this.taskMonitor.setException((Throwable)e, "Cannot unmarshall document: " + e.getMessage());
            OpenSessionAction.logger.error("Cannot unmarshall document: " + e.getMessage(), e);
        }
        catch (XGMMLException e) {
            this.taskMonitor.setException((Throwable)e, "XGMML format error in network: " + e.getMessage());
            OpenSessionAction.logger.error("XGMML format error in network " + e.getMessage(), e);
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "Error while loading session " + e.getMessage());
            OpenSessionAction.logger.error("Error while loading session: " + e.getMessage(), e);
        }
        finally {
            Object sr = null;
            Cytoscape.getDesktop().getVizMapperUI().initVizmapperGUI();
            System.gc();
        }
        this.taskMonitor.setPercentCompleted(100);
        this.taskMonitor.setStatus("Session file " + this.fileName + " successfully loaded.");
        Cytoscape.setCurrentSessionFileName(this.fileName);
        File sessionFile = new File(this.fileName);
        Cytoscape.getDesktop().setTitle("Cytoscape Desktop (Session: " + sessionFile.getName() + ")");
    }

    public void halt() {
        OpenSessionAction.logger.info("HALT called!!!");
        this.taskMonitor.setPercentCompleted(100);
        this.taskMonitor.setStatus("Failed!!!");
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return "Opening Session File";
    }
}

