/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.data.CyAttributes;
import cytoscape.data.CyAttributesImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class CyAttributesTest
extends TestCase {
    private CyAttributes cyAttributes;
    private static final String DUMMY_ID = "id_123";
    private static final String DUMMY_BOOLEAN_ATTRIBUTE = "attribute1";
    private static final String DUMMY_STRING_ATTRIBUTE = "attribute2";
    private static final String DUMMY_LIST_ATTRIBUTE = "attribute3";
    private static final String DUMMY_MAP_ATTRIBUTE = "attribute4";

    protected void setUp() throws Exception {
        this.cyAttributes = new CyAttributesImpl();
    }

    public void testBug1363() {
        try {
            boolean b = this.cyAttributes.deleteAttribute("non-existent-attribute.asdffdsa");
            CyAttributesTest.assertFalse((boolean)b);
        }
        catch (Exception e) {
            e.printStackTrace();
            CyAttributesTest.fail((String)"deleting non-existent attr shouldn't have caused exception");
        }
    }

    public void testBooleanValue() {
        boolean exists = this.cyAttributes.hasAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals((boolean)false, (boolean)exists);
        Boolean value = this.cyAttributes.getBooleanAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals(null, (Object)value);
        Double value2 = this.cyAttributes.getDoubleAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals(null, (Object)value2);
        try {
            this.cyAttributes.setAttribute(null, DUMMY_BOOLEAN_ATTRIBUTE, new Boolean(true));
            CyAttributesTest.fail((String)"IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        try {
            this.cyAttributes.setAttribute(DUMMY_ID, null, new Boolean(true));
            CyAttributesTest.fail((String)"IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        this.cyAttributes.setAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE, new Boolean(true));
        exists = this.cyAttributes.hasAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals((boolean)true, (boolean)exists);
        byte type = this.cyAttributes.getType(DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals((byte)1, (byte)type);
        value = this.cyAttributes.getBooleanAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals((boolean)true, (boolean)value);
        try {
            Integer valueInt = this.cyAttributes.getIntegerAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
            CyAttributesTest.fail((String)"ClassCastException should have been thrown.");
        }
        catch (ClassCastException e) {
            CyAttributesTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        try {
            this.cyAttributes.setAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE, new Integer(5));
            CyAttributesTest.fail((String)"IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        String[] attribs = this.cyAttributes.getAttributeNames();
        CyAttributesTest.assertEquals((int)1, (int)attribs.length);
        CyAttributesTest.assertEquals((String)DUMMY_BOOLEAN_ATTRIBUTE, (String)attribs[0]);
        boolean success = this.cyAttributes.deleteAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals((boolean)true, (boolean)success);
        exists = this.cyAttributes.hasAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals((boolean)false, (boolean)exists);
        type = this.cyAttributes.getType(DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals((byte)1, (byte)type);
        CyAttributesTest.assertEquals((byte)1, (byte)type);
        success = this.cyAttributes.deleteAttribute(DUMMY_BOOLEAN_ATTRIBUTE);
        type = this.cyAttributes.getType(DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals((byte)-1, (byte)type);
    }

    public void testStringValue() {
        boolean exists = this.cyAttributes.hasAttribute(DUMMY_ID, DUMMY_STRING_ATTRIBUTE);
        CyAttributesTest.assertEquals((boolean)false, (boolean)exists);
        this.cyAttributes.setAttribute(DUMMY_ID, DUMMY_STRING_ATTRIBUTE, new String("Cytoscape"));
        exists = this.cyAttributes.hasAttribute(DUMMY_ID, DUMMY_STRING_ATTRIBUTE);
        CyAttributesTest.assertEquals((boolean)true, (boolean)exists);
        byte type = this.cyAttributes.getType(DUMMY_STRING_ATTRIBUTE);
        CyAttributesTest.assertEquals((byte)4, (byte)type);
        String value = this.cyAttributes.getStringAttribute(DUMMY_ID, DUMMY_STRING_ATTRIBUTE);
        CyAttributesTest.assertEquals((String)"Cytoscape", (String)value);
        try {
            Integer valueInt = this.cyAttributes.getIntegerAttribute(DUMMY_ID, DUMMY_STRING_ATTRIBUTE);
            CyAttributesTest.fail((String)"ClassCastException should have been thrown.");
        }
        catch (ClassCastException e) {
            CyAttributesTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        try {
            this.cyAttributes.setAttribute(DUMMY_ID, DUMMY_STRING_ATTRIBUTE, new Integer(5));
            CyAttributesTest.fail((String)"IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        String[] attribs = this.cyAttributes.getAttributeNames();
        CyAttributesTest.assertEquals((int)1, (int)attribs.length);
        CyAttributesTest.assertEquals((String)DUMMY_STRING_ATTRIBUTE, (String)attribs[0]);
    }

    public void testSimpleLists() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Integer(5));
        list.add(new String("Cytoscape"));
        try {
            this.cyAttributes.setListAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE, null);
            CyAttributesTest.fail((String)"IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        try {
            this.cyAttributes.setListAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE, list);
            CyAttributesTest.fail((String)"IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        list = new ArrayList();
        list.add(new Integer(5));
        list.add(new Integer(6));
        this.cyAttributes.setListAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE, list);
        byte type = this.cyAttributes.getType(DUMMY_LIST_ATTRIBUTE);
        CyAttributesTest.assertEquals((byte)type, (byte)-2);
        boolean exists = this.cyAttributes.hasAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE);
        CyAttributesTest.assertEquals((boolean)true, (boolean)exists);
        try {
            Map map = this.cyAttributes.getMapAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE);
            CyAttributesTest.fail((String)"ClassCastException should have been thrown.");
        }
        catch (ClassCastException e) {
            CyAttributesTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        List storedList = this.cyAttributes.getListAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE);
        CyAttributesTest.assertEquals((int)2, (int)storedList.size());
        Integer int0 = (Integer)storedList.get(0);
        Integer int1 = (Integer)storedList.get(1);
        CyAttributesTest.assertEquals((int)5, (int)int0);
        CyAttributesTest.assertEquals((int)6, (int)int1);
        list = new ArrayList();
        this.cyAttributes.setListAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE, list);
    }

    public void testSimpleMaps() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(new Integer(1), new String("One"));
        map.put(new Integer(2), new String("Two"));
        try {
            this.cyAttributes.setMapAttribute(DUMMY_ID, DUMMY_MAP_ATTRIBUTE, map);
            CyAttributesTest.fail((String)"IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        map = new HashMap();
        map.put(new String("first"), new String("One"));
        map.put(new String("second"), new Integer(2));
        try {
            this.cyAttributes.setMapAttribute(DUMMY_ID, DUMMY_MAP_ATTRIBUTE, map);
            CyAttributesTest.fail((String)"IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        map = new HashMap();
        map.put(new String("first"), new Integer(1));
        map.put(new String("second"), new Integer(2));
        this.cyAttributes.setMapAttribute(DUMMY_ID, DUMMY_MAP_ATTRIBUTE, map);
        byte type = this.cyAttributes.getType(DUMMY_MAP_ATTRIBUTE);
        CyAttributesTest.assertEquals((byte)-3, (byte)type);
        try {
            List list = this.cyAttributes.getListAttribute(DUMMY_ID, DUMMY_MAP_ATTRIBUTE);
            CyAttributesTest.fail((String)"ClassCastException should have been thrown.");
        }
        catch (ClassCastException e) {
            CyAttributesTest.assertTrue((e != null ? 1 : 0) != 0);
        }
        Map storedMap = this.cyAttributes.getMapAttribute(DUMMY_ID, DUMMY_MAP_ATTRIBUTE);
        CyAttributesTest.assertEquals((int)2, (int)storedMap.keySet().size());
        Set keySet = storedMap.keySet();
        CyAttributesTest.assertTrue((boolean)keySet.contains("first"));
        CyAttributesTest.assertEquals((Object)1, storedMap.get("first"));
        CyAttributesTest.assertTrue((boolean)keySet.contains("second"));
        CyAttributesTest.assertEquals((Object)2, storedMap.get("second"));
        map = new HashMap();
        this.cyAttributes.setMapAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE, map);
    }

    public void testAttributeDescriptions() {
        this.cyAttributes.setAttributeDescription(DUMMY_BOOLEAN_ATTRIBUTE, "sample description");
        String description = this.cyAttributes.getAttributeDescription(DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals((String)"sample description", (String)description);
        CyAttributesTest.assertEquals(null, (String)this.cyAttributes.getAttributeDescription(DUMMY_STRING_ATTRIBUTE));
    }

    public void testUserInteractionFlags() {
        String sampleAttribute = DUMMY_BOOLEAN_ATTRIBUTE;
        boolean visibleFlag = this.cyAttributes.getUserVisible(sampleAttribute);
        CyAttributesTest.assertEquals((boolean)true, (boolean)visibleFlag);
        boolean editableFlag = this.cyAttributes.getUserVisible(sampleAttribute);
        CyAttributesTest.assertEquals((boolean)true, (boolean)editableFlag);
        this.cyAttributes.setUserVisible(sampleAttribute, false);
        visibleFlag = this.cyAttributes.getUserVisible(sampleAttribute);
        CyAttributesTest.assertEquals((boolean)false, (boolean)visibleFlag);
        this.cyAttributes.setUserVisible(sampleAttribute, true);
        visibleFlag = this.cyAttributes.getUserVisible(sampleAttribute);
        CyAttributesTest.assertEquals((boolean)true, (boolean)visibleFlag);
        this.cyAttributes.setUserEditable(sampleAttribute, false);
        editableFlag = this.cyAttributes.getUserEditable(sampleAttribute);
        CyAttributesTest.assertEquals((boolean)false, (boolean)editableFlag);
        this.cyAttributes.setUserEditable(sampleAttribute, true);
        editableFlag = this.cyAttributes.getUserEditable(sampleAttribute);
        CyAttributesTest.assertEquals((boolean)true, (boolean)editableFlag);
    }

    public static void main(String[] args) {
        TestRunner.run(CyAttributesTest.class);
    }
}

