/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.ontology.readers;

import cytoscape.data.ontology.DBReference;
import cytoscape.data.ontology.readers.DBCrossReferenceReader;
import cytoscape.util.URLUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import junit.framework.TestCase;

public class DBCrossReferenceReaderTest
extends TestCase {
    DBCrossReferenceReader rd;

    protected void setUp() throws Exception {
        super.setUp();
        this.rd = new DBCrossReferenceReader();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.rd = null;
    }

    public void testGetXrefMap() {
        try {
            this.rd.readResourceFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map<String, DBReference> sampleMap = this.rd.getXrefMap();
        DBCrossReferenceReaderTest.assertTrue((sampleMap.size() > 0 ? 1 : 0) != 0);
        DBCrossReferenceReaderTest.assertTrue((boolean)sampleMap.containsKey("KEGG_PATHWAY"));
        DBCrossReferenceReaderTest.assertTrue((boolean)sampleMap.containsKey("AgBase"));
        DBCrossReferenceReaderTest.assertTrue((boolean)sampleMap.containsKey("ZFIN"));
        DBReference ref = sampleMap.get("SGD");
        DBCrossReferenceReaderTest.assertEquals((String)"Saccharomyces Genome Database", (String)ref.getFullName());
        try {
            URL url = ref.getGenericURL();
            DBCrossReferenceReaderTest.assertEquals((String)"http://www.yeastgenome.org/", (String)url.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        DBCrossReferenceReaderTest.assertEquals((String)"Identifier for SGD Loci", (String)ref.getObject());
    }

    private String connectToURL(URL url) throws IOException {
        String s;
        URLConnection uc = URLUtil.getURLConnection(url);
        uc.setReadTimeout(5000);
        InputStream is = uc.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuffer sb = new StringBuffer();
        while ((s = reader.readLine()) != null) {
            sb.append(s);
        }
        reader.close();
        return sb.toString();
    }
}

