/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.CyAttributes;
import cytoscape.data.readers.AbstractGraphReader;
import cytoscape.data.readers.GMLException;
import cytoscape.data.readers.GMLParser;
import cytoscape.data.readers.KeyValue;
import cytoscape.data.readers.VisualStyleBuilder;
import cytoscape.init.CyInitParams;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.LayoutAdapter;
import cytoscape.logger.CyLogger;
import cytoscape.task.TaskMonitor;
import cytoscape.util.FileUtil;
import cytoscape.util.PercentUtil;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.ArrowShape;
import cytoscape.visual.LineStyle;
import cytoscape.visual.LineType;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualPropertyType;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMLReader
extends AbstractGraphReader {
    protected static String GRAPH = "graph";
    protected static String NODE = "node";
    protected static String EDGE = "edge";
    protected static String GRAPHICS = "graphics";
    protected static String LABEL = "label";
    protected static String SOURCE = "source";
    protected static String TARGET = "target";
    protected static String X = "x";
    protected static String Y = "y";
    protected static String H = "h";
    protected static String W = "w";
    protected static String TYPE = "type";
    protected static String ID = "id";
    protected static String ROOT_INDEX = "root_index";
    protected static String RECTANGLE = "rectangle";
    protected static String ELLIPSE = "ellipse";
    protected static String LINE = "Line";
    protected static String POINT = "point";
    protected static String DIAMOND = "diamond";
    protected static String HEXAGON = "hexagon";
    protected static String OCTAGON = "octagon";
    protected static String PARALELLOGRAM = "parallelogram";
    protected static String TRIANGLE = "triangle";
    protected static String FILL = "fill";
    protected static String WIDTH = "width";
    protected static String STRAIGHT_LINES = "line";
    protected static String CURVED_LINES = "curved";
    protected static String SOURCE_ARROW = "source_arrow";
    protected static String TARGET_ARROW = "target_arrow";
    protected static String YED_SOURCE_ARROW = "sourceArrow";
    protected static String YED_TARGET_ARROW = "targetArrow";
    protected static String YED_DELTA = "delta";
    protected static String YED_STANDARD = "standard";
    protected static String YED_DIAMOND = "diamond";
    protected static String YED_SHORT = "short";
    protected static String YED_WHITE_DELTA = "white_delta";
    protected static String YED_WHITE_DIAMOND = "white_diamond";
    protected static String ARROW = "arrow";
    protected static String ARROW_NONE = "none";
    protected static String ARROW_FIRST = "first";
    protected static String ARROW_LAST = "last";
    protected static String ARROW_BOTH = "both";
    protected static String OUTLINE = "outline";
    protected static String OUTLINE_WIDTH = "outline_width";
    protected static String DEFAULT_EDGE_INTERACTION = "pp";
    protected static String VERSION = "Version";
    protected static String CREATOR = "Creator";
    private String mapSuffix;
    private Color DEF_COLOR = new Color(153, 153, 255);
    private String vsbSwitch = CytoscapeInit.getProperties().getProperty("visualStyleBuilder");
    private VisualStyleBuilder graphStyle = null;
    protected static CyLogger logger = CyLogger.getLogger(GMLReader.class);
    List keyVals;
    OpenIntIntHashMap nodeIDMap;
    IntArrayList nodes;
    IntArrayList sources;
    IntArrayList targets;
    Vector node_labels;
    Vector edge_labels;
    Vector edge_root_index_pairs;
    Vector node_root_index_pairs;
    Vector edge_names;
    Vector node_names;
    IntArrayList giny_nodes;
    IntArrayList giny_edges;
    private TaskMonitor taskMonitor;
    private PercentUtil percentUtil;
    String styleName;
    HashMap nodeW;
    HashMap nodeH;
    HashMap<String, NodeShape> nodeShape;
    HashMap nodeCol;
    HashMap<String, Double> nodeBWidth;
    HashMap nodeBCol;
    HashMap edgeCol;
    HashMap<String, Float> edgeWidth;
    HashMap<String, String> edgeArrow;
    HashMap edgeShape;
    InputStream inputStream = null;

    public GMLReader(String filename) {
        this(filename, null);
        this.inputStream = FileUtil.getInputStream(filename);
    }

    public GMLReader(InputStream is, String name) {
        super(name);
        this.styleName = this.createVSName();
        this.initializeHash();
        this.initStyle();
        this.inputStream = is;
    }

    public GMLReader(String filename, TaskMonitor taskMonitor) {
        super(filename);
        this.inputStream = FileUtil.getInputStream(filename);
        this.styleName = this.createVSName();
        this.initializeHash();
        this.initStyle();
        if (taskMonitor != null) {
            this.taskMonitor = taskMonitor;
            this.percentUtil = new PercentUtil(5);
        }
    }

    @Override
    public void setTaskMonitor(TaskMonitor monitor) {
        this.taskMonitor = monitor;
        this.percentUtil = new PercentUtil(3);
    }

    private String createVSName() {
        this.mapSuffix = " for " + this.fileName;
        return this.getNetworkName();
    }

    private void initializeHash() {
        this.edge_names = new Vector();
        this.node_names = new Vector();
    }

    private void initStyle() {
        this.graphStyle = new VisualStyleBuilder(this.styleName, false);
        this.graphStyle.setNodeSizeLocked(false);
    }

    @Deprecated
    public void setNodeMaps(VisualMappingManager vizmapper) {
    }

    @Deprecated
    public void setEdgeMaps(VisualMappingManager vizmapper) {
    }

    @Deprecated
    public void applyMaps(String mapSuffix, String VSName) {
    }

    @Override
    public void read() {
        try {
            this.keyVals = new GMLParser(this.inputStream).parseList();
        }
        catch (Exception io) {
            logger.warn("Error reading GML file: " + io.getMessage(), io);
            if (this.taskMonitor != null) {
                this.taskMonitor.setException((Throwable)io, io.getMessage());
            }
            throw new RuntimeException(io.getMessage());
        }
        this.initializeStructures();
        this.readGML(this.keyVals);
        this.createGraph();
        this.extract();
        this.releaseStructures();
    }

    public List getList() {
        return this.keyVals;
    }

    protected void initializeStructures() {
        this.nodes = new IntArrayList();
        this.sources = new IntArrayList();
        this.targets = new IntArrayList();
        this.node_labels = new Vector();
        this.edge_labels = new Vector();
        this.edge_root_index_pairs = new Vector();
        this.node_root_index_pairs = new Vector();
    }

    protected void releaseStructures() {
        this.nodes = null;
        this.sources = null;
        this.targets = null;
        this.node_labels = null;
        this.edge_labels = null;
        this.edge_root_index_pairs = null;
        this.node_root_index_pairs = null;
    }

    protected void createGraph() {
        Cytoscape.ensureCapacity(this.nodes.size(), this.sources.size());
        this.nodeIDMap = new OpenIntIntHashMap(this.nodes.size());
        this.giny_nodes = new IntArrayList(this.nodes.size());
        OpenIntIntHashMap gml_id2order = new OpenIntIntHashMap(this.nodes.size());
        HashSet<String> nodeNameSet = new HashSet<String>(this.nodes.size());
        for (int idx = 0; idx < this.nodes.size(); ++idx) {
            String label;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(2, idx, this.nodes.size()));
            }
            if (!nodeNameSet.add(label = (String)this.node_labels.get(idx))) {
                throw new GMLException("GML id " + this.nodes.get(idx) + " has a duplicated label: " + label);
            }
            CyNode node = Cytoscape.getCyNode(label, true);
            this.giny_nodes.add(node.getRootGraphIndex());
            this.nodeIDMap.put(this.nodes.get(idx), node.getRootGraphIndex());
            gml_id2order.put(this.nodes.get(idx), idx);
            ((KeyValue)this.node_root_index_pairs.get((int)idx)).value = new Integer(node.getRootGraphIndex());
        }
        nodeNameSet = null;
        this.giny_edges = new IntArrayList(this.sources.size());
        HashSet<String> edgeNameSet = new HashSet<String>(this.sources.size());
        CyAttributes edgeAttributes = Cytoscape.getEdgeAttributes();
        for (int idx = 0; idx < this.sources.size(); ++idx) {
            CyEdge edge;
            String edgeName;
            String label;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(3, idx, this.sources.size()));
            }
            if (gml_id2order.containsKey(this.sources.get(idx)) && gml_id2order.containsKey(this.targets.get(idx))) {
                label = (String)this.edge_labels.get(idx);
                String sourceName = (String)this.node_labels.get(gml_id2order.get(this.sources.get(idx)));
                String targetName = (String)this.node_labels.get(gml_id2order.get(this.targets.get(idx)));
                edgeName = CyEdge.createIdentifier(sourceName, label, targetName);
                int duplicate_count = 1;
                while (!edgeNameSet.add(edgeName)) {
                    edgeName = CyEdge.createIdentifier(sourceName, label, targetName) + "_" + duplicate_count;
                    ++duplicate_count;
                }
                this.edge_names.add(idx, edgeName);
                edge = Cytoscape.getRootGraph().getEdge(edgeName);
                if (edge == null) {
                    CyNode node_1 = Cytoscape.getCyNode(sourceName);
                    CyNode node_2 = Cytoscape.getCyNode(targetName);
                    edge = Cytoscape.getCyEdge(node_1, node_2, "interaction", label, true, true);
                }
            } else {
                throw new GMLException("Non-existant source/target node for edge with gml (source,target): " + this.sources.get(idx) + "," + this.targets.get(idx));
            }
            edge.setIdentifier(edgeName);
            edgeAttributes.setAttribute(edgeName, "interaction", label);
            this.giny_edges.add(edge.getRootGraphIndex());
            ((KeyValue)this.edge_root_index_pairs.get((int)idx)).value = new Integer(edge.getRootGraphIndex());
        }
        edgeNameSet = null;
    }

    protected void readGML(List list) {
        int counter = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(1, counter, list.size()));
                ++counter;
            }
            KeyValue keyVal = (KeyValue)it.next();
            if (!keyVal.key.equals(GRAPH)) continue;
            this.readGraph((List)keyVal.value);
        }
    }

    protected void readGraph(List list) {
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(NODE)) {
                this.readNode((List)keyVal.value);
            }
            if (!keyVal.key.equals(EDGE)) continue;
            this.readEdge((List)keyVal.value);
        }
    }

    protected void readNode(List list) {
        String label = "";
        boolean contains_id = false;
        int id = 0;
        KeyValue root_index_pair = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ID)) {
                contains_id = true;
                id = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = (String)keyVal.value;
                continue;
            }
            if (!keyVal.key.equals(ROOT_INDEX)) continue;
            root_index_pair = keyVal;
        }
        if (label.equals("") || label.matches("\\s+")) {
            label = String.valueOf(id);
        }
        if (root_index_pair == null) {
            root_index_pair = new KeyValue(ROOT_INDEX, null);
            list.add(root_index_pair);
        }
        if (!contains_id) {
            StringWriter stringWriter = new StringWriter();
            try {
                GMLParser.printList(list, stringWriter);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            throw new GMLException("The node-associated list\n" + stringWriter + "is missing an id field");
        }
        this.node_root_index_pairs.add(root_index_pair);
        this.nodes.add(id);
        this.node_labels.add(label);
        this.node_names.add(label);
    }

    protected void readEdge(List list) {
        String label = DEFAULT_EDGE_INTERACTION;
        boolean contains_source = false;
        boolean contains_target = false;
        int source = 0;
        int target = 0;
        KeyValue root_index_pair = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(SOURCE)) {
                contains_source = true;
                source = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(TARGET)) {
                contains_target = true;
                target = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = (String)keyVal.value;
                continue;
            }
            if (!keyVal.key.equals(ROOT_INDEX)) continue;
            root_index_pair = keyVal;
        }
        if (root_index_pair == null) {
            root_index_pair = new KeyValue(ROOT_INDEX, null);
            list.add(root_index_pair);
        }
        if (!contains_source || !contains_target) {
            StringWriter stringWriter = new StringWriter();
            try {
                GMLParser.printList(list, stringWriter);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            throw new GMLException("The edge-associated list\n" + stringWriter + " is missing a source or target key");
        }
        this.sources.add(source);
        this.targets.add(target);
        this.edge_labels.add(label);
        this.edge_root_index_pairs.add(root_index_pair);
    }

    @Override
    public CyLayoutAlgorithm getLayoutAlgorithm() {
        return new LayoutAdapter(){

            public void doLayout(CyNetworkView networkView, TaskMonitor monitor) {
                GMLReader.this.layout(networkView);
            }
        };
    }

    public void layout(CyNetworkView myView) {
        if (myView == null || myView.nodeCount() == 0) {
            return;
        }
        if (this.keyVals == null) {
            throw new RuntimeException("Failed to read gml file on initialization");
        }
        for (KeyValue keyVal : this.keyVals) {
            if (!keyVal.key.equals(GRAPH)) continue;
            this.layoutGraph(myView, (List)keyVal.value);
        }
    }

    public void extract() {
        if (this.keyVals == null) {
            throw new RuntimeException("Failed to read gml file on initialization");
        }
        for (KeyValue keyVal : this.keyVals) {
            if (!keyVal.key.equals(GRAPH)) continue;
            this.extractGraph((List)keyVal.value);
        }
    }

    protected void extractGraph(List list) {
        String edgeName = null;
        int ePtr = 0;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(NODE)) {
                this.extractNode((List)keyVal.value);
                continue;
            }
            if (!keyVal.key.equals(EDGE)) continue;
            edgeName = (String)this.edge_names.get(ePtr);
            ++ePtr;
            this.extractEdge((List)keyVal.value, edgeName);
        }
    }

    protected void extractNode(List list) {
        List graphics_list = null;
        String label = null;
        int tempid = 0;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ROOT_INDEX)) {
                if (keyVal.value != null) continue;
                return;
            }
            if (keyVal.key.equals(GRAPHICS)) {
                graphics_list = (List)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = (String)keyVal.value;
                continue;
            }
            if (!keyVal.key.equals(ID)) continue;
            tempid = (Integer)keyVal.value;
        }
        if (graphics_list != null) {
            if (label == null) {
                label = "node" + tempid;
                logger.info("Warning: node label is missing for node ID: " + tempid);
            }
            this.extractNodeAttributes(graphics_list, label);
        }
    }

    protected void extractEdge(List<KeyValue> list, String edgeName) {
        List graphics_list = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ROOT_INDEX)) {
                if (keyVal.value != null) continue;
                return;
            }
            if (!keyVal.key.equals(GRAPHICS)) continue;
            graphics_list = (List)keyVal.value;
        }
        if (graphics_list != null) {
            this.extractEdgeAttributes(graphics_list, edgeName);
        }
    }

    protected void layoutGraph(GraphView myView, List list) {
        Object edgeName = null;
        boolean ePtr = false;
        for (KeyValue keyVal : list) {
            if (!keyVal.key.equals(NODE)) continue;
            this.layoutNode(myView, (List)keyVal.value);
        }
    }

    protected void layoutNode(GraphView myView, List list) {
        Integer root_index = null;
        List graphics_list = null;
        String label = null;
        int tempid = 0;
        NodeView view = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ROOT_INDEX)) {
                if (keyVal.value == null) {
                    return;
                }
                root_index = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(GRAPHICS)) {
                graphics_list = (List)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = (String)keyVal.value;
                continue;
            }
            if (!keyVal.key.equals(ID)) continue;
            tempid = (Integer)keyVal.value;
        }
        view = myView.getNodeView(root_index.intValue());
        if (label != null) {
            view.getLabel().setText(label);
        } else {
            view.getLabel().setText("node(" + tempid + ")");
        }
        if (graphics_list != null) {
            this.layoutNodeGraphics(myView, graphics_list, view);
        }
    }

    protected void layoutNodeGraphics(GraphView myView, List list, NodeView nodeView) {
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(X)) {
                nodeView.setXPosition(((Number)keyVal.value).doubleValue());
                continue;
            }
            if (keyVal.key.equals(Y)) {
                nodeView.setYPosition(((Number)keyVal.value).doubleValue());
                continue;
            }
            if (keyVal.key.equals(H)) {
                nodeView.setHeight(((Number)keyVal.value).doubleValue());
                continue;
            }
            if (keyVal.key.equals(W)) {
                nodeView.setWidth(((Number)keyVal.value).doubleValue());
                continue;
            }
            if (keyVal.key.equals(FILL)) {
                nodeView.setUnselectedPaint((Paint)this.getColor((String)keyVal.value));
                continue;
            }
            if (keyVal.key.equals(OUTLINE)) {
                nodeView.setBorderPaint((Paint)this.getColor((String)keyVal.value));
                continue;
            }
            if (keyVal.key.equals(OUTLINE_WIDTH)) {
                nodeView.setBorderWidth(((Number)keyVal.value).floatValue());
                continue;
            }
            if (!keyVal.key.equals(TYPE)) continue;
            String type = (String)keyVal.value;
            if (type.equals(ELLIPSE)) {
                nodeView.setShape(2);
                continue;
            }
            if (type.equals(RECTANGLE)) {
                nodeView.setShape(6);
                continue;
            }
            if (type.equals(DIAMOND)) {
                nodeView.setShape(1);
                continue;
            }
            if (type.equals(HEXAGON)) {
                nodeView.setShape(3);
                continue;
            }
            if (type.equals(OCTAGON)) {
                nodeView.setShape(4);
                continue;
            }
            if (type.equals(PARALELLOGRAM)) {
                nodeView.setShape(5);
                continue;
            }
            if (!type.equals(TRIANGLE)) continue;
            nodeView.setShape(0);
        }
    }

    protected void extractNodeAttributes(List list, String nodeName) {
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(X) || keyVal.key.equals(Y)) continue;
            if (keyVal.key.equals(H)) {
                this.graphStyle.addProperty(nodeName, VisualPropertyType.NODE_HEIGHT, "" + keyVal.value);
                continue;
            }
            if (keyVal.key.equals(W)) {
                this.graphStyle.addProperty(nodeName, VisualPropertyType.NODE_WIDTH, "" + keyVal.value);
                continue;
            }
            if (keyVal.key.equals(FILL)) {
                this.graphStyle.addProperty(nodeName, VisualPropertyType.NODE_FILL_COLOR, "" + keyVal.value);
                continue;
            }
            if (keyVal.key.equals(OUTLINE)) {
                this.graphStyle.addProperty(nodeName, VisualPropertyType.NODE_BORDER_COLOR, "" + keyVal.value);
                continue;
            }
            if (keyVal.key.equals(WIDTH)) {
                this.graphStyle.addProperty(nodeName, VisualPropertyType.NODE_LINE_WIDTH, "" + keyVal.value);
                continue;
            }
            if (!keyVal.key.equals(TYPE)) continue;
            String type = (String)keyVal.value;
            this.graphStyle.addProperty(nodeName, VisualPropertyType.NODE_SHAPE, type);
        }
    }

    protected void extractEdgeAttributes(List<KeyValue> list, String edgeName) {
        String value = null;
        boolean isArrow = false;
        String edgeFill = this.DEF_COLOR.toString();
        String arrowShape = ARROW_NONE;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(LINE)) continue;
            if (keyVal.key.equals(WIDTH)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_LINE_WIDTH, new String(keyVal.value.toString()));
                continue;
            }
            if (keyVal.key.equals(FILL)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_COLOR, new String(keyVal.value.toString()));
                edgeFill = keyVal.value.toString();
                continue;
            }
            if (keyVal.key.equals(ARROW)) {
                isArrow = true;
                ArrowShape shape = ArrowShape.ARROW;
                String arrowName = shape.getName();
                if (keyVal.value.toString().equalsIgnoreCase(ARROW_FIRST)) {
                    arrowShape = ARROW_FIRST;
                    this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_SHAPE, arrowName);
                    continue;
                }
                if (keyVal.value.toString().equalsIgnoreCase(ARROW_LAST)) {
                    arrowShape = ARROW_LAST;
                    this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_SHAPE, arrowName);
                    continue;
                }
                if (!keyVal.value.toString().equalsIgnoreCase(ARROW_BOTH)) continue;
                arrowShape = ARROW_BOTH;
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_SHAPE, arrowName);
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_SHAPE, arrowName);
                continue;
            }
            if (keyVal.key.equals(TYPE)) {
                value = (String)keyVal.value;
                if (value.equals(STRAIGHT_LINES) || !value.equals(CURVED_LINES)) continue;
                continue;
            }
            if (keyVal.key.equals(SOURCE_ARROW)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_SHAPE, ArrowShape.getArrowShape(((Number)keyVal.value).intValue()).getName());
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_COLOR, edgeFill);
                continue;
            }
            if (keyVal.key.equals(TARGET_ARROW)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_SHAPE, ArrowShape.getArrowShape(((Number)keyVal.value).intValue()).getName());
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_COLOR, edgeFill);
                continue;
            }
            if (keyVal.key.equals(YED_SOURCE_ARROW)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_SHAPE, this.convertYEDArrowShape(keyVal.value.toString()));
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_COLOR, edgeFill);
                continue;
            }
            if (!keyVal.key.equals(YED_TARGET_ARROW)) continue;
            this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_SHAPE, this.convertYEDArrowShape(keyVal.value.toString()));
            this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_COLOR, edgeFill);
        }
        if (isArrow) {
            if (arrowShape.equals(ARROW_FIRST)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_COLOR, edgeFill);
            } else if (arrowShape.equals(ARROW_LAST)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_COLOR, edgeFill);
            } else if (arrowShape.equals(ARROW_BOTH)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_COLOR, edgeFill);
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_COLOR, edgeFill);
            }
        }
    }

    private String convertYEDArrowShape(String yedArrow) {
        String shape = ArrowShape.NONE.getName();
        if (yedArrow.equals(YED_DELTA) || yedArrow.equals(YED_WHITE_DELTA)) {
            shape = ArrowShape.DELTA.getName();
        } else if (yedArrow.equals(YED_DIAMOND) || yedArrow.equals(YED_WHITE_DIAMOND)) {
            shape = ArrowShape.DIAMOND.getName();
        } else if (yedArrow.equals(YED_STANDARD) || yedArrow.equals(YED_SHORT)) {
            shape = ArrowShape.ARROW.getName();
        }
        return shape;
    }

    @Deprecated
    public static LineType getLineType(int width) {
        return new LineType(LineStyle.SOLID, Float.valueOf(new Integer(width).floatValue()));
    }

    public void showMaps() {
        String e = null;
        Object n = null;
        String temp = null;
        for (int i = 0; i < this.edge_names.size(); ++i) {
            e = (String)this.edge_names.get(i);
            temp = e + ": ";
            temp = temp + this.edgeCol.get(e) + ", ";
            temp = temp + this.edgeWidth.get(e) + ", ";
            temp = temp + this.edgeArrow.get(e) + ", ";
            temp = temp + this.edgeShape.get(e) + ", ";
            logger.info(temp);
            temp = null;
        }
    }

    protected void layoutEdge(GraphView myView, List list, String edgeName) {
        EdgeView edgeView = null;
        List graphics_list = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ROOT_INDEX)) {
                if (keyVal.value == null) {
                    return;
                }
                edgeView = myView.getEdgeView(((Integer)keyVal.value).intValue());
                continue;
            }
            if (!keyVal.key.equals(GRAPHICS)) continue;
            graphics_list = (List)keyVal.value;
        }
        if (edgeView != null && graphics_list != null) {
            this.layoutEdgeGraphics(myView, graphics_list, edgeView);
        }
    }

    protected void layoutEdgeGraphics(GraphView myView, List<KeyValue> list, EdgeView edgeView) {
        String value = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(LINE)) {
                this.layoutEdgeGraphicsLine(myView, (List)keyVal.value, edgeView);
                continue;
            }
            if (keyVal.key.equals(WIDTH)) {
                edgeView.setStrokeWidth(((Number)keyVal.value).floatValue());
                continue;
            }
            if (keyVal.key.equals(FILL)) {
                edgeView.setUnselectedPaint((Paint)this.getColor((String)keyVal.value));
                continue;
            }
            if (keyVal.key.equals(TYPE)) {
                value = (String)keyVal.value;
                if (value.equals(STRAIGHT_LINES)) {
                    edgeView.setLineType(2);
                    continue;
                }
                if (!value.equals(CURVED_LINES)) continue;
                edgeView.setLineType(1);
                continue;
            }
            if (keyVal.key.equals(ARROW)) {
                if (keyVal.value.equals(ARROW_FIRST)) {
                    edgeView.setSourceEdgeEnd(2);
                    continue;
                }
                if (keyVal.value.equals(ARROW_LAST)) {
                    edgeView.setTargetEdgeEnd(2);
                    continue;
                }
                if (keyVal.value.equals(ARROW_BOTH)) {
                    edgeView.setSourceEdgeEnd(2);
                    edgeView.setTargetEdgeEnd(2);
                    continue;
                }
                if (!keyVal.value.equals(ARROW_NONE)) continue;
                continue;
            }
            if (keyVal.key.equals(SOURCE_ARROW)) {
                edgeView.setSourceEdgeEnd(((Number)keyVal.value).intValue());
                continue;
            }
            if (!keyVal.key.equals(TARGET_ARROW)) continue;
            edgeView.setTargetEdgeEnd(((Number)keyVal.value).intValue());
        }
    }

    protected void layoutEdgeGraphicsLine(GraphView myView, List list, EdgeView edgeView) {
        for (KeyValue keyVal : list) {
            if (!keyVal.key.equals(POINT)) continue;
            Number x = null;
            Number y = null;
            for (KeyValue pointVal : (List)keyVal.value) {
                if (pointVal.key.equals(X)) {
                    x = (Number)pointVal.value;
                    continue;
                }
                if (!pointVal.key.equals(Y)) continue;
                y = (Number)pointVal.value;
            }
            if (x == null || y == null) continue;
            Point2D.Double pt = new Point2D.Double(x.doubleValue(), y.doubleValue());
            edgeView.getBend().addHandle((Point2D)pt);
        }
    }

    @Override
    public int[] getNodeIndicesArray() {
        this.giny_nodes.trimToSize();
        return this.giny_nodes.elements();
    }

    @Override
    public int[] getEdgeIndicesArray() {
        this.giny_edges.trimToSize();
        return this.giny_edges.elements();
    }

    public Color getColor(String colorString) {
        return new Color(Integer.parseInt(colorString.substring(1), 16));
    }

    @Override
    public void doPostProcessing(CyNetwork net) {
        CyInitParams init = CytoscapeInit.getCyInitParams();
        if (init == null) {
            return;
        }
        if (!(init.getMode() != 1 && init.getMode() != 4 || this.vsbSwitch != null && this.vsbSwitch.equals("off"))) {
            this.graphStyle.buildStyle();
        }
    }
}

