/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.readers.GMLNode;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.logger.CyLogger;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class GMLTree {
    GMLNode root;
    private static String VERSION = "1.0";
    private static String NODE_OPEN = "[";
    private static String NODE_CLOSE = "]";
    public static int STRING = 0;
    public static int DOUBLE = 1;
    public static int INTEGER = 2;
    public static int GMLTREE = 3;
    private static CyLogger logger = CyLogger.getLogger(GMLTree.class);

    public GMLTree() {
        this.root = new GMLNode();
    }

    public GMLTree(GMLNode init) {
        this.root = init;
    }

    public GMLTree(CyNetworkView networkView) {
        GMLNode graphics;
        DecimalFormat df = new DecimalFormat("####0.0#");
        CyNetworkView myView = networkView.getView();
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        this.root = new GMLNode();
        this.root.addMapping("Creator", new GMLNode("\"Cytoscape\""));
        this.root.addMapping("Version", new GMLNode(VERSION));
        GMLNode graph = new GMLNode();
        this.root.addMapping("graph", graph);
        Iterator viewIt = myView.getNodeViewsIterator();
        while (viewIt.hasNext()) {
            NodeView currentView = (NodeView)viewIt.next();
            Node currentNode = currentView.getNode();
            GMLNode currentGML = new GMLNode();
            currentGML.addMapping("id", new GMLNode("" + -currentNode.getRootGraphIndex()));
            String name = currentView.getNode().getIdentifier();
            if (name == null) {
                name = "unknown";
            }
            String label = "\"" + name + "\"";
            label.replaceAll("\\" + NODE_CLOSE, ")");
            label.replaceAll("\\" + NODE_OPEN, "(");
            currentGML.addMapping("label", new GMLNode(label));
            graphics = new GMLNode();
            graphics.addMapping("x", new GMLNode("" + df.format(currentView.getXPosition())));
            graphics.addMapping("y", new GMLNode("" + df.format(currentView.getYPosition())));
            graphics.addMapping("h", new GMLNode("" + df.format(currentView.getHeight())));
            graphics.addMapping("w", new GMLNode("" + df.format(currentView.getWidth())));
            Color nodeColor = (Color)currentView.getUnselectedPaint();
            graphics.addMapping("fill", new GMLNode("\"" + this.getColorHexString(nodeColor) + "\""));
            switch (currentView.getShape()) {
                case 6: {
                    graphics.addMapping("type", new GMLNode("\"rectangle\""));
                    break;
                }
                case 2: {
                    graphics.addMapping("type", new GMLNode("\"oval\""));
                }
            }
            currentGML.addMapping("graphics", graphics);
            graph.addMapping("node", currentGML);
        }
        viewIt = myView.getEdgeViewsIterator();
        CyAttributes edgeAttributes = Cytoscape.getEdgeAttributes();
        while (viewIt.hasNext()) {
            EdgeView currentView = (EdgeView)viewIt.next();
            Edge currentEdge = currentView.getEdge();
            GMLNode currentGML = new GMLNode();
            currentGML.addMapping("source", new GMLNode("" + -currentEdge.getSource().getRootGraphIndex()));
            currentGML.addMapping("target", new GMLNode("" + -currentEdge.getTarget().getRootGraphIndex()));
            String interaction = edgeAttributes.getStringAttribute(currentEdge.getIdentifier(), "interaction");
            if (interaction != null) {
                currentGML.addMapping("label", new GMLNode("\"" + interaction + "\""));
            }
            graphics = new GMLNode();
            graphics.addMapping("width", new GMLNode("" + df.format(currentView.getStrokeWidth())));
            switch (currentView.getLineType()) {
                case 2: {
                    graphics.addMapping("type", new GMLNode("\"line\""));
                    Point2D[] pointsArray = currentView.getBend().getDrawPoints();
                    if (pointsArray.length <= 2) break;
                    GMLNode Line = new GMLNode();
                    for (int i = 0; i < pointsArray.length; ++i) {
                        GMLNode point = new GMLNode();
                        point.addMapping("x", new GMLNode("" + df.format(pointsArray[i].getX())));
                        point.addMapping("y", new GMLNode("" + df.format(pointsArray[i].getY())));
                        Line.addMapping("point", point);
                    }
                    graphics.addMapping("Line", Line);
                }
            }
            Color edgeColor = (Color)currentView.getUnselectedPaint();
            graphics.addMapping("fill", new GMLNode("\"" + this.getColorHexString(edgeColor) + "\""));
            currentGML.addMapping("graphics", graphics);
            graph.addMapping("edge", currentGML);
        }
    }

    public GMLTree(String filename) {
        StringTokenizer quotes = null;
        if (filename.startsWith("jar://")) {
            try {
                TextJarReader reader = new TextJarReader(filename);
                reader.read();
                quotes = new StringTokenizer(reader.getText(), "\"", true);
            }
            catch (Exception e) {
                logger.warn("Error reading GML network from '" + filename + "': " + e.getMessage(), e);
                return;
            }
        } else {
            TextFileReader reader = new TextFileReader(filename);
            reader.read();
            quotes = new StringTokenizer(reader.getText(), "\"", true);
        }
        this.parse(quotes);
    }

    public GMLTree(String text, boolean zip_entry) {
        StringTokenizer quotes = new StringTokenizer(text, "\"", true);
        this.parse(quotes);
    }

    protected void parse(StringTokenizer quotes) {
        LinkedList<String> tokenList = new LinkedList<String>();
        while (quotes.hasMoreTokens()) {
            StringTokenizer tokens = new StringTokenizer(quotes.nextToken());
            while (tokens.hasMoreTokens()) {
                tokenList.add(tokens.nextToken());
            }
            if (!quotes.hasMoreTokens()) continue;
            String nextToken = quotes.nextToken();
            if (quotes.hasMoreTokens()) {
                nextToken = quotes.nextToken();
                if (!nextToken.equals("\"")) {
                    tokenList.add("\"" + nextToken + "\"");
                    if (quotes.hasMoreTokens()) {
                        quotes.nextToken();
                        continue;
                    }
                    throw new RuntimeException("Open quote with no end quote");
                }
                tokenList.add("\"\"");
                continue;
            }
            throw new RuntimeException("GMLFile ended with open quote");
        }
        this.root = GMLTree.initializeTree(tokenList);
    }

    private static GMLNode initializeTree(List tokens) {
        GMLNode result = new GMLNode();
        while (tokens.size() > 0) {
            String current = (String)tokens.remove(0);
            if (current.equals(NODE_OPEN)) {
                throw new RuntimeException("Error parsing GML file");
            }
            if (current.equals(NODE_CLOSE)) {
                return result;
            }
            String key = current;
            if (tokens.size() == 0) {
                throw new RuntimeException("Error parsing GML file");
            }
            current = (String)tokens.remove(0);
            if (current.equals(NODE_OPEN)) {
                result.addMapping(key, GMLTree.initializeTree(tokens));
                continue;
            }
            if (current.equals(NODE_CLOSE)) {
                throw new RuntimeException("Error parsing GML file");
            }
            result.addMapping(key, new GMLNode(current));
        }
        return result;
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        String result = this.root.toString();
        return result.substring(3, result.length() - 2) + lineSep;
    }

    public String getColorHexString(Color c) {
        return "#" + Integer.toHexString(256 + c.getRed()).substring(1) + Integer.toHexString(256 + c.getGreen()).substring(1) + Integer.toHexString(256 + c.getBlue()).substring(1);
    }

    private Vector getVector(Vector keys, int type) {
        Vector result = new Vector();
        GMLTree.getVector(this.root, keys, 0, type, result);
        return result;
    }

    public Vector getVector(String[] keys, int type) {
        Vector<String> keyVector = new Vector<String>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            keyVector.add(keys[i]);
        }
        return this.getVector(keyVector, type);
    }

    private static void getVector(GMLNode root, Vector keys, int index, int type, Vector result) {
        block8: {
            Vector mapped = root.getMapping((String)keys.get(index));
            if (mapped == null) break block8;
            Iterator it = mapped.iterator();
            if (index >= keys.size() - 1) {
                while (it.hasNext()) {
                    GMLNode current = (GMLNode)it.next();
                    if (type == STRING) {
                        result.add(current.stringValue());
                        continue;
                    }
                    if (type == INTEGER) {
                        result.add(current.integerValue());
                        continue;
                    }
                    if (type == DOUBLE) {
                        result.add(current.doubleValue());
                        continue;
                    }
                    if (type == GMLTREE) {
                        result.add(new GMLTree(current));
                        continue;
                    }
                    throw new IllegalArgumentException("bad type");
                }
            } else {
                while (it.hasNext()) {
                    GMLNode current = (GMLNode)it.next();
                    if (current.terminal) continue;
                    GMLTree.getVector(current, keys, index + 1, type, result);
                }
            }
        }
    }
}

