/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.webservice.ui;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.webservice.CyWebServiceEvent;
import cytoscape.data.webservice.CyWebServiceException;
import cytoscape.data.webservice.DatabaseSearchResult;
import cytoscape.data.webservice.NetworkImportWebServiceClient;
import cytoscape.data.webservice.WebServiceClient;
import cytoscape.data.webservice.WebServiceClientManager;
import cytoscape.data.webservice.ui.WebServiceClientGUI;
import cytoscape.data.webservice.util.WebServiceThemeInstall;
import cytoscape.layout.Tunable;
import cytoscape.logger.CyLogger;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.ModuleProperties;
import cytoscape.util.swing.AboutDialog;
import cytoscape.visual.VisualStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import org.jdesktop.layout.GroupLayout;
import org.jdom.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedNetworkImportDialog
extends JDialog
implements PropertyChangeListener {
    private static final UnifiedNetworkImportDialog dialog;
    private String selectedClientID = null;
    private WSNetworkImportTask task;
    private Map<String, String> clientNames;
    private Map<String, Container> serviceUIPanels = new HashMap<String, Container>();
    private static final Icon DEF_ICON;
    private static CyLogger logger;
    private int numDataSources = 0;
    private int numClients = 0;
    private boolean cancelFlag = false;
    private JButton cancelButton;
    private JComboBox datasourceComboBox;
    private JLabel datasourceLabel;
    private JPanel mainPanel;
    private JTabbedPane mainTabbedPane;
    private JPanel propertyPanel;
    private JScrollPane propertyScrollPane;
    private JButton resetButton;
    private JButton searchButton;
    private JScrollPane searchTermScrollPane;
    private JTextPane searchTermTextPane;
    private JLabel titleLabel;
    private JButton aboutButton;
    private JPanel buttonPanel;
    private JPanel queryPanel;
    private JPanel installPanel;
    private JButton clearButton;
    private JPanel dataQueryPanel;
    private JPanel datasourcePanel;
    private JLabel titleIconLabel;
    private JPanel titlePanel;

    public static void showDialog() {
        dialog.setLocationRelativeTo(Cytoscape.getDesktop());
        dialog.setVisible(true);
    }

    public UnifiedNetworkImportDialog(Frame parent, boolean modal) {
        super(parent, modal);
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this);
        this.initGUI();
    }

    public void resetGUI() {
        this.getContentPane().removeAll();
        this.initGUI();
    }

    private void initGUI() {
        this.clientNames = new HashMap<String, String>();
        List<WebServiceClient> clients = WebServiceClientManager.getAllClients();
        for (WebServiceClient client : clients) {
            if (!(client instanceof NetworkImportWebServiceClient)) continue;
            ++this.numClients;
        }
        this.initComponents();
        this.setDatasource();
        this.getContentPane().setLayout(new BorderLayout());
        if (this.numClients <= 1) {
            this.getContentPane().add((Component)this.installPanel, "South");
        }
        if (this.numClients > 0) {
            this.getContentPane().add((Component)this.queryPanel, "Center");
        }
        this.pack();
        this.setProperty(this.clientNames.get(this.datasourceComboBox.getSelectedItem()));
        this.selectedClientID = this.clientNames.get(this.datasourceComboBox.getSelectedItem());
        this.datasourceComboBoxActionPerformed(null);
    }

    private void initComponents() {
        this.mainTabbedPane = new JTabbedPane();
        this.searchTermScrollPane = new JScrollPane();
        this.searchTermTextPane = new JTextPane();
        this.propertyPanel = new JPanel();
        this.searchTermTextPane.setFont(new Font("SansSerif", 0, 12));
        this.searchTermTextPane.setText("Please enter search terms...");
        this.searchTermScrollPane.setViewportView(this.searchTermTextPane);
        this.mainTabbedPane.addTab("Query", this.searchTermScrollPane);
        GroupLayout propertyPanelLayout = new GroupLayout((Container)this.propertyPanel);
        this.propertyPanel.setLayout((LayoutManager)propertyPanelLayout);
        propertyPanelLayout.setHorizontalGroup((GroupLayout.Group)propertyPanelLayout.createParallelGroup(1).add(0, 408, Short.MAX_VALUE));
        propertyPanelLayout.setVerticalGroup((GroupLayout.Group)propertyPanelLayout.createParallelGroup(1).add(0, 303, Short.MAX_VALUE));
        this.propertyScrollPane = new JScrollPane();
        this.propertyScrollPane.setViewportView(this.propertyPanel);
        this.mainTabbedPane.addTab("Search Property", this.propertyScrollPane);
        this.titlePanel = new JPanel();
        this.titleIconLabel = new JLabel();
        this.datasourcePanel = new JPanel();
        this.datasourceLabel = new JLabel();
        this.datasourceComboBox = new JComboBox();
        this.aboutButton = new JButton();
        this.buttonPanel = new JPanel();
        this.searchButton = new JButton();
        this.cancelButton = new JButton();
        this.clearButton = new JButton();
        this.dataQueryPanel = new JPanel();
        this.setTitle("Import Network from Database");
        this.setDefaultCloseOperation(2);
        this.titlePanel.setBackground(new Color(0, 0, 0));
        this.titleIconLabel.setIcon(new ImageIcon(Cytoscape.class.getResource("images/networkImportIcon.png")));
        GroupLayout titlePanelLayout = new GroupLayout((Container)this.titlePanel);
        this.titlePanel.setLayout((LayoutManager)titlePanelLayout);
        titlePanelLayout.setHorizontalGroup((GroupLayout.Group)titlePanelLayout.createParallelGroup(1).add((Component)this.titleIconLabel, -2, 461, -2));
        titlePanelLayout.setVerticalGroup((GroupLayout.Group)titlePanelLayout.createParallelGroup(1).add((Component)this.titleIconLabel));
        this.datasourceLabel.setFont(new Font("SansSerif", 0, 12));
        this.datasourceLabel.setText("Data Source");
        this.datasourceComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnifiedNetworkImportDialog.this.datasourceComboBoxActionPerformed(evt);
            }
        });
        this.aboutButton.setText("About");
        this.aboutButton.setMargin(new Insets(2, 5, 2, 5));
        this.aboutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnifiedNetworkImportDialog.this.aboutButtonActionPerformed(evt);
            }
        });
        GroupLayout datasourcePanelLayout = new GroupLayout((Container)this.datasourcePanel);
        this.datasourcePanel.setLayout((LayoutManager)datasourcePanelLayout);
        datasourcePanelLayout.setHorizontalGroup((GroupLayout.Group)datasourcePanelLayout.createParallelGroup(1).add((GroupLayout.Group)datasourcePanelLayout.createSequentialGroup().addContainerGap().add((Component)this.datasourceLabel).addPreferredGap(0).add((Component)this.datasourceComboBox, 0, 301, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.aboutButton).addContainerGap()));
        datasourcePanelLayout.setVerticalGroup((GroupLayout.Group)datasourcePanelLayout.createParallelGroup(1).add((GroupLayout.Group)datasourcePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)datasourcePanelLayout.createParallelGroup(3).add((Component)this.datasourceLabel).add((Component)this.aboutButton).add((Component)this.datasourceComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.searchButton.setText("Search");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnifiedNetworkImportDialog.this.searchButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnifiedNetworkImportDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.clearButton.setText("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnifiedNetworkImportDialog.this.clearButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonPanelLayout = new GroupLayout((Container)this.buttonPanel);
        this.buttonPanel.setLayout((LayoutManager)buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup((GroupLayout.Group)buttonPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)buttonPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.clearButton).addPreferredGap(0, 225, Short.MAX_VALUE).add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.searchButton).addContainerGap()));
        buttonPanelLayout.setVerticalGroup((GroupLayout.Group)buttonPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)buttonPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)buttonPanelLayout.createParallelGroup(3).add((Component)this.searchButton).add((Component)this.cancelButton).add((Component)this.clearButton)).addContainerGap()));
        GroupLayout dataQueryPanelLayout = new GroupLayout((Container)this.dataQueryPanel);
        this.dataQueryPanel.setLayout((LayoutManager)dataQueryPanelLayout);
        dataQueryPanelLayout.setHorizontalGroup((GroupLayout.Group)dataQueryPanelLayout.createParallelGroup(1).add(0, 461, Short.MAX_VALUE));
        dataQueryPanelLayout.setVerticalGroup((GroupLayout.Group)dataQueryPanelLayout.createParallelGroup(1).add(0, 247, Short.MAX_VALUE));
        this.queryPanel = new JPanel();
        GroupLayout layout = new GroupLayout((Container)this.queryPanel);
        this.queryPanel.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.titlePanel, -1, -1, Short.MAX_VALUE).add((Component)this.datasourcePanel, -1, -1, Short.MAX_VALUE).add((Component)this.buttonPanel, -1, -1, Short.MAX_VALUE).add((Component)this.dataQueryPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.titlePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.datasourcePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.dataQueryPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.buttonPanel, -2, -1, -2)));
        this.dataQueryPanel.setLayout(new BorderLayout());
        this.createInstallPanel();
    }

    private void createInstallPanel() {
        this.installPanel = new JPanel();
        this.installPanel.setLayout(new BorderLayout());
        JLabel titleIconLabel2 = new JLabel();
        titleIconLabel2.setIcon(new ImageIcon(Cytoscape.class.getResource("images/networkImportIcon.png")));
        JPanel titlePanel2 = new JPanel();
        titlePanel2.add(titleIconLabel2);
        titlePanel2.setBackground(new Color(0, 0, 0));
        titlePanel2.setLayout(new FlowLayout(0));
        if (this.numClients == 0) {
            this.installPanel.add((Component)titlePanel2, "North");
        }
        JPanel internalPanel = new JPanel();
        internalPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        internalPanel.setLayout(new BoxLayout(internalPanel, 3));
        JTextArea area = new JTextArea(1, 40);
        area.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (this.numClients == 0) {
            area.setText("There are no network import web service clients installed.");
        } else {
            area.setText("To install additional web service clients, click the install button below.");
        }
        area.setEditable(false);
        area.setOpaque(false);
        area.setAlignmentX(0.0f);
        internalPanel.add(area);
        JButton installButton = new JButton("Install Web Services Pack");
        installButton.setAlignmentX(0.0f);
        internalPanel.add(Box.createVerticalStrut(15));
        internalPanel.add(installButton);
        this.installPanel.add((Component)internalPanel, "Center");
        this.createInstallButtonListener(installButton);
    }

    private void createInstallButtonListener(JButton installButton) {
        installButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                WebServiceThemeInstall wst = new WebServiceThemeInstall(UnifiedNetworkImportDialog.this);
                boolean displayError = false;
                try {
                    DownloadableInfo InstalledTheme = wst.installTheme();
                    if (InstalledTheme == null) {
                        displayError = true;
                    }
                }
                catch (IOException ioe) {
                    displayError = true;
                    logger.warn("I/O error reading theme: ", ioe);
                }
                catch (JDOMException jde) {
                    displayError = true;
                    logger.warn("JDOM error parsing theme: ", jde);
                }
                finally {
                    if (displayError) {
                        JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Failed to install the WebServiceThemePack", "Install Error", 0);
                    }
                }
                UnifiedNetworkImportDialog.this.setDatasource();
            }
        });
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.selectedClientID = this.clientNames.get(this.datasourceComboBox.getSelectedItem());
        CyWebServiceEvent<String> event = this.buildEvent();
        logger.info("Start importing network: " + evt.getActionCommand());
        this.task = new WSNetworkImportTask(this.datasourceComboBox.getSelectedItem().toString(), event);
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.setOwner((Container)Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(true);
        jTaskConfig.displayCancelButton(true);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(false);
        TaskManager.executeTask((Task)this.task, (JTaskConfig)jTaskConfig);
        logger.info("Network Import from WS Success!");
        this.dispose();
    }

    private void aboutButtonActionPerformed(ActionEvent evt) {
        WebServiceClient wsc = WebServiceClientManager.getClient(this.selectedClientID);
        String clientName = wsc.getDisplayName();
        String description = wsc.getDescription();
        Icon icon = null;
        if (wsc instanceof WebServiceClientGUI) {
            icon = ((WebServiceClientGUI)((Object)wsc)).getIcon(WebServiceClientGUI.IconSize.FULL);
        }
        if (icon == null) {
            icon = DEF_ICON;
        }
        AboutDialog.showDialog(clientName, icon, description);
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.searchTermTextPane.setText("");
    }

    private void datasourceComboBoxActionPerformed(ActionEvent evt) {
        this.searchTermTextPane.setText("");
        this.setProperty(this.clientNames.get(this.datasourceComboBox.getSelectedItem()));
        this.selectedClientID = this.clientNames.get(this.datasourceComboBox.getSelectedItem());
        this.dataQueryPanel.removeAll();
        Container gui = this.serviceUIPanels.get(this.selectedClientID);
        if (gui != null) {
            this.dataQueryPanel.add((Component)gui, "Center");
            this.buttonPanel.setVisible(false);
        } else {
            logger.info("No custom GUI.  Use default panel.");
            this.dataQueryPanel.add((Component)this.mainTabbedPane, "Center");
            this.buttonPanel.setVisible(true);
        }
        this.pack();
        this.repaint();
    }

    private void setProperty(String clientID) {
        WebServiceClient client = WebServiceClientManager.getClient(clientID);
        if (client == null) {
            return;
        }
        ModuleProperties props = client.getProps();
        List<Tunable> tunables = props.getTunables();
        this.propertyPanel = new JPanel(new GridLayout(0, 1));
        for (Tunable tu : tunables) {
            JPanel p = tu.getPanel();
            p.setBackground(Color.white);
            if (p == null) continue;
            this.propertyPanel.add(p);
        }
        this.propertyScrollPane.setViewportView(this.propertyPanel);
        this.pack();
        this.repaint();
    }

    private void setDatasource() {
        List<WebServiceClient> clients = WebServiceClientManager.getAllClients();
        for (WebServiceClient client : clients) {
            if (!(client instanceof NetworkImportWebServiceClient)) continue;
            this.datasourceComboBox.addItem(client.getDisplayName());
            this.clientNames.put(client.getDisplayName(), client.getClientID());
            if (client instanceof WebServiceClientGUI && ((WebServiceClientGUI)((Object)client)).getGUI() != null) {
                this.serviceUIPanels.put(client.getClientID(), (Container)((WebServiceClientGUI)((Object)client)).getGUI());
            }
            ++this.numDataSources;
        }
    }

    private CyWebServiceEvent<String> buildEvent() {
        String clientID = this.clientNames.get(this.datasourceComboBox.getSelectedItem());
        WebServiceClientManager.getClient(clientID).getProps().updateValues();
        return new CyWebServiceEvent<String>(clientID, CyWebServiceEvent.WSEventType.SEARCH_DATABASE, this.searchTermTextPane.getText(), CyWebServiceEvent.WSEventType.IMPORT_NETWORK);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.cancelFlag) {
            return;
        }
        Object resultObject = evt.getNewValue();
        if (evt.getPropertyName().equals(CyWebServiceEvent.WSResponseType.SEARCH_FINISHED.toString()) && resultObject != null && resultObject instanceof DatabaseSearchResult) {
            DatabaseSearchResult result = (DatabaseSearchResult)resultObject;
            if (!result.getNextMove().equals((Object)CyWebServiceEvent.WSEventType.IMPORT_NETWORK)) return;
            logger.info("Got search result from: " + evt.getSource() + ", Num result = " + result.getResultSize() + ", Source name = " + evt.getOldValue());
            String[] message = new String[]{result.getResultSize() + " records found in " + this.selectedClientID, "Do you want to create new network from the search result?"};
            int value = JOptionPane.showConfirmDialog(Cytoscape.getDesktop(), message, "Import network", 0);
            if (value != 0) return;
            CyWebServiceEvent evt2 = new CyWebServiceEvent(evt.getOldValue().toString(), CyWebServiceEvent.WSEventType.IMPORT_NETWORK, result.getResult());
            try {
                WebServiceClientManager.getCyWebServiceEventSupport().fireCyWebServiceEvent(evt2);
                return;
            }
            catch (CyWebServiceException e) {
                if (this.task.getTaskMonitor() == null) return;
                this.task.getTaskMonitor().setException((Throwable)e, "Database search failed.");
            }
            return;
        } else {
            if (!evt.getPropertyName().equals(CyWebServiceEvent.WSResponseType.DATA_IMPORT_FINISHED.toString())) return;
            if (evt.getNewValue() == null) {
                return;
            }
            String[] message = new String[]{"Network loaded.", "Please enter name for new network:"};
            String value = JOptionPane.showInputDialog(Cytoscape.getDesktop(), message, "Name new network", 3);
            if (value == null || value.length() == 0) {
                value = this.selectedClientID + " Network";
            }
            CyNetwork cyNetwork = Cytoscape.getCurrentNetwork();
            Cytoscape.getCurrentNetwork().setTitle(value);
            Cytoscape.getDesktop().getNetworkPanel().updateTitle(cyNetwork);
            VisualStyle style = ((NetworkImportWebServiceClient)((Object)WebServiceClientManager.getClient(this.selectedClientID))).getDefaultVisualStyle();
            if (style == null) {
                style = Cytoscape.getVisualMappingManager().getVisualStyle();
            }
            if (Cytoscape.getVisualMappingManager().getCalculatorCatalog().getVisualStyle(style.getName()) == null) {
                Cytoscape.getVisualMappingManager().getCalculatorCatalog().addVisualStyle(style);
            }
            Cytoscape.getVisualMappingManager().setVisualStyle(style);
        }
    }

    static {
        DEF_ICON = new ImageIcon(Cytoscape.class.getResource("images/ximian/stock_internet-32.png"));
        logger = CyLogger.getLogger(UnifiedNetworkImportDialog.class);
        dialog = new UnifiedNetworkImportDialog((Frame)Cytoscape.getDesktop(), false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WSNetworkImportTask
    implements Task {
        private String serviceName;
        private CyWebServiceEvent<String> evt;
        private TaskMonitor taskMonitor;

        public WSNetworkImportTask(String serviceName, CyWebServiceEvent<String> evt) {
            this.evt = evt;
            this.serviceName = serviceName;
        }

        public String getTitle() {
            return "Loading network from web service...";
        }

        public void halt() {
            UnifiedNetworkImportDialog.this.cancelFlag = true;
            Thread.currentThread().interrupt();
            this.taskMonitor.setPercentCompleted(100);
            CyWebServiceEvent<Object> cancelEvent = new CyWebServiceEvent<Object>(this.serviceName, CyWebServiceEvent.WSEventType.CANCEL, null, null);
            try {
                WebServiceClientManager.getCyWebServiceEventSupport().fireCyWebServiceEvent(cancelEvent);
            }
            catch (CyWebServiceException e) {
                this.taskMonitor.setException((Throwable)e, "Cancel Failed.");
            }
        }

        public void run() {
            UnifiedNetworkImportDialog.this.cancelFlag = false;
            this.taskMonitor.setStatus("Loading interactions from " + this.serviceName);
            this.taskMonitor.setPercentCompleted(-1);
            try {
                WebServiceClientManager.getCyWebServiceEventSupport().fireCyWebServiceEvent(this.evt);
            }
            catch (Exception e) {
                this.taskMonitor.setException((Throwable)e, "Failed to load network from web service.");
                return;
            }
            this.taskMonitor.setPercentCompleted(100);
            this.taskMonitor.setStatus("Network successfully loaded.");
        }

        public void setTaskMonitor(TaskMonitor arg0) throws IllegalThreadStateException {
            this.taskMonitor = arg0;
        }

        protected TaskMonitor getTaskMonitor() {
            return this.taskMonitor;
        }
    }
}

