/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.writers;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.data.writers.NamespacePrefixMapperForCysession;
import cytoscape.data.writers.XGMMLWriter;
import cytoscape.generated.Child;
import cytoscape.generated.Cysession;
import cytoscape.generated.Cytopanel;
import cytoscape.generated.Cytopanels;
import cytoscape.generated.Desktop;
import cytoscape.generated.DesktopSize;
import cytoscape.generated.Edge;
import cytoscape.generated.HiddenEdges;
import cytoscape.generated.HiddenNodes;
import cytoscape.generated.Network;
import cytoscape.generated.NetworkFrame;
import cytoscape.generated.NetworkFrames;
import cytoscape.generated.NetworkTree;
import cytoscape.generated.Node;
import cytoscape.generated.ObjectFactory;
import cytoscape.generated.Ontology;
import cytoscape.generated.OntologyServer;
import cytoscape.generated.Panel;
import cytoscape.generated.Panels;
import cytoscape.generated.Parent;
import cytoscape.generated.Plugins;
import cytoscape.generated.SelectedEdges;
import cytoscape.generated.SelectedNodes;
import cytoscape.generated.Server;
import cytoscape.generated.SessionState;
import cytoscape.util.BookmarksUtil;
import cytoscape.util.swing.JTreeTable;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.NetworkPanel;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JInternalFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class CytoscapeSessionWriter {
    private static final char[] INVALID_CHAR = new char[]{'[', '\\', '/', ':', '*', '?', '\"', '<', '>', '|', ']'};
    private static final String cysessionVersion = "0.9";
    public static final int NODE = 1;
    public static final int EDGE = 2;
    private static final String DEFAULT_VS_NAME = "default";
    private static final int CYTOPANEL_COUNT = 3;
    private static final int SETTING_FILE_COUNT = 4;
    private static final String CYSESSION_FILE_NAME = "cysession.xml";
    private static final String VIZMAP_FILE = "session_vizmap.props";
    private static final String CYPROP_FILE = "session_cytoscape.props";
    private static final String BOOKMARKS_FILE = "session_bookmarks.xml";
    private static final String XGMML_EXT = ".xgmml";
    private final String packageName = "cytoscape.generated";
    Properties prop;
    private static final String TREE_ROOT = "root";
    private String sessionFileName = null;
    private String[] targetFileNames;
    private Bookmarks bookmarks;
    private Set<CyNetwork> networks;
    private HashMap networkMap;
    private String sessionNote = "You can add note for this session here.";
    private ObjectFactory factory;
    private Cysession session;
    private NetworkTree tree;
    private SessionState sState;
    private List netList;
    private Cytopanels cps;
    private Plugins plugins;
    private String sessionDirName;
    private String sessionDir;
    private Map viewMap = Cytoscape.getNetworkViewMap();
    private ZipOutputStream zos;

    public CytoscapeSessionWriter(String sessionName) {
        this.sessionFileName = sessionName;
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd-HH_mm");
        this.sessionDirName = "CytoscapeSession-" + df.format(new Date());
        this.sessionDir = this.sessionDirName + "/";
        this.networks = Cytoscape.getNetworkSet();
        this.networkMap = new HashMap();
    }

    public void writeSessionToDisk() throws Exception {
        this.zos = new ZipOutputStream(new FileOutputStream(this.sessionFileName));
        for (CyNetwork network : this.networks) {
            this.zipNetwork(network);
        }
        this.zipCySession();
        this.zipVizmapProps();
        this.zipCytoscapeProps();
        this.zipBookmarks();
        this.zipFileListMap();
        this.zos.close();
        Cytoscape.firePropertyChange(Cytoscape.SESSION_SAVED, null, null);
    }

    private String getValidFileName(String fileName) {
        String newFileName = fileName;
        Integer i = 0;
        char[] arr$ = INVALID_CHAR;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character ch = Character.valueOf(arr$[i$]);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            newFileName = newFileName.replace(ch.toString(), n.toString());
        }
        return newFileName;
    }

    private void initObjectsForDataBinding() throws JAXBException {
        this.factory = new ObjectFactory();
        this.session = this.factory.createCysession();
        this.session.setSessionNote(this.sessionNote);
        this.tree = this.factory.createNetworkTree();
        this.sState = this.factory.createSessionState();
        this.setDesktopStates();
        this.session.setSessionState(this.sState);
        this.cps = this.getCytoPanelStates();
        this.netList = this.tree.getNetwork();
        this.sState.setPlugins(this.plugins);
        this.sState.setCytopanels(this.cps);
        this.sState.setServer(this.getServerState());
    }

    private void setDesktopStates() throws JAXBException {
        DesktopSize dSize = this.factory.createDesktopSize();
        NetworkFrames frames = this.factory.createNetworkFrames();
        Component[] networkFrames = Cytoscape.getDesktop().getNetworkViewManager().getDesktopPane().getComponents();
        for (int i = 0; i < networkFrames.length; ++i) {
            if (!(networkFrames[i] instanceof JInternalFrame)) continue;
            JInternalFrame networkFrame = (JInternalFrame)networkFrames[i];
            NetworkFrame frame = this.factory.createNetworkFrame();
            frame.setFrameID(networkFrame.getTitle());
            frame.setWidth(BigInteger.valueOf(networkFrame.getWidth()));
            frame.setHeight(BigInteger.valueOf(networkFrame.getHeight()));
            frame.setX(BigInteger.valueOf(networkFrame.getX()));
            frame.setY(BigInteger.valueOf(networkFrame.getY()));
            frames.getNetworkFrame().add(frame);
        }
        dSize.setHeight(BigInteger.valueOf(Cytoscape.getDesktop().getSize().height));
        dSize.setWidth(BigInteger.valueOf(Cytoscape.getDesktop().getSize().width));
        Desktop desktop = this.factory.createDesktop();
        desktop.setDesktopSize(dSize);
        desktop.setNetworkFrames(frames);
        this.sState.setDesktop(desktop);
    }

    private void zipVizmapProps() throws IOException {
        VisualMappingManager vizmapper = Cytoscape.getVisualMappingManager();
        CalculatorCatalog catalog = vizmapper.getCalculatorCatalog();
        this.zos.putNextEntry(new ZipEntry(this.sessionDir + VIZMAP_FILE));
        OutputStreamWriter writer = new OutputStreamWriter(this.zos);
        CalculatorIO.storeCatalog(catalog, writer);
        this.zos.closeEntry();
    }

    private void zipCytoscapeProps() throws IOException {
        this.zos.putNextEntry(new ZipEntry(this.sessionDir + CYPROP_FILE));
        CytoscapeInit.getProperties().store(this.zos, "Cytoscape Property File");
        this.zos.closeEntry();
    }

    private void zipBookmarks() throws IOException, JAXBException {
        this.zos.putNextEntry(new ZipEntry(this.sessionDir + BOOKMARKS_FILE));
        this.bookmarks = Cytoscape.getBookmarks();
        BookmarksUtil.saveBookmark(this.bookmarks, this.zos);
        this.zos.closeEntry();
    }

    private void zipNetwork(CyNetwork network) throws IOException, JAXBException, URISyntaxException {
        String xgmmlFile = this.getValidFileName(network.getTitle() + XGMML_EXT);
        CyNetworkView view = Cytoscape.getNetworkView(network.getIdentifier());
        this.zos.putNextEntry(new ZipEntry(this.sessionDir + xgmmlFile));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.zos, "UTF-8");
        XGMMLWriter xgmmlWriter = new XGMMLWriter(network, view, true);
        xgmmlWriter.write(writer);
        this.zos.closeEntry();
        writer = null;
        xgmmlWriter = null;
    }

    private void zipCySession() throws Exception {
        JAXBContext jc = JAXBContext.newInstance((String)"cytoscape.generated", (ClassLoader)this.getClass().getClassLoader());
        this.initObjectsForDataBinding();
        this.session.setId(this.sessionDirName);
        this.session.setDocumentVersion(cysessionVersion);
        this.getNetworkTree();
        this.session.setNetworkTree(this.tree);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperForCysession());
        this.zos.putNextEntry(new ZipEntry(this.sessionDir + CYSESSION_FILE_NAME));
        m.marshal((Object)this.session, (OutputStream)this.zos);
        this.zos.closeEntry();
        m = null;
        this.session = null;
    }

    private void zipFileListMap() throws IOException {
        HashMap pluginFileMap = new HashMap();
        Cytoscape.firePropertyChange("SAVE_PLUGIN_STATE", pluginFileMap, null);
        if (pluginFileMap != null && pluginFileMap.size() > 0) {
            byte[] buf = new byte[5000];
            Set pluginSet = pluginFileMap.keySet();
            for (String pluginName : pluginSet) {
                List theFileList = (List)pluginFileMap.get(pluginName);
                if (theFileList == null || theFileList.size() == 0) continue;
                for (File theFile : theFileList) {
                    if (theFile == null || !theFile.exists()) continue;
                    this.zos.putNextEntry(new ZipEntry(this.sessionDir + "plugins/" + pluginName + "/" + theFile.getName()));
                    FileInputStream fileIS = new FileInputStream(theFile);
                    int numRead = 0;
                    while ((numRead = fileIS.read(buf)) > -1) {
                        this.zos.write(buf, 0, numRead);
                    }
                    fileIS.close();
                    this.zos.closeEntry();
                }
            }
        }
    }

    private void getNetworkTree() throws Exception {
        CytoscapeDesktop cyDesktop = Cytoscape.getDesktop();
        NetworkPanel netPanel = cyDesktop.getNetworkPanel();
        JTreeTable treeTable = netPanel.getTreeTable();
        for (CyNetwork network : this.networks) {
            String networkID = network.getIdentifier();
            String networkName = network.getTitle();
            this.networkMap.put(networkName, networkID);
        }
        if (treeTable != null) {
            NetworkPanel.NetworkTreeNode root = netPanel.getNetworkNode(TREE_ROOT);
            this.walkTree(root);
        }
    }

    private void walkTree(DefaultMutableTreeNode node) throws JAXBException {
        CyNetworkView curNetworkView;
        SelectedEdges se;
        int childCount = node.getChildCount();
        String fileName = node.getUserObject().toString() + XGMML_EXT;
        Network curNode = this.factory.createNetwork();
        curNode.setFilename(this.getValidFileName(fileName));
        curNode.setId(node.getUserObject().toString());
        CyNetwork curNet = Cytoscape.getNetwork((String)this.networkMap.get(node.getUserObject().toString()));
        CyNetworkView curView = (CyNetworkView)this.viewMap.get(curNet.getIdentifier());
        if (!node.getUserObject().toString().equals("Network Root")) {
            VisualStyle curVS;
            String visualStyleName = null;
            if (curView != null && (curVS = curView.getVisualStyle()) != null) {
                visualStyleName = curVS.getName();
            }
            if (visualStyleName == null) {
                visualStyleName = DEFAULT_VS_NAME;
            }
            curNode.setVisualStyle(visualStyleName);
        } else {
            curNode.setVisualStyle(DEFAULT_VS_NAME);
        }
        if (Cytoscape.getNetworkView((String)this.networkMap.get(node.getUserObject().toString())) == Cytoscape.getNullNetworkView()) {
            curNode.setViewAvailable(false);
        } else {
            curNode.setViewAvailable(true);
        }
        Parent parent = null;
        parent = this.factory.createParent();
        if (node.getParent() == null) {
            parent.setId("NULL");
            curNode.setParent(parent);
        } else {
            DefaultMutableTreeNode curParent = (DefaultMutableTreeNode)node.getParent();
            parent.setId(curParent.getUserObject().toString());
            curNode.setParent(parent);
        }
        List<Child> children = curNode.getChild();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            Child childNetwork = this.factory.createChild();
            childNetwork.setId(child.getUserObject().toString());
            children.add(childNetwork);
            if (child.isLeaf()) {
                SelectedEdges se2;
                VisualStyle leafVS;
                Network leaf = this.factory.createNetwork();
                String childFileName = child.getUserObject().toString() + XGMML_EXT;
                leaf.setFilename(this.getValidFileName(childFileName));
                leaf.setId(child.getUserObject().toString());
                CyNetworkView leafView = Cytoscape.getNetworkView((String)this.networkMap.get(child.getUserObject().toString()));
                String leafVisualStyleName = null;
                if (leafView != Cytoscape.getNullNetworkView() && (leafVS = leafView.getVisualStyle()) != null) {
                    leafVisualStyleName = leafVS.getName();
                }
                if (leafVisualStyleName == null) {
                    leafVisualStyleName = DEFAULT_VS_NAME;
                }
                leaf.setVisualStyle(leafVisualStyleName);
                String targetID = (String)this.networkMap.get(child.getUserObject().toString());
                Parent tempParent = this.factory.createParent();
                tempParent.setId(curNode.getId());
                leaf.setParent(tempParent);
                CyNetwork targetNetwork = Cytoscape.getNetwork(targetID);
                CyNetworkView curNetworkView2 = Cytoscape.getNetworkView(targetID);
                if (curNetworkView2 == Cytoscape.getNullNetworkView()) {
                    leaf.setViewAvailable(false);
                } else {
                    leaf.setViewAvailable(true);
                }
                SelectedNodes sn = (SelectedNodes)this.getSelectedObjects(1, targetNetwork);
                if (sn != null) {
                    leaf.setSelectedNodes(sn);
                }
                if ((se2 = (SelectedEdges)this.getSelectedObjects(2, targetNetwork)) != null) {
                    leaf.setSelectedEdges(se2);
                }
                HiddenNodes hn = (HiddenNodes)this.getHiddenObjects(1, curNetworkView2);
                HiddenEdges he = (HiddenEdges)this.getHiddenObjects(2, curNetworkView2);
                if (hn != null) {
                    leaf.setHiddenNodes(hn);
                }
                if (he != null) {
                    leaf.setHiddenEdges(he);
                }
                this.netList.add(leaf);
                continue;
            }
            this.walkTree(child);
        }
        String targetID = (String)this.networkMap.get(node.getUserObject().toString());
        CyNetwork targetNetwork = Cytoscape.getNetwork(targetID);
        SelectedNodes sn = (SelectedNodes)this.getSelectedObjects(1, targetNetwork);
        if (sn != null) {
            curNode.setSelectedNodes(sn);
        }
        if ((se = (SelectedEdges)this.getSelectedObjects(2, targetNetwork)) != null) {
            curNode.setSelectedEdges(se);
        }
        if ((curNetworkView = Cytoscape.getNetworkView(targetID)) != Cytoscape.getNullNetworkView()) {
            HiddenNodes hn = (HiddenNodes)this.getHiddenObjects(1, curNetworkView);
            HiddenEdges he = (HiddenEdges)this.getHiddenObjects(2, curNetworkView);
            if (hn != null) {
                curNode.setHiddenNodes(hn);
            }
            if (he != null) {
                curNode.setHiddenEdges(he);
            }
        }
        this.netList.add(curNode);
    }

    private Object getHiddenObjects(int type, CyNetworkView view) throws JAXBException {
        if (type == 1) {
            HiddenNodes hn = this.factory.createHiddenNodes();
            List<Node> hNodeList = hn.getNode();
            CyNode targetNode = null;
            String curNodeName = null;
            Iterator i = view.getNodeViewsIterator();
            while (i.hasNext()) {
                NodeView nview = (NodeView)i.next();
                if (!view.showGraphObject(nview)) continue;
                targetNode = (CyNode)nview.getNode();
                curNodeName = targetNode.getIdentifier();
                Node tempNode = this.factory.createNode();
                tempNode.setId(curNodeName);
                hNodeList.add(tempNode);
                view.hideGraphObject(nview);
            }
            if (hn.getNode().size() != 0) {
                return hn;
            }
            return null;
        }
        if (type == 2) {
            HiddenEdges he = this.factory.createHiddenEdges();
            List<Edge> hEdgeList = he.getEdge();
            CyEdge targetEdge = null;
            String curEdgeName = null;
            Iterator i = view.getEdgeViewsIterator();
            while (i.hasNext()) {
                EdgeView eview = (EdgeView)i.next();
                if (!view.showGraphObject(eview)) continue;
                targetEdge = (CyEdge)eview.getEdge();
                curEdgeName = targetEdge.getIdentifier();
                Edge tempEdge = this.factory.createEdge();
                tempEdge.setId(curEdgeName);
                tempEdge.setSource(targetEdge.getSource().getIdentifier());
                tempEdge.setTarget(targetEdge.getTarget().getIdentifier());
                tempEdge.setInteraction(Cytoscape.getEdgeAttributes().getStringAttribute(targetEdge.getIdentifier(), "interaction"));
                hEdgeList.add(tempEdge);
                view.hideGraphObject(eview);
            }
            if (he.getEdge().size() != 0) {
                return he;
            }
            return null;
        }
        return null;
    }

    private Object getSelectedObjects(int type, CyNetwork curNet) throws JAXBException {
        if (type == 1) {
            SelectedNodes sn = this.factory.createSelectedNodes();
            List<Node> sNodeList = sn.getNode();
            Set selectedNodes = curNet.getSelectedNodes();
            if (selectedNodes.size() != 0) {
                Iterator iterator = selectedNodes.iterator();
                CyNode targetNode = null;
                while (iterator.hasNext()) {
                    targetNode = (CyNode)iterator.next();
                    String curNodeName = targetNode.getIdentifier();
                    Node tempNode = this.factory.createNode();
                    tempNode.setId(curNodeName);
                    sNodeList.add(tempNode);
                }
                return sn;
            }
            return null;
        }
        if (type == 2) {
            SelectedEdges se = this.factory.createSelectedEdges();
            List<Edge> sEdgeList = se.getEdge();
            Set selectedEdges = curNet.getSelectedEdges();
            if (selectedEdges.size() != 0) {
                Iterator iterator = selectedEdges.iterator();
                CyEdge targetEdge = null;
                while (iterator.hasNext()) {
                    targetEdge = (CyEdge)iterator.next();
                    String curEdgeName = targetEdge.getIdentifier();
                    Edge tempEdge = this.factory.createEdge();
                    tempEdge.setId(curEdgeName);
                    tempEdge.setSource(targetEdge.getSource().getIdentifier());
                    tempEdge.setTarget(targetEdge.getTarget().getIdentifier());
                    tempEdge.setInteraction(Cytoscape.getEdgeAttributes().getStringAttribute(targetEdge.getIdentifier(), "interaction"));
                    sEdgeList.add(tempEdge);
                }
                return se;
            }
            return null;
        }
        return null;
    }

    private Cytopanels getCytoPanelStates() throws JAXBException {
        Cytopanels cps = this.factory.createCytopanels();
        List<Cytopanel> cytoPanelList = cps.getCytopanel();
        String[] cytopanelStates = new String[4];
        int[] selectedPanels = new int[4];
        cytopanelStates[1] = Cytoscape.getDesktop().getCytoPanel(7).getState().toString();
        selectedPanels[1] = Cytoscape.getDesktop().getCytoPanel(7).getSelectedIndex();
        cytopanelStates[2] = Cytoscape.getDesktop().getCytoPanel(5).getState().toString();
        selectedPanels[2] = Cytoscape.getDesktop().getCytoPanel(5).getSelectedIndex();
        cytopanelStates[3] = Cytoscape.getDesktop().getCytoPanel(3).getState().toString();
        selectedPanels[3] = Cytoscape.getDesktop().getCytoPanel(3).getSelectedIndex();
        for (int i = 1; i < 4; ++i) {
            Panels internalPanels = this.factory.createPanels();
            List<Panel> iPanelList = internalPanels.getPanel();
            Panel iPanel = this.factory.createPanel();
            iPanel.setId("test");
            iPanelList.add(iPanel);
            Cytopanel curCp = this.factory.createCytopanel();
            curCp.setId("CytoPanel" + i);
            curCp.setPanelState(cytopanelStates[i]);
            curCp.setSelectedPanel(Integer.toString(selectedPanels[i]));
            curCp.setPanels(internalPanels);
            cytoPanelList.add(curCp);
        }
        return cps;
    }

    public void setSessionNote(String note) {
        this.sessionNote = note;
    }

    private Server getServerState() {
        Server server = this.factory.createServer();
        OntologyServer os = this.factory.createOntologyServer();
        Set<String> ontoNames = Cytoscape.getOntologyServer().getOntologyNames();
        Map<String, URL> sources = Cytoscape.getOntologyServer().getOntologySources();
        for (String name : ontoNames) {
            Ontology onto = this.factory.createOntology();
            onto.setName(name);
            onto.setHref(sources.get(name).toString());
            os.getOntology().add(onto);
        }
        server.setOntologyServer(os);
        return server;
    }
}

