/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.plugins;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeVersion;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.bookmarks.DataSource;
import cytoscape.dialogs.plugins.PluginManageDialog;
import cytoscape.dialogs.preferences.BookmarkDialog;
import cytoscape.logger.CyLogger;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.ManagerUtil;
import cytoscape.plugin.PluginInquireAction;
import cytoscape.plugin.PluginManager;
import cytoscape.plugin.PluginManagerInquireTask;
import cytoscape.plugin.PluginStatus;
import cytoscape.task.Task;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.BookmarksUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jdesktop.layout.GroupLayout;

public class PluginUrlDialog
extends JDialog {
    private String bookmarkCategory = "plugins";
    private Bookmarks theBookmarks;
    private PluginManageDialog parentDialog;
    private static CyLogger logger = CyLogger.getLogger(PluginUrlDialog.class);
    private JButton editSiteButton;
    private JButton cancelButton;
    private JPanel jPanel1;
    private JLabel label;
    private JPanel labelPanel;
    private JButton okButton;
    private JComboBox urlComboBox;

    public PluginUrlDialog(JDialog owner) {
        super((Dialog)owner, "Plugin Download Sites");
        this.parentDialog = (PluginManageDialog)owner;
        this.setLocationRelativeTo(owner);
        this.bookmarksSetUp();
        this.initComponents();
    }

    public void addItems(String[] Items) {
        this.urlComboBox.setModel(new DefaultComboBoxModel<String>(Items));
    }

    private void bookmarksSetUp() {
        try {
            this.theBookmarks = Cytoscape.getBookmarks();
        }
        catch (Exception E) {
            JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Failed to retrieve bookmarks for plugin download sites.", "Error", 0);
            logger.warn("Failed to retrieve bookmarks for plugin download sites.", E);
            return;
        }
        if (this.theBookmarks == null) {
            this.theBookmarks = new Bookmarks();
            Cytoscape.setBookmarks(this.theBookmarks);
        }
    }

    private void okHandler(ActionEvent evt) {
        DataSource SelectedSite = (DataSource)this.urlComboBox.getSelectedItem();
        this.parentDialog.switchDownloadSites();
        this.dispose();
        PluginManagerInquireTask task = new PluginManagerInquireTask(SelectedSite.getHref(), new UrlAction(this.parentDialog, SelectedSite.getHref()));
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.setOwner((Container)Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(false);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(true);
        jTaskConfig.displayCancelButton(true);
        TaskManager.executeTask((Task)task, (JTaskConfig)jTaskConfig);
        this.parentDialog.setSiteName(SelectedSite.getName());
    }

    private void addSiteHandler(ActionEvent evt) {
        try {
            final int preEdit = BookmarksUtil.getDataSourceList(this.bookmarkCategory, this.theBookmarks.getCategory()).size();
            BookmarkDialog bDialog = new BookmarkDialog(Cytoscape.getDesktop(), "plugins");
            bDialog.addWindowListener(new WindowListener(){

                public void windowClosed(WindowEvent evt) {
                    int postEdit = BookmarksUtil.getDataSourceList(PluginUrlDialog.this.bookmarkCategory, PluginUrlDialog.this.theBookmarks.getCategory()).size();
                    if (preEdit >= postEdit) {
                        PluginUrlDialog.this.loadBookmarkCMBox(false);
                    } else {
                        PluginUrlDialog.this.loadBookmarkCMBox(true);
                    }
                }

                public void windowOpened(WindowEvent evt) {
                }

                public void windowDeiconified(WindowEvent evt) {
                }

                public void windowIconified(WindowEvent evt) {
                }

                public void windowClosing(WindowEvent evt) {
                }

                public void windowDeactivated(WindowEvent evt) {
                }

                public void windowActivated(WindowEvent evt) {
                }
            });
            bDialog.pack();
            bDialog.setVisible(true);
        }
        catch (Exception E) {
            JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Failed to get bookmarks.  Go to Edit->Preferences->Bookmarks to edit your plugin download sites.", "Error", 0);
            logger.warn("Failed to get bookmarks from plugin download sites: " + E.getMessage(), E);
        }
    }

    private void loadBookmarkCMBox(boolean selectLast) {
        DefaultComboBoxModel<DataSource> theModel = new DefaultComboBoxModel<DataSource>();
        List<DataSource> theDataSourceList = BookmarksUtil.getDataSourceList(this.bookmarkCategory, this.theBookmarks.getCategory());
        if (theDataSourceList != null) {
            for (DataSource Current : theDataSourceList) {
                theModel.addElement(Current);
                if (!selectLast) continue;
                theModel.setSelectedItem(Current);
            }
        }
        this.urlComboBox.setModel(theModel);
    }

    private void initComponents() {
        this.labelPanel = new JPanel();
        this.label = new JLabel();
        this.urlComboBox = new JComboBox();
        this.urlComboBox.setRenderer(new BookmarkCellRenderer());
        this.urlComboBox.setEditable(false);
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.editSiteButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.label.setText("Choose a plugin download site");
        GroupLayout labelPanelLayout = new GroupLayout((Container)this.labelPanel);
        this.labelPanel.setLayout((LayoutManager)labelPanelLayout);
        labelPanelLayout.setHorizontalGroup((GroupLayout.Group)labelPanelLayout.createParallelGroup(1).add((GroupLayout.Group)labelPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.label, -1, 239, Short.MAX_VALUE).addContainerGap()));
        labelPanelLayout.setVerticalGroup((GroupLayout.Group)labelPanelLayout.createParallelGroup(1).add((GroupLayout.Group)labelPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.label, -1, 16, Short.MAX_VALUE).addContainerGap()));
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginUrlDialog.this.okHandler(evt);
            }
        });
        this.editSiteButton.setText("Edit Sites");
        this.editSiteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginUrlDialog.this.addSiteHandler(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginUrlDialog.this.dispose();
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(8, 8, 8).add((Component)this.okButton).addPreferredGap(0).add((Component)this.editSiteButton).addPreferredGap(0).add((Component)this.cancelButton).addContainerGap(46, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.okButton).add((Component)this.editSiteButton).add((Component)this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.labelPanel, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.urlComboBox, 0, 296, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.labelPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.urlComboBox, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2)));
        this.loadBookmarkCMBox(false);
        this.pack();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UrlAction
    extends PluginInquireAction {
        private PluginManageDialog dialog;
        private String url;

        public UrlAction(PluginManageDialog Dialog2, String Url) {
            this.dialog = Dialog2;
            this.url = Url;
        }

        public boolean displayProgressBar() {
            return true;
        }

        @Override
        public String getProgressBarMessage() {
            return "Attempting to connect...";
        }

        @Override
        public void inquireAction(List<DownloadableInfo> Results) {
            block5: {
                block3: {
                    block4: {
                        if (!this.isExceptionThrown()) break block3;
                        if (this.getIOException() == null) break block4;
                        logger.warn((Object)((Object)PluginManageDialog.CommonError.NOXML) + this.url, this.getIOException());
                        this.dialog.setError((Object)((Object)PluginManageDialog.CommonError.NOXML) + this.url);
                        break block5;
                    }
                    if (this.getJDOMException() == null) break block5;
                    logger.warn((Object)((Object)PluginManageDialog.CommonError.BADXML) + this.url, this.getJDOMException());
                    this.dialog.setError((Object)((Object)PluginManageDialog.CommonError.BADXML) + this.url);
                    break block5;
                }
                PluginManager Mgr = PluginManager.getPluginManager();
                List<DownloadableInfo> UniqueAvailable = ManagerUtil.getUnique(Mgr.getDownloadables(PluginStatus.CURRENT), Results);
                Map<String, List<DownloadableInfo>> NewPlugins = ManagerUtil.sortByCategory(UniqueAvailable);
                if (NewPlugins.size() <= 0) {
                    this.dialog.setError("No plugins compatible with " + new CytoscapeVersion().getFullVersion() + " available from this site.");
                } else {
                    this.dialog.setMessage("");
                }
                for (String Category2 : NewPlugins.keySet()) {
                    this.dialog.addCategory(Category2, NewPlugins.get(Category2), PluginManageDialog.PluginInstallStatus.AVAILABLE);
                }
            }
        }
    }

    private class BookmarkCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public BookmarkCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DataSource dataSource = (DataSource)value;
            this.setText(dataSource.getName());
            if (isSelected && 0 < index) {
                list.setToolTipText(dataSource.getHref());
            }
            return this;
        }
    }
}

