/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.giny;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.actions.GinyUtils;
import cytoscape.data.CyNetworkUtilities;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.view.CyEdgeView;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CyNodeView;
import cytoscape.view.FlagAndSelectionHandler;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.ui.VizMapUI;
import ding.view.EdgeContextMenuListener;
import ding.view.NodeContextMenuListener;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import giny.model.GraphPerspective;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Paint;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import phoebe.PGraphView;

public class PhoebeNetworkView
extends PGraphView
implements CyNetworkView {
    boolean vizmapEnabled = true;
    protected String title;
    protected JLabel statusLabel;
    protected FlagAndSelectionHandler flagAndSelectionHandler;
    protected Map clientData;
    protected PBasicInputEventHandler keyEventHandler;
    protected VisualStyle vs;

    public PhoebeNetworkView(CyNetwork network, String title) {
        super((GraphPerspective)network);
        this.title = title;
        this.initialize();
    }

    protected void initialize() {
        this.statusLabel = new JLabel();
        ((JComponent)this.getComponent()).add((Component)this.statusLabel, "South");
        this.updateStatusLabel();
        this.clientData = new HashMap();
        this.enableNodeSelection();
        this.enableEdgeSelection();
        GraphView[] graphViews = new GraphView[]{this};
        this.flagAndSelectionHandler = new FlagAndSelectionHandler(this.getNetwork().getSelectFilter(), this);
        this.vs = null;
    }

    public void setVisualStyle(String VSName) {
        this.vs = Cytoscape.getVisualMappingManager().getCalculatorCatalog().getVisualStyle(VSName);
    }

    public VisualStyle getVisualStyle() {
        return this.vs;
    }

    protected void initializeEventHandlers() {
        super.initializeEventHandlers();
        this.keyEventHandler = new PBasicInputEventHandler(){
            PText typeAheadNode = new PText();
            PPath background = new PPath();
            StringBuffer typeBuffer = new StringBuffer();
            int length = 0;
            boolean space_down = false;
            boolean slash_pressed = false;

            protected void selectAndZoom() {
                String search_string = this.length == 0 ? "" : this.typeBuffer.toString() + "*";
                GinyUtils.deselectAllNodes(Cytoscape.getCurrentNetworkView());
                this.typeAheadNode.setText(this.typeBuffer.toString());
                CyNetworkUtilities.selectNodesStartingWith(Cytoscape.getCurrentNetwork(), search_string, Cytoscape.getCurrentNetworkView());
            }

            protected void resetFind() {
                this.slash_pressed = false;
                this.length = 0;
                this.typeBuffer = new StringBuffer();
                this.typeAheadNode.setText("");
                PhoebeNetworkView.this.getCanvas().getCamera().removeChild((PNode)this.typeAheadNode);
            }

            public void keyPressed(PInputEvent event) {
                if (event.getKeyCode() == 32) {
                    this.space_down = true;
                    PhoebeNetworkView.this.getCanvas().setCursor(Cursor.getPredefinedCursor(12));
                    PhoebeNetworkView.this.getCanvas().getPanEventHandler().setEventFilter(new PInputEventFilter(16));
                    if (PhoebeNetworkView.this.nodeSelection) {
                        PhoebeNetworkView.this.getCanvas().removeInputEventListener((PInputEventListener)PhoebeNetworkView.this.getSelectionHandler());
                    }
                    if (PhoebeNetworkView.this.edgeSelection) {
                        PhoebeNetworkView.this.getCanvas().removeInputEventListener((PInputEventListener)PhoebeNetworkView.this.getEdgeSelectionHandler());
                    }
                } else if (!this.slash_pressed && event.getKeyCode() == 47) {
                    this.slash_pressed = true;
                    PhoebeNetworkView.this.getCanvas().getCamera().addChild((PNode)this.typeAheadNode);
                    this.typeAheadNode.setOffset(20.0, 20.0);
                    this.typeAheadNode.setPaint((Paint)new Color(0.0f, 0.0f, 0.0f, 0.6f));
                    this.typeAheadNode.setTextPaint((Paint)Color.white);
                    this.typeAheadNode.setFont(this.typeAheadNode.getFont().deriveFont(30.0f));
                } else if (this.slash_pressed && event.getKeyCode() != 27 && event.getKeyCode() != 8) {
                    this.typeBuffer.append(KeyEvent.getKeyText(event.getKeyCode()));
                    ++this.length;
                    this.selectAndZoom();
                } else if (this.slash_pressed && event.getKeyCode() == 27) {
                    this.resetFind();
                } else if (this.slash_pressed && event.getKeyCode() == 8) {
                    if (this.length != 0) {
                        this.typeBuffer.deleteCharAt(this.length - 1);
                        --this.length;
                    }
                    this.selectAndZoom();
                    return;
                }
            }

            public void keyReleased(PInputEvent event) {
                if (this.space_down) {
                    this.space_down = false;
                    PhoebeNetworkView.this.getCanvas().setCursor(Cursor.getPredefinedCursor(0));
                    PhoebeNetworkView.this.getCanvas().getPanEventHandler().setEventFilter(new PInputEventFilter(8));
                    if (PhoebeNetworkView.this.nodeSelection) {
                        PhoebeNetworkView.this.getCanvas().addInputEventListener((PInputEventListener)PhoebeNetworkView.this.getSelectionHandler());
                    }
                    if (PhoebeNetworkView.this.edgeSelection) {
                        PhoebeNetworkView.this.getCanvas().addInputEventListener((PInputEventListener)PhoebeNetworkView.this.getEdgeSelectionHandler());
                    }
                }
            }
        };
        this.getCanvas().addInputEventListener((PInputEventListener)this.keyEventHandler);
        this.getCanvas().getRoot().getDefaultInputManager().setKeyboardFocus((PInputEventListener)this.keyEventHandler);
    }

    public CyNetworkView getView() {
        return this;
    }

    public CyNetwork getNetwork() {
        return (CyNetwork)this.getGraphPerspective();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String new_title) {
        this.title = new_title;
    }

    public void redrawGraph(boolean layout, boolean vizmap) {
        this.redrawGraph();
    }

    public void redrawGraph() {
        Cytoscape.getVisualMappingManager().applyAppearances();
        this.getCanvas().setInteracting(true);
        this.getCanvas().setInteracting(false);
    }

    public void toggleVisualMapperEnabled() {
        this.vizmapEnabled = !this.vizmapEnabled;
    }

    public void setVisualMapperEnabled(boolean state) {
        this.vizmapEnabled = state;
    }

    public boolean getVisualMapperEnabled() {
        return this.vizmapEnabled;
    }

    public VisualMappingManager getVizMapManager() {
        return Cytoscape.getVisualMappingManager();
    }

    public VizMapUI getVizMapUI() {
        return Cytoscape.getDesktop().getVizMapUI();
    }

    public void putClientData(String data_name, Object data) {
        this.clientData.put(data_name, data);
    }

    public Collection getClientDataNames() {
        return this.clientData.keySet();
    }

    public Object getClientData(String data_name) {
        return this.clientData.get(data_name);
    }

    protected void fireGraphViewChanged(PGraphView.ChangeEvent event) {
        this.updateStatusLabel();
        super.fireGraphViewChanged(event);
    }

    public void updateStatusLabel() {
        int nodeCount = this.getNodeViewCount();
        int edgeCount = this.getEdgeViewCount();
        int selectedNodes = this.getSelectedNodes().size();
        int selectedEdges = this.getSelectedEdges().size();
        this.statusLabel.setText("  Nodes: " + nodeCount + " (" + selectedNodes + " selected)" + " Edges: " + edgeCount + " (" + selectedEdges + " selected)");
    }

    public boolean applyVizMap(CyEdge edge) {
        return this.applyVizMap(this.getEdgeView(edge));
    }

    public boolean applyVizMap(EdgeView edge_view) {
        return this.applyVizMap(edge_view, (VisualStyle)this.getClientData("VISUAL_STYLE"));
    }

    public boolean applyVizMap(CyEdge edge, VisualStyle style) {
        return this.applyVizMap(this.getEdgeView(edge), style);
    }

    public boolean applyVizMap(EdgeView edge_view, VisualStyle style) {
        VisualStyle old_style = Cytoscape.getDesktop().setVisualStyle(style);
        Cytoscape.getVisualMappingManager().vizmapEdge(edge_view, this);
        Cytoscape.getDesktop().setVisualStyle(old_style);
        return true;
    }

    public boolean applyVizMap(CyNode node) {
        return this.applyVizMap(this.getNodeView(node));
    }

    public boolean applyVizMap(NodeView node_view) {
        return this.applyVizMap(node_view, (VisualStyle)this.getClientData("VISUAL_STYLE"));
    }

    public boolean applyVizMap(CyNode node, VisualStyle style) {
        return this.applyVizMap(this.getNodeView(node), style);
    }

    public boolean applyVizMap(NodeView node_view, VisualStyle style) {
        VisualStyle old_style = Cytoscape.getDesktop().setVisualStyle(style);
        Cytoscape.getVisualMappingManager().vizmapNode(node_view, this);
        Cytoscape.getDesktop().setVisualStyle(old_style);
        return true;
    }

    public void applyVizmapper(VisualStyle style) {
        VisualStyle old_style = Cytoscape.getDesktop().setVisualStyle(style);
        this.redrawGraph(false, true);
    }

    public void applyLayout(CyLayoutAlgorithm layout) {
        layout.doLayout();
    }

    public void applyLockedLayout(CyLayoutAlgorithm layout, CyNode[] nodes, CyEdge[] edges) {
        layout.lockNodes(this.convertToViews(nodes));
        layout.doLayout();
    }

    public void applyLayout(CyLayoutAlgorithm layout, CyNode[] nodes, CyEdge[] edges) {
        layout.lockNodes(this.getInverseViews(this.convertToViews(nodes)));
        layout.doLayout();
    }

    public void applyLockedLayout(CyLayoutAlgorithm layout, CyNodeView[] nodes, CyEdgeView[] edges) {
        layout.lockNodes(nodes);
        layout.doLayout();
    }

    public void applyLayout(CyLayoutAlgorithm layout, CyNodeView[] nodes, CyEdgeView[] edges) {
        layout.lockNodes(this.getInverseViews(nodes));
        layout.doLayout();
    }

    public void applyLockedLayout(CyLayoutAlgorithm layout, int[] nodes, int[] edges) {
        layout.lockNodes(this.convertToNodeViews(nodes));
        layout.doLayout();
    }

    public void applyLayout(CyLayoutAlgorithm layout, int[] nodes, int[] edges) {
        layout.lockNodes(this.getInverseViews(this.convertToNodeViews(nodes)));
        layout.doLayout();
    }

    public boolean setSelected(CyNode[] nodes) {
        return this.setSelected(this.convertToViews(nodes));
    }

    public boolean setSelected(NodeView[] node_views) {
        for (int i = 0; i < node_views.length; ++i) {
            node_views[i].select();
        }
        return true;
    }

    public boolean setSelected(CyEdge[] edges) {
        return this.setSelected(this.convertToViews(edges));
    }

    public boolean setSelected(EdgeView[] edge_views) {
        for (int i = 0; i < edge_views.length; ++i) {
            edge_views[i].select();
        }
        return true;
    }

    protected NodeView[] convertToViews(CyNode[] nodes) {
        NodeView[] views = new NodeView[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            views[i] = this.getNodeView(nodes[i]);
        }
        return views;
    }

    protected EdgeView[] convertToViews(CyEdge[] edges) {
        EdgeView[] views = new EdgeView[edges.length];
        for (int i = 0; i < edges.length; ++i) {
            views[i] = this.getEdgeView(edges[i]);
        }
        return views;
    }

    protected NodeView[] convertToNodeViews(int[] nodes) {
        NodeView[] views = new NodeView[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            views[i] = this.getNodeView(nodes[i]);
        }
        return views;
    }

    protected EdgeView[] convertToEdgeViews(int[] edges) {
        EdgeView[] views = new EdgeView[edges.length];
        for (int i = 0; i < edges.length; ++i) {
            views[i] = this.getEdgeView(edges[i]);
        }
        return views;
    }

    protected NodeView[] getInverseViews(NodeView[] given) {
        NodeView[] inverse = new NodeView[this.getNodeViewCount() - given.length];
        List node_views = this.getNodeViewsList();
        int count = 0;
        Iterator i = node_views.iterator();
        Arrays.sort(given);
        while (i.hasNext()) {
            NodeView view = (NodeView)i.next();
            if (Arrays.binarySearch(given, view) >= 0) continue;
            inverse[count] = view;
            ++count;
        }
        return inverse;
    }

    protected EdgeView[] getInverseViews(EdgeView[] given) {
        EdgeView[] inverse = new EdgeView[this.getEdgeViewCount() - given.length];
        List edge_views = this.getEdgeViewsList();
        int count = 0;
        Iterator i = edge_views.iterator();
        Arrays.sort(given);
        while (i.hasNext()) {
            EdgeView view = (EdgeView)i.next();
            if (Arrays.binarySearch(given, view) >= 0) continue;
            inverse[count] = view;
            ++count;
        }
        return inverse;
    }

    public void addNodeContextMenuListener(NodeContextMenuListener l) {
    }

    public void removeNodeContextMenuListener(NodeContextMenuListener l) {
    }

    public void addEdgeContextMenuListener(EdgeContextMenuListener l) {
    }

    public void removeEdgeContextMenuListener(EdgeContextMenuListener l) {
    }
}

