/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout.ui;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.LayoutTask;
import cytoscape.task.Task;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.view.CyNetworkView;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class DynamicLayoutMenu
extends JMenu
implements MenuListener {
    private CyLayoutAlgorithm layout;
    private static final String NOATTRIBUTE = "(none)";
    private Set<Node> selectedNodes;

    public DynamicLayoutMenu(CyLayoutAlgorithm layout, boolean enabled) {
        super(layout.toString());
        this.addMenuListener(this);
        this.layout = layout;
        this.selectedNodes = new HashSet<Node>();
        this.setEnabled(enabled);
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuSelected(MenuEvent e) {
        this.removeAll();
        CyNetwork network = Cytoscape.getCurrentNetwork();
        this.selectedNodes = network.getSelectedNodes();
        if (this.layout.supportsSelectedOnly() && this.selectedNodes.size() > 0) {
            this.addSelectedOnlyMenus();
        } else if (this.layout.supportsNodeAttributes() != null) {
            this.addNodeAttributeMenus(this, false);
        } else if (this.layout.supportsEdgeAttributes() != null) {
            this.addEdgeAttributeMenus(this, false);
        } else {
            List<CyNetworkView> views = Cytoscape.getSelectedNetworkViews();
            for (CyNetworkView view : views) {
                this.layout.setSelectedOnly(false);
                this.layout.setLayoutAttribute(null);
                TaskManager.executeTask((Task)new LayoutTask(this.layout, view), (JTaskConfig)LayoutTask.getDefaultTaskConfig());
            }
        }
    }

    private void addNodeAttributeMenus(JMenu parent, boolean selectedOnly) {
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        this.addAttributeMenus(parent, nodeAttributes, this.layout.supportsNodeAttributes(), selectedOnly);
    }

    private void addEdgeAttributeMenus(JMenu parent, boolean selectedOnly) {
        CyAttributes edgeAttributes = Cytoscape.getEdgeAttributes();
        this.addAttributeMenus(parent, edgeAttributes, this.layout.supportsEdgeAttributes(), selectedOnly);
    }

    private void addAttributeMenus(JMenu parent, CyAttributes attributes, byte[] typeList, boolean selectedOnly) {
        List<String> specialList = this.layout.getInitialAttributeList();
        if (specialList != null) {
            Iterator<String> iter = specialList.iterator();
            while (iter.hasNext()) {
                parent.add(new LayoutAttributeMenuItem(iter.next(), selectedOnly));
            }
        }
        String[] attList = attributes.getAttributeNames();
        for (int i = 0; i < attList.length; ++i) {
            if (!attributes.getUserVisible(attList[i])) continue;
            byte type = attributes.getType(attList[i]);
            for (int t = 0; t < typeList.length; ++t) {
                if (typeList[t] != -1 && typeList[t] != type) continue;
                parent.add(new LayoutAttributeMenuItem(attList[i], selectedOnly));
            }
        }
    }

    private void addSelectedOnlyMenus() {
        JMenuItem selNodes;
        JMenuItem allNodes;
        if (this.layout.supportsNodeAttributes() != null || this.layout.supportsEdgeAttributes() != null) {
            allNodes = new JMenu("All Nodes");
            selNodes = new JMenu("Selected Nodes Only");
            if (this.layout.supportsNodeAttributes() != null) {
                this.addNodeAttributeMenus((JMenu)allNodes, false);
                this.addNodeAttributeMenus((JMenu)selNodes, true);
            } else {
                this.addEdgeAttributeMenus((JMenu)allNodes, false);
                this.addEdgeAttributeMenus((JMenu)selNodes, true);
            }
        } else {
            allNodes = new LayoutAttributeMenuItem("All Nodes", false);
            selNodes = new LayoutAttributeMenuItem("Selected Nodes Only", true);
        }
        this.add(allNodes);
        this.add(selNodes);
    }

    protected class LayoutAttributeMenuItem
    extends JMenuItem
    implements ActionListener {
        boolean selectedOnly;

        public LayoutAttributeMenuItem(String label, boolean selectedOnly) {
            super(label);
            this.selectedOnly = false;
            this.addActionListener(this);
            this.selectedOnly = selectedOnly;
        }

        public void actionPerformed(ActionEvent e) {
            List<CyNetworkView> views = Cytoscape.getSelectedNetworkViews();
            for (CyNetworkView netView : views) {
                if (DynamicLayoutMenu.this.layout.supportsSelectedOnly()) {
                    DynamicLayoutMenu.this.layout.setSelectedOnly(this.selectedOnly);
                    if (this.selectedOnly && DynamicLayoutMenu.this.selectedNodes.size() > 0) {
                        Iterator nodeViews = netView.getNodeViewsIterator();
                        while (nodeViews.hasNext()) {
                            NodeView nv = (NodeView)nodeViews.next();
                            Node node = nv.getNode();
                            if (DynamicLayoutMenu.this.selectedNodes.contains(node)) continue;
                            DynamicLayoutMenu.this.layout.lockNode(nv);
                        }
                    }
                }
                if (DynamicLayoutMenu.this.layout.supportsNodeAttributes() != null || DynamicLayoutMenu.this.layout.supportsEdgeAttributes() != null) {
                    DynamicLayoutMenu.this.layout.setLayoutAttribute(e.getActionCommand());
                }
                TaskManager.executeTask((Task)new LayoutTask(DynamicLayoutMenu.this.layout, netView), (JTaskConfig)LayoutTask.getDefaultTaskConfig());
            }
        }
    }
}

