/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.logger.CyLogger;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.Installable;
import cytoscape.plugin.ManagerException;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginInquireAction;
import cytoscape.plugin.PluginManager;
import cytoscape.plugin.PluginManagerInquireTask;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.util.TaskManager;
import cytoscape.util.URLUtil;
import cytoscape.util.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.jdom.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallablePlugin
implements Installable {
    private static CyLogger logger = CyLogger.getLogger(InstallablePlugin.class);
    private PluginInfo infoObj;

    public InstallablePlugin(PluginInfo obj) {
        this.infoObj = obj;
    }

    @Override
    public PluginInfo getInfoObj() {
        return this.infoObj;
    }

    @Override
    public boolean install() throws IOException, ManagerException {
        return this.installToDir(null, null);
    }

    @Override
    public boolean installToDir(File dir) throws IOException, ManagerException {
        return this.installToDir(dir, null);
    }

    @Override
    public boolean installToDir(File dir, TaskMonitor taskMonitor) throws IOException, ManagerException {
        File PluginDir = dir;
        PluginDir = PluginDir == null ? this.infoObj.getPluginDirectory() : new File(PluginDir, this.getInfoObj().getName() + "-" + this.getInfoObj().getObjectVersion());
        if (!PluginDir.exists()) {
            PluginDir.mkdirs();
        }
        File Download = new File(PluginDir, this.createFileName(this.infoObj));
        if (taskMonitor != null) {
            taskMonitor.setStatus(this.infoObj.toString() + " loading...");
        }
        URLUtil.download(this.infoObj.getObjectUrl(), Download, taskMonitor);
        try {
            String ClassName = this.getPluginClass(Download.getAbsolutePath(), this.infoObj.getFileType());
            if (ClassName == null) {
                Download.delete();
                Download.getParentFile().delete();
                ManagerException E = new ManagerException(this.infoObj.getName() + " does not define the attribute 'Cytoscape-Plugin' in the jar manifest file.\n" + "This plugin cannot be auto-installed.  Please install manually or contact the plugin author.");
                throw E;
            }
            this.infoObj.setPluginClassName(ClassName);
        }
        catch (IOException ioe) {
            Download.delete();
            Download.getParentFile().delete();
            throw ioe;
        }
        switch (this.infoObj.getFileType()) {
            case JAR: {
                break;
            }
            case ZIP: {
                try {
                    List<String> UnzippedFiles = ZipUtil.unzip(Download.getAbsolutePath(), Download.getParent(), taskMonitor);
                    this.infoObj.setFileList(UnzippedFiles);
                    break;
                }
                catch (IOException ioe) {
                    Download.delete();
                    throw ioe;
                }
            }
        }
        this.infoObj.setInstallLocation(PluginDir.getAbsolutePath());
        this.infoObj.addFileName(Download.getAbsolutePath());
        return true;
    }

    @Override
    public boolean install(TaskMonitor taskMonitor) throws IOException, ManagerException {
        return this.installToDir(null, taskMonitor);
    }

    @Override
    public boolean uninstall() throws ManagerException {
        boolean Deleted = false;
        if (this.infoObj.getInstallLocation() != null && this.infoObj.getInstallLocation().length() > 0) {
            File Installed = new File(this.infoObj.getInstallLocation());
            Deleted = PluginManager.recursiveDeleteFiles(Installed);
        } else {
            for (String f : this.infoObj.getFileList()) {
                Deleted = new File(f).delete();
            }
        }
        return Deleted;
    }

    @Override
    public List<DownloadableInfo> findUpdates() throws IOException, JDOMException {
        final ArrayList<DownloadableInfo> UpdatablePlugins = new ArrayList<DownloadableInfo>();
        final HashSet<PluginInfo> Seen = new HashSet<PluginInfo>();
        Seen.add(this.infoObj);
        if (this.infoObj.getDownloadableURL() == null || this.infoObj.getDownloadableURL().length() <= 0) {
            return UpdatablePlugins;
        }
        final PluginInfo InfoToUpdate = this.infoObj;
        final ArrayList Exceptions = new ArrayList();
        PluginManagerInquireTask task = new PluginManagerInquireTask(this.infoObj.getDownloadableURL(), new PluginInquireAction(){

            @Override
            public String getProgressBarMessage() {
                return "Connecting to " + InfoToUpdate.getDownloadableURL() + " to search for updates...";
            }

            @Override
            public void inquireAction(List<DownloadableInfo> Results) {
                if (this.isExceptionThrown()) {
                    Exceptions.add(0, this.getIOException());
                    Exceptions.add(1, this.getJDOMException());
                }
                for (DownloadableInfo NewInfo : Results) {
                    if (!InfoToUpdate.getType().equals((Object)NewInfo.getType())) continue;
                    PluginInfo New = (PluginInfo)NewInfo;
                    boolean newer = InfoToUpdate.isNewerObjectVersion(New);
                    if (!New.getID().equals(InfoToUpdate.getID()) && !New.getPluginClassName().equals(InfoToUpdate.getPluginClassName()) || !newer) continue;
                    if (!Seen.contains(New) && newer) {
                        UpdatablePlugins.add(New);
                        continue;
                    }
                    Seen.add(New);
                }
            }
        });
        TaskManager.executeTask((Task)task, null);
        if (Exceptions.size() > 0) {
            if (Exceptions.get(0) != null) {
                throw (IOException)Exceptions.get(0);
            }
            if (Exceptions.size() > 1 && Exceptions.get(1) != null) {
                throw (JDOMException)((Object)Exceptions.get(1));
            }
        }
        return UpdatablePlugins;
    }

    @Override
    public boolean update(DownloadableInfo newObj) throws IOException, ManagerException {
        return this.update(newObj, null);
    }

    @Override
    public boolean update(DownloadableInfo newInfoObj, TaskMonitor taskMonitor) throws IOException, ManagerException {
        PluginInfo newObj = (PluginInfo)newInfoObj;
        if (this.infoObj.getDownloadableURL() == null) {
            throw new ManagerException(this.infoObj.getName() + " does not have a project url.\nCannot auto-update this plugin.");
        }
        if (!this.infoObj.getID().equals(newObj.getID()) && !this.infoObj.getPluginClassName().equals(newObj.getPluginClassName()) || !this.infoObj.getDownloadableURL().equals(newObj.getDownloadableURL()) || !this.infoObj.isNewerObjectVersion(newObj)) {
            throw new ManagerException("Failed to update '" + this.infoObj.getName() + "', the new plugin did not match what is currently installed\n" + "or the version was not newer than what is currently installed.");
        }
        this.infoObj = newObj;
        this.install(taskMonitor);
        return true;
    }

    private String createFileName(PluginInfo Obj) {
        return Obj.getName() + "." + Obj.getFileType().toString();
    }

    private String getPluginClass(String FileName, PluginInfo.FileType Type2) throws IOException {
        String PluginClassName = null;
        switch (Type2) {
            case JAR: {
                JarFile Jar = new JarFile(FileName);
                PluginClassName = this.getManifestAttribute(Jar.getManifest());
                Jar.close();
                break;
            }
            case ZIP: {
                List<ZipEntry> Entries = ZipUtil.getAllFiles(FileName, "\\w+\\.jar");
                if (Entries.size() <= 0) {
                    String[] FilePath = FileName.split("/");
                    FileName = FilePath[FilePath.length - 1];
                    throw new IOException(FileName + " does not contain any jar files or is not a zip file.");
                }
                for (ZipEntry Entry2 : Entries) {
                    String EntryName = Entry2.getName();
                    InputStream is = ZipUtil.readFile(FileName, EntryName);
                    JarInputStream jis = new JarInputStream(is);
                    PluginClassName = this.getManifestAttribute(jis.getManifest());
                    jis.close();
                    is.close();
                }
                break;
            }
        }
        return PluginClassName;
    }

    private String getManifestAttribute(Manifest m) {
        String Value2 = null;
        if (m != null) {
            Value2 = m.getMainAttributes().getValue("Cytoscape-Plugin");
        }
        return Value2;
    }
}

