/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.logger.CyLogger;
import cytoscape.plugin.Category;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.DownloadableType;
import cytoscape.plugin.ManagerUtil;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginXml;
import cytoscape.plugin.ThemeInfo;
import cytoscape.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginFileReader {
    private static CyLogger logger = CyLogger.getLogger(PluginFileReader.class);
    private Document document;
    private String downloadUrl;
    private static String nameTag = PluginXml.NAME.getTag();
    private static String descTag = PluginXml.DESCRIPTION.getTag();
    private static String classTag = PluginXml.CLASS_NAME.getTag();
    private static String pluginVersTag = PluginXml.PLUGIN_VERSION.getTag();
    private static String cytoVersTag = "cytoscapeVersion";
    private static String urlTag = PluginXml.URL.getTag();
    private static String projUrlTag = PluginXml.PROJECT_URL.getTag();
    private static String downloadUrlTag = PluginXml.DOWNLOAD_URL.getTag();
    private static String categoryTag = PluginXml.CATEGORY.getTag();
    private static String fileListTag = PluginXml.FILE_LIST.getTag();
    private static String fileTag = PluginXml.FILE.getTag();
    private static String pluginListTag = PluginXml.PLUGIN_LIST.getTag();
    private static String pluginTag = PluginXml.PLUGIN.getTag();
    private static String authorListTag = PluginXml.AUTHOR_LIST.getTag();
    private static String authorTag = PluginXml.AUTHOR.getTag();
    private static String instTag = PluginXml.INSTITUTION.getTag();
    private static String fileType = PluginXml.FILE_TYPE.getTag();
    private static String uniqueID = PluginXml.UNIQUE_ID.getTag();
    private static String licenseTag = PluginXml.LICENSE.getTag();
    private static String licenseText = PluginXml.LICENSE_TEXT.getTag();
    private static String installLocTag = PluginXml.INSTALL_LOCATION.getTag();

    protected PluginFileReader(String Url) throws IOException, JDOMException {
        this.downloadUrl = Url;
        InputStream is = URLUtil.getInputStream(new URL(this.downloadUrl));
        SAXBuilder Builder2 = new SAXBuilder(false);
        this.document = Builder2.build(is);
    }

    protected String getProjectName() {
        return this.document.getRootElement().getChild(nameTag).getTextTrim();
    }

    protected String getProjectDescription() {
        return this.document.getRootElement().getChild(descTag).getTextTrim();
    }

    protected String getProjectUrl() {
        return this.document.getRootElement().getChild(urlTag).getTextTrim();
    }

    protected List<DownloadableInfo> getDownloadables() {
        ArrayList<DownloadableInfo> downloadableObjs = new ArrayList<DownloadableInfo>();
        downloadableObjs.addAll(this.getPlugins());
        downloadableObjs.addAll(this.getThemes());
        return downloadableObjs;
    }

    protected List<ThemeInfo> getThemes() {
        ArrayList<ThemeInfo> Themes = new ArrayList<ThemeInfo>();
        Element ThemeList = this.document.getRootElement().getChild(PluginXml.THEME_LIST.getTag());
        if (ThemeList != null) {
            logger.debug("Theme list from xml: " + ThemeList.getChildren().size());
            for (Element CurrentTheme : ThemeList.getChildren(PluginXml.THEME.getTag())) {
                ThemeInfo Info = this.createThemeObject(CurrentTheme);
                if (Info == null) continue;
                Themes.add(Info);
            }
        }
        return Themes;
    }

    protected List<PluginInfo> getPlugins() {
        ArrayList<PluginInfo> Plugins2 = new ArrayList<PluginInfo>();
        Element PluginList = this.document.getRootElement().getChild(pluginListTag);
        if (PluginList != null) {
            for (Element CurrentPlugin : PluginList.getChildren(pluginTag)) {
                PluginInfo Info = this.createPluginObject(CurrentPlugin);
                if (Info == null) continue;
                Plugins2.add(Info);
            }
        }
        return Plugins2;
    }

    protected ThemeInfo createThemeObject(Element CurrentTheme) {
        ThemeInfo Info = (ThemeInfo)this.createBasicInfoObject(CurrentTheme, DownloadableType.THEME);
        logger.debug("Creating Theme: " + Info.getName() + " " + Info.getID());
        if (Info != null) {
            Map<String, List<PluginInfo>> Plugins2 = ManagerUtil.sortByID(this.getPlugins());
            for (Element ThemePlugin : CurrentTheme.getChild(PluginXml.PLUGIN_LIST.getTag()).getChildren(PluginXml.PLUGIN.getTag())) {
                if (ThemePlugin.getChildren().size() == 2) {
                    logger.debug("Theme plugins defined shorthand");
                    for (PluginInfo pluginInfo : Plugins2.get(ThemePlugin.getChildTextTrim(PluginXml.UNIQUE_ID.getTag()))) {
                        String version = Double.valueOf(ThemePlugin.getChildTextTrim(PluginXml.PLUGIN_VERSION.getTag())).toString();
                        if (!pluginInfo.getObjectVersion().equals(version)) continue;
                        pluginInfo.setParent(Info);
                        Info.addPlugin(pluginInfo);
                    }
                    continue;
                }
                PluginInfo pluginInfo = this.createPluginObject(ThemePlugin);
                pluginInfo.setParent(Info);
                Info.addPlugin(pluginInfo);
            }
        }
        return Info;
    }

    private DownloadableInfo createBasicInfoObject(Element E, DownloadableType Type2) {
        DownloadableInfo Info = null;
        String Id = E.getChildTextTrim(uniqueID);
        switch (Type2) {
            case PLUGIN: {
                Info = new PluginInfo(Id);
                Info.setObjectUrl(E.getChildTextTrim(urlTag));
                break;
            }
            case THEME: {
                Info = new ThemeInfo(Id);
            }
        }
        Info.setName(E.getChildTextTrim(nameTag));
        Info.setDescription(E.getChildTextTrim(descTag));
        Info.setDownloadableURL(this.downloadUrl);
        if (Info.getCategory().equals(Category.NONE.getCategoryText())) {
            if (E.getChild(categoryTag) != null) {
                Info.setCategory(E.getChildTextTrim(categoryTag));
            } else {
                Info.setCategory(Category.NONE);
            }
        }
        Info = this.addVersion(Info, E, Type2);
        for (Element Version2 : E.getChild(PluginXml.CYTOSCAPE_VERSIONS.getTag()).getChildren(PluginXml.VERSION.getTag())) {
            Info.addCytoscapeVersion(Version2.getTextTrim());
        }
        return Info;
    }

    protected PluginInfo createPluginObject(Element CurrentPlugin) {
        PluginInfo Info = (PluginInfo)this.createBasicInfoObject(CurrentPlugin, DownloadableType.PLUGIN);
        if (Info != null) {
            Info.setProjectUrl(CurrentPlugin.getChildTextTrim(projUrlTag));
            Info.setInstallLocation(CurrentPlugin.getChildTextTrim(installLocTag));
            PluginInfo.FileType Type2 = this.getType(CurrentPlugin);
            if (Type2 == null) {
                logger.warn("Unknown plugin file type '" + (Object)((Object)Type2) + " skipping plugin " + Info.getName());
                return null;
            }
            Info.setFiletype(Type2);
            Info = this.addAuthors(Info, CurrentPlugin);
            Info = PluginFileReader.addLicense(Info, CurrentPlugin);
        }
        return Info;
    }

    protected DownloadableInfo addVersion(DownloadableInfo obj, Element e, DownloadableType Type2) {
        String Version2 = null;
        switch (Type2) {
            case PLUGIN: {
                Version2 = e.getChildTextTrim(pluginVersTag);
                break;
            }
            case THEME: {
                Version2 = e.getChildTextTrim(PluginXml.THEME_VERSION.getTag());
            }
        }
        try {
            obj.setObjectVersion(Double.valueOf(Version2));
            return obj;
        }
        catch (NumberFormatException ie) {
            logger.warn("Version number format error: " + Version2);
            return null;
        }
    }

    protected static PluginInfo addLicense(PluginInfo obj, Element Plugin2) {
        Element License2 = Plugin2.getChild(licenseTag);
        if (License2 != null) {
            boolean RequireAlways = false;
            if (License2.getChild("license_required") != null) {
                RequireAlways = true;
            }
            if (License2.getChild(licenseText) != null) {
                obj.setLicense(License2.getChildTextTrim(licenseText), RequireAlways);
            } else if (License2.getChild(urlTag) != null) {
                try {
                    String LicenseText = URLUtil.download(new URL(License2.getChildTextTrim(urlTag)));
                    obj.setLicense(LicenseText, RequireAlways);
                }
                catch (Exception E) {
                    logger.warn("Unable to add license: " + E.toString(), E);
                }
            }
        }
        return obj;
    }

    private PluginInfo addAuthors(PluginInfo obj, Element Plugin2) {
        if (Plugin2.getChild(authorListTag) != null) {
            List Authors = Plugin2.getChild(authorListTag).getChildren(authorTag);
            for (Element CurrentAuthor : Authors) {
                obj.addAuthor(CurrentAuthor.getChildTextTrim(nameTag), CurrentAuthor.getChildTextTrim(instTag));
            }
        }
        return obj;
    }

    private PluginInfo.FileType getType(Element Plugin2) {
        PluginInfo.FileType Type2 = null;
        String GivenType = Plugin2.getChild(fileType).getTextTrim();
        if (GivenType.equalsIgnoreCase(PluginInfo.FileType.JAR.toString())) {
            Type2 = PluginInfo.FileType.JAR;
        } else if (GivenType.equalsIgnoreCase(PluginInfo.FileType.ZIP.toString())) {
            Type2 = PluginInfo.FileType.ZIP;
        }
        return Type2;
    }
}

