/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.CytoscapeVersion;
import cytoscape.plugin.Category;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.DownloadableType;
import cytoscape.plugin.ManagerException;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginManager;
import cytoscape.plugin.PluginStatus;
import cytoscape.plugin.PluginTestXML;
import cytoscape.plugin.PluginTracker;
import cytoscape.plugin.ThemeInfo;
import cytoscape.plugin.TrackerException;
import cytoscape.plugin.WebstartException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.jdom.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManagerTest
extends TestCase {
    private PluginManager mgr;
    private PluginTracker tracker;
    private String testUrl;
    private File transformedXML;

    private static void print(String s) {
        System.out.println(s);
    }

    private String getFileUrl() {
        String FS = "/";
        String UserDir = System.getProperty("user.dir");
        if (System.getProperty("os.name").contains("Windows")) {
            UserDir = UserDir.replaceFirst("\\w:", "");
            UserDir = UserDir.replaceAll("\\\\", FS);
        }
        UserDir = UserDir.replaceFirst("/", "");
        return "file:///" + UserDir + FS + "testData" + FS + "plugins" + FS;
    }

    private String cleanFileUrl(String url) {
        if (System.getProperty("os.name").contains("Windows")) {
            url = url.replaceFirst("\\w:", "");
        }
        return "file://" + url;
    }

    protected void setUp() throws Exception {
        this.transformedXML = PluginTestXML.transformXML("test_plugin.xml", this.getFileUrl());
        this.testUrl = this.cleanFileUrl(this.transformedXML.getAbsolutePath());
        PluginManager.setPluginManageDirectory(System.getProperty("java.io.tmpdir"));
        this.mgr = PluginManager.getPluginManager();
    }

    protected void tearDown() {
        this.mgr.resetManager();
        this.mgr.getPluginManageDirectory().delete();
        this.mgr.getPluginManageDirectory().getParentFile().delete();
        this.transformedXML.delete();
        System.setProperty("javawebstart.version", "");
    }

    public void testGetPluginManager() {
        System.out.println("testGetPluginManager");
        PluginManagerTest.assertNotNull((Object)this.mgr);
        PluginManagerTest.assertNotNull((Object)PluginManager.getPluginManager(this.tracker));
        PluginManagerTest.assertEquals((Object)this.mgr, (Object)PluginManager.getPluginManager(this.tracker));
    }

    public void testGetWebstartPluginManager() throws IOException {
        this.mgr.resetManager();
        System.setProperty("javawebstart.version", "booya");
        PluginManager.setPluginManageDirectory(System.getProperty("java.io.tmpdir"));
        this.mgr = PluginManager.getPluginManager();
        PluginManagerTest.assertNotNull((Object)this.mgr);
        PluginManagerTest.assertTrue((boolean)PluginManager.usingWebstartManager());
        File TempTrackingFile = this.mgr.pluginTracker.getTrackerFile();
        PluginManagerTest.assertNotNull((Object)TempTrackingFile);
        PluginManagerTest.assertTrue((boolean)TempTrackingFile.exists());
        PluginManagerTest.assertTrue((boolean)TempTrackingFile.canRead());
        this.mgr.resetManager();
    }

    public void testDownloadPluginWebstart() throws IOException, JDOMException, ManagerException {
        this.mgr.resetManager();
        System.setProperty("javawebstart.version", "booya");
        PluginManager.setPluginManageDirectory(System.getProperty("java.io.tmpdir"));
        PluginManager mgr = PluginManager.getPluginManager();
        PluginManagerTest.assertNotNull((Object)mgr);
        PluginManagerTest.assertTrue((boolean)PluginManager.usingWebstartManager());
        PluginInfo TestObj = (PluginInfo)this.getSpecificObj(mgr.inquire(this.testUrl), "goodJarPlugin123", "1.0");
        DownloadableInfo DLTestObj = mgr.download(TestObj);
        PluginManagerTest.assertNotNull((Object)DLTestObj);
        PluginInfo testObjPlugin = (PluginInfo)DLTestObj;
        for (String f : testObjPlugin.getFileList()) {
            PluginManagerTest.assertTrue((boolean)f.startsWith(mgr.getPluginManageDirectory().getAbsolutePath()));
        }
        try {
            mgr.delete(DLTestObj);
        }
        catch (WebstartException wse) {
            PluginManagerTest.assertNotNull((Object)wse);
        }
        mgr.resetManager();
    }

    public void testGetPlugins() {
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
    }

    public void testInquireString() throws IOException, JDOMException {
        String Url = "http://google.com/x.xml";
        try {
            this.mgr.inquire(Url);
        }
        catch (IOException e) {
            PluginManagerTest.assertNotNull((Object)e);
        }
        Url = this.testUrl;
        PluginManagerTest.assertNotNull(this.mgr.inquire(Url));
        PluginManagerTest.assertEquals((int)this.mgr.inquire(Url).size(), (int)13);
    }

    public void testInquirePartialXML() {
        String Url = this.getFileUrl() + "partial_plugin_file.xml";
        System.out.println(Url);
        try {
            this.mgr.inquire(Url);
        }
        catch (IOException e) {
            PluginManagerTest.fail((String)"Should have gotten a JDOMParseException");
            e.printStackTrace();
        }
        catch (JDOMException e) {
            PluginManagerTest.assertNotNull((Object)((Object)e));
            e.printStackTrace();
        }
    }

    public void testRegister() throws Exception {
    }

    public void testInstallTheme() throws IOException, JDOMException, ManagerException, WebstartException {
        ThemeInfo TestObj = (ThemeInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "goodThemeTest123", "0.5");
        DownloadableInfo DownloadedObj = this.mgr.download(TestObj);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        this.mgr.install(DownloadedObj);
        List<DownloadableInfo> Current = this.mgr.getDownloadables(PluginStatus.CURRENT);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        PluginManagerTest.assertEquals((int)Current.size(), (int)1);
        PluginManagerTest.assertEquals((Object)((Object)Current.get(0).getType()), (Object)((Object)DownloadableType.THEME));
        PluginManagerTest.assertEquals((int)((ThemeInfo)DownloadedObj).getPlugins().size(), (int)2);
        ThemeInfo CurrentRecorded = (ThemeInfo)Current.get(0);
        PluginManagerTest.assertEquals((int)CurrentRecorded.getPlugins().size(), (int)((ThemeInfo)DownloadedObj).getPlugins().size());
        this.mgr.delete(DownloadedObj);
        this.mgr.delete();
    }

    public void testInstallPlugin() throws IOException, JDOMException, ManagerException, WebstartException {
        PluginInfo TestObj = (PluginInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "goodJarPlugin123", "1.0");
        DownloadableInfo DownloadedObj = this.mgr.download(TestObj, null);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        this.mgr.install(DownloadedObj);
        List<DownloadableInfo> Current = this.mgr.getDownloadables(PluginStatus.CURRENT);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        PluginManagerTest.assertEquals((int)Current.size(), (int)1);
        PluginInfo APlugin = (PluginInfo)Current.get(0);
        PluginManagerTest.assertEquals((int)APlugin.getFileList().size(), (int)1);
        for (String f : APlugin.getFileList()) {
            PluginManagerTest.assertTrue((boolean)new File(f).exists());
        }
        this.mgr.delete(DownloadedObj);
        this.mgr.delete();
        PluginInfo plugin = (PluginInfo)DownloadedObj;
        for (String f : plugin.getFileList()) {
            PluginManagerTest.assertFalse((boolean)new File(f).exists());
        }
    }

    public void testInstallPluginZip() throws Exception {
        PluginInfo TestObj = (PluginInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "goodZIPPlugin777", "0.45");
        DownloadableInfo DownloadedObj = this.mgr.download(TestObj, null);
        PluginInfo plugin = (PluginInfo)DownloadedObj;
        for (String f : plugin.getFileList()) {
            PluginManagerTest.assertTrue((boolean)new File(f).exists());
        }
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        this.mgr.install(this.mgr.getDownloadables(PluginStatus.INSTALL).get(0));
        String ParentDir = new File(TestObj.getFileList().get(0)).getParent();
        List<String> TestFileList = TestObj.getFileList();
        for (String f : TestFileList) {
            PluginManagerTest.assertTrue((boolean)f.startsWith(ParentDir));
        }
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        this.mgr.delete(DownloadedObj);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)1);
        this.mgr.delete();
        for (String f : TestFileList) {
            PluginManagerTest.assertFalse((boolean)new File(f).exists());
        }
    }

    public void testInstallIncorrectFileType() throws ManagerException, JDOMException {
        PluginInfo TestObj = null;
        try {
            TestObj = (PluginInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "badFileType123", "1.0");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            PluginManagerTest.fail();
        }
        TestObj.setFiletype(PluginInfo.FileType.ZIP);
        try {
            this.mgr.download(TestObj, null);
            PluginManagerTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testDeletePluginInfo() throws IOException, JDOMException, ManagerException, WebstartException {
        List<DownloadableInfo> Downloadables = this.mgr.inquire(this.testUrl);
        PluginInfo TestObj = (PluginInfo)Downloadables.get(0);
        DownloadableInfo Downloaded = this.mgr.download(TestObj, null);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        this.mgr.install(Downloaded);
        List<DownloadableInfo> Current = this.mgr.getDownloadables(PluginStatus.CURRENT);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        PluginManagerTest.assertEquals((int)Current.size(), (int)1);
        PluginInfo APlugin = (PluginInfo)Current.get(0);
        PluginManagerTest.assertEquals((int)APlugin.getFileList().size(), (int)1);
        File InstalledPlugin = new File(APlugin.getFileList().get(0));
        PluginManagerTest.assertTrue((boolean)InstalledPlugin.exists());
        this.mgr.delete(Current.get(0));
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)1);
        this.mgr.delete();
        PluginManagerTest.assertFalse((boolean)InstalledPlugin.exists());
    }

    public void testDeletePlugin() throws IOException, JDOMException, ManagerException, WebstartException {
        List<DownloadableInfo> Downloadables = this.mgr.inquire(this.testUrl);
        PluginInfo TestObj = (PluginInfo)Downloadables.get(0);
        DownloadableInfo Downloaded = this.mgr.download(TestObj, null);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        this.mgr.install(Downloaded);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        this.mgr.delete(this.mgr.getDownloadables(PluginStatus.CURRENT).get(0));
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)1);
        List<DownloadableInfo> DeleteList = this.mgr.getDownloadables(PluginStatus.DELETE);
        this.mgr.delete();
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        PluginInfo Plugin2 = (PluginInfo)DeleteList.get(0);
        for (String FileName : Plugin2.getFileList()) {
            PluginManagerTest.assertFalse((boolean)new File(FileName).exists());
        }
    }

    public void testDeleteTheme() throws IOException, JDOMException, ManagerException, WebstartException {
        ThemeInfo TestObj = (ThemeInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "goodThemeTest123", "0.5");
        DownloadableInfo Downloaded = this.mgr.download(TestObj);
        TestObj = (ThemeInfo)Downloaded;
        PluginManagerTest.assertEquals((int)TestObj.getPlugins().size(), (int)2);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        this.mgr.install(Downloaded);
        for (String x : this.mgr.getPluginManageDirectory().list()) {
            System.out.println("**" + x);
        }
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        this.mgr.delete(this.mgr.getDownloadables(PluginStatus.CURRENT).get(0));
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)1);
        List<DownloadableInfo> DeleteList = this.mgr.getDownloadables(PluginStatus.DELETE);
        this.mgr.delete();
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
    }

    public void testFindThemeUpdates() throws IOException, JDOMException, ManagerException, WebstartException {
        ThemeInfo TestObj = (ThemeInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "goodThemeTest123", "0.5");
        DownloadableInfo Downloaded = this.mgr.download(TestObj);
        PluginManagerTest.assertNotNull((Object)Downloaded);
        this.mgr.install(Downloaded);
        TestObj = (ThemeInfo)Downloaded;
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        List<DownloadableInfo> Updatable = this.mgr.findUpdates(this.mgr.getDownloadables(PluginStatus.CURRENT).get(0));
        PluginManagerTest.assertEquals((int)Updatable.size(), (int)1);
        this.mgr.delete(Downloaded);
        this.mgr.delete();
    }

    public void testFindPluginUpdates() throws IOException, JDOMException, ManagerException, WebstartException {
        PluginInfo GoodJar = (PluginInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "goodJarPlugin123", "1.0");
        DownloadableInfo Downloaded = this.mgr.download(GoodJar, null);
        PluginManagerTest.assertNotNull((Object)Downloaded);
        this.mgr.install(Downloaded);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        List<DownloadableInfo> Updatable = this.mgr.findUpdates(this.mgr.getDownloadables(PluginStatus.CURRENT).get(0));
        PluginManagerTest.assertEquals((int)Updatable.size(), (int)1);
        this.mgr.delete(Downloaded);
        this.mgr.delete();
    }

    public void testUpdateTheme() throws Exception {
        ThemeInfo TestObj = (ThemeInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "goodThemeTest123", "0.5");
        DownloadableInfo Downloaded = this.mgr.download(TestObj);
        PluginManagerTest.assertNotNull((Object)Downloaded);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        this.mgr.install(Downloaded);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        List<DownloadableInfo> Updatable = this.mgr.findUpdates(this.mgr.getDownloadables(PluginStatus.CURRENT).get(0));
        PluginManagerTest.assertEquals((int)Updatable.size(), (int)1);
        ThemeInfo TestUpdate = (ThemeInfo)Updatable.get(0);
        this.mgr.update(this.mgr.getDownloadables(PluginStatus.CURRENT).get(0), TestUpdate);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        this.mgr.delete();
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        this.mgr.install(TestUpdate);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        this.mgr.delete(this.mgr.getDownloadables(PluginStatus.CURRENT).get(0));
        this.mgr.delete();
    }

    public void testUpdatePlugin() throws Exception {
        PluginInfo GoodJar = (PluginInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "goodJarPlugin123", "1.0");
        PluginManagerTest.assertNotNull((Object)this.mgr.download(GoodJar, null));
        this.mgr.install(GoodJar);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        List<DownloadableInfo> Updatable = this.mgr.findUpdates(this.mgr.getDownloadables(PluginStatus.CURRENT).get(0));
        PluginManagerTest.assertEquals((int)Updatable.size(), (int)1);
        PluginInfo New = (PluginInfo)Updatable.get(0);
        PluginInfo Current = (PluginInfo)this.mgr.getDownloadables(PluginStatus.CURRENT).get(0);
        this.mgr.update(Current, New);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        this.mgr.delete();
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        this.mgr.install(New);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        PluginInfo Installed = (PluginInfo)this.mgr.getDownloadables(PluginStatus.CURRENT).get(0);
        for (String f : Installed.getFileList()) {
            PluginManagerTest.print("Installed file: " + f);
            PluginManagerTest.assertTrue((boolean)new File(f).exists());
        }
        this.mgr.delete(this.mgr.getDownloadables(PluginStatus.CURRENT).get(0));
        this.mgr.delete();
    }

    public void testDownloadGoodTheme() throws IOException, JDOMException, ManagerException, WebstartException {
        ThemeInfo GoodTheme = (ThemeInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "goodThemeTest123", "0.5");
        PluginManagerTest.assertEquals((String)GoodTheme.getCategory(), (String)Category.THEME.getCategoryText());
        DownloadableInfo GoodDL = this.mgr.download(GoodTheme);
        PluginManagerTest.assertNotNull((Object)GoodDL);
        GoodTheme = (ThemeInfo)GoodDL;
        PluginManagerTest.assertEquals((int)GoodTheme.getPlugins().size(), (int)2);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        PluginManagerTest.assertEquals((String)this.mgr.getDownloadables(PluginStatus.INSTALL).get(0).getObjectVersion(), (String)GoodDL.getObjectVersion());
        this.mgr.delete(GoodDL);
        this.mgr.delete();
    }

    public void testDownloadGoodPlugin() throws IOException, JDOMException, ManagerException, WebstartException {
        PluginInfo GoodJar = (PluginInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "goodJarPlugin123", "1.0");
        DownloadableInfo GoodDL = this.mgr.download(GoodJar);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
        DownloadableInfo CurrentInstall = this.mgr.getDownloadables(PluginStatus.INSTALL).get(0);
        PluginInfo CurrentPlugin = (PluginInfo)CurrentInstall;
        PluginManagerTest.assertNotNull((Object)CurrentPlugin.getLicenseText());
        PluginManagerTest.assertEquals((int)CurrentPlugin.getFileList().size(), (int)1);
        this.mgr.delete(GoodDL);
        this.mgr.delete();
    }

    public void testDownloadBadPlugin() throws IOException, JDOMException, WebstartException {
        PluginInfo BadJar = (PluginInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "badJarPlugin123", "0.3");
        try {
            this.mgr.download(BadJar, null);
        }
        catch (ManagerException E) {
            PluginManagerTest.assertNotNull((Object)E);
            PluginManagerTest.assertTrue((boolean)E.getMessage().contains("Cytoscape-Plugin"));
        }
    }

    public void testDuplicates() throws Exception {
        ThemeInfo GoodTheme = (ThemeInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "goodThemeTest123", "0.5");
        DownloadableInfo ThemeDL = this.mgr.download(GoodTheme);
        PluginManagerTest.assertNotNull((Object)ThemeDL);
        GoodTheme = (ThemeInfo)ThemeDL;
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        PluginInfo GoodPlugin = (PluginInfo)this.getSpecificObj(this.mgr.inquire(this.testUrl), "goodJarPlugin123", "2.1");
        try {
            DownloadableInfo PluginDL = this.mgr.download(GoodPlugin);
        }
        catch (ManagerException me) {
            // empty catch block
        }
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)1);
        this.mgr.install();
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.INSTALL).size(), (int)0);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.DELETE).size(), (int)0);
    }

    public void testMinorCorruptedTrackerFile() {
        this.mgr.resetManager();
        PluginManager.setPluginManageDirectory(System.getProperty("java.io.tmpdir"));
        File file = new File("testData/plugins/track_plugins_c1.xml");
        file = this.copyFileToTempDir(file);
        this.mgr = PluginManager.getPluginManager();
        PluginManagerTest.assertEquals((String)this.mgr.pluginTracker.getTrackerFile().getAbsolutePath(), (String)file.getAbsolutePath());
        PluginManagerTest.assertTrue((this.mgr.getDownloadables(PluginStatus.CURRENT).size() > 0 ? 1 : 0) != 0);
        PluginManagerTest.assertEquals((int)this.mgr.pluginTracker.getTotalCorruptedElements(), (int)1);
        PluginManagerTest.assertEquals((int)this.mgr.getLoadingErrors().size(), (int)1);
        PluginManagerTest.assertTrue((boolean)this.mgr.getLoadingErrors().get(0).getClass().equals(TrackerException.class));
        file.delete();
    }

    public void testMajorCorruptedTrackerFile() {
        this.mgr.resetManager();
        PluginManager.setPluginManageDirectory(System.getProperty("java.io.tmpdir"));
        File file = new File("testData/plugins/track_plugins_c2.xml");
        file = this.copyFileToTempDir(file);
        this.mgr = PluginManager.getPluginManager();
        PluginManagerTest.assertNotNull((Object)this.mgr);
        PluginManagerTest.assertEquals((String)this.mgr.pluginTracker.getTrackerFile().getAbsolutePath(), (String)file.getAbsolutePath());
        PluginManagerTest.assertEquals((int)this.mgr.getDownloadables(PluginStatus.CURRENT).size(), (int)0);
        List<Throwable> LoadingErrors = this.mgr.getLoadingErrors();
        PluginManagerTest.assertEquals((int)LoadingErrors.size(), (int)1);
        PluginManagerTest.assertTrue((boolean)LoadingErrors.get(0).getClass().equals(TrackerException.class));
        this.mgr.clearErrorList();
        PluginManagerTest.assertEquals((int)this.mgr.getLoadingErrors().size(), (int)0);
        file.delete();
    }

    private File copyFileToTempDir(File fileToCopy) {
        File tempDir = new File(System.getProperty("java.io.tmpdir") + File.separator + new CytoscapeVersion().getMajorVersion());
        File tempFile = new File(tempDir, "track_plugins.xml");
        PluginManagerTest.assertTrue((boolean)fileToCopy.exists());
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileToCopy));
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
                writer.flush();
            }
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempFile;
    }

    private ThemeInfo setUpCorrectUrls(ThemeInfo info) {
        for (PluginInfo plugin : info.getPlugins()) {
            plugin.setObjectUrl(this.getFileUrl() + plugin.getObjectUrl());
        }
        return info;
    }

    private DownloadableInfo getSpecificObj(List<DownloadableInfo> AllInfo, String Id, String Version2) {
        for (DownloadableInfo Current : AllInfo) {
            if (!Current.getID().equals(Id) || !Current.getObjectVersion().equals(Version2)) continue;
            return Current;
        }
        return null;
    }

    private class MyPlugin
    extends CytoscapePlugin {
        public MyPlugin() {
            System.out.println("MyPlugin instantiated");
        }
    }
}

