/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view.cytopanels;

import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import cytoscape.view.cytopanels.BiModalJSplitPane;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelContainer;
import cytoscape.view.cytopanels.CytoPanelListener;
import cytoscape.view.cytopanels.CytoPanelName;
import cytoscape.view.cytopanels.CytoPanelState;
import cytoscape.view.cytopanels.CytoPanelUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CytoPanelImp
extends JPanel
implements CytoPanel,
ChangeListener {
    private JTabbedPane tabbedPane;
    private CytoPanelState cytoPanelState;
    private int compassDirection;
    private ArrayList cytoPanelListenerList;
    private final int NOTIFICATION_STATE_CHANGE = 0;
    private final int NOTIFICATION_COMPONENT_SELECTED = 1;
    private final int NOTIFICATION_COMPONENT_ADDED = 2;
    private final int NOTIFICATION_COMPONENT_REMOVED = 3;
    private CytoPanelContainer cytoPanelContainer;
    private JDialog externalFrame;
    private ImageIcon floatIcon;
    private ImageIcon dockIcon;
    private JLabel floatLabel;
    private JButton floatButton;
    private final int FLOAT_PANEL_SCALE_FACTOR = 2;
    private Color FLOAT_PANEL_COLOR = new Color(204, 204, 204);
    private static final String TOOL_TIP_FLOAT = "Float Window";
    private static final String TOOL_TIP_DOCK = "Dock Window";
    private static final String RESOURCE_DIR = "/cytoscape/images/";
    private static final String FLOAT_GIF = "float.gif";
    private static final String DOCK_GIF = "pin.gif";
    private static final String FILE_SEPARATOR = "/";

    public CytoPanelImp(int compassDirection, int tabPlacement, CytoPanelState cytoPanelState) {
        this.tabbedPane = new JTabbedPane(tabPlacement);
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.addChangeListener(this);
        if (compassDirection != 1 && compassDirection != 3 && compassDirection != 7 && compassDirection != 6 && compassDirection != 5) {
            throw new IllegalArgumentException("Illegal Argument:  " + compassDirection + ".  Must be one of:  SwingConstants.{NORTH,SOUTH,EAST,WEST,SOUTH_WEST}.");
        }
        this.compassDirection = compassDirection;
        this.cytoPanelListenerList = new ArrayList();
        this.initIcons();
        this.constructPanel();
        this.setState(cytoPanelState);
    }

    public void setCytoPanelContainer(CytoPanelContainer cytoPanelContainer) {
        this.cytoPanelContainer = cytoPanelContainer;
    }

    public String getTitle() {
        return CytoPanelName.getTitle(this.compassDirection);
    }

    public Component add(Component component) {
        Component c = this.tabbedPane.add(component);
        this.notifyListeners(2);
        return c;
    }

    public Component add(Component component, int index) {
        Component c = this.tabbedPane.add(component, index);
        this.notifyListeners(2);
        return c;
    }

    public Component add(String title, Component component) {
        Component c = this.tabbedPane.add(title, component);
        this.notifyListeners(2);
        return c;
    }

    public void add(String title, Icon icon, Component component) {
        this.tabbedPane.addTab(title, icon, component);
        this.notifyListeners(2);
    }

    public void add(String title, Icon icon, Component component, String tip) {
        this.tabbedPane.addTab(title, icon, component, tip);
        this.notifyListeners(2);
    }

    public int getCytoPanelComponentCount() {
        return this.tabbedPane.getTabCount();
    }

    public Component getSelectedComponent() {
        return this.tabbedPane.getSelectedComponent();
    }

    public Component getComponentAt(int index) {
        return this.tabbedPane.getComponentAt(index);
    }

    public int getSelectedIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public int indexOfComponent(Component component) {
        return this.tabbedPane.indexOfComponent(component);
    }

    public int indexOfComponent(String title) {
        return this.tabbedPane.indexOfTab(title);
    }

    public void remove(Component component) {
        this.tabbedPane.remove(component);
        this.notifyListeners(3);
    }

    public void remove(int index) {
        this.tabbedPane.remove(index);
        this.notifyListeners(3);
    }

    public void removeAll() {
        this.tabbedPane.removeAll();
        this.notifyListeners(3);
    }

    public void setSelectedIndex(int index) {
        this.tabbedPane.setSelectedIndex(index);
    }

    public void setState(CytoPanelState cytoPanelState) {
        boolean success = false;
        if (cytoPanelState == CytoPanelState.HIDE) {
            this.hideCytoPanel(cytoPanelState);
            success = true;
        } else if (cytoPanelState == CytoPanelState.FLOAT) {
            this.FloatCytoPanel();
            success = true;
        } else if (cytoPanelState == CytoPanelState.DOCK) {
            this.DockCytoPanel();
            success = true;
        }
        if (!success) {
            throw new IllegalArgumentException("Illegal Argument:  " + cytoPanelState + ".  is unknown.  Please see CytoPanelState class.");
        }
        this.cytoPanelState = cytoPanelState;
        this.notifyListeners(0);
    }

    public CytoPanelState getState() {
        return this.cytoPanelState;
    }

    public void addCytoPanelListener(CytoPanelListener cytoPanelListener) {
        if (this.cytoPanelListenerList.contains(cytoPanelListener)) {
            return;
        }
        this.cytoPanelListenerList.add(cytoPanelListener);
    }

    public void removeCytoPanelListener(CytoPanelListener cytoPanelListener) {
        if (this.cytoPanelListenerList.contains(cytoPanelListener)) {
            this.cytoPanelListenerList.remove(this.cytoPanelListenerList.indexOf(cytoPanelListener));
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.notifyListeners(1);
    }

    private void initIcons() {
        String floatIconStr = new String("/cytoscape/images/float.gif");
        String dockIconStr = new String("/cytoscape/images/pin.gif");
        this.floatIcon = new ImageIcon(this.getClass().getResource(floatIconStr));
        this.dockIcon = new ImageIcon(this.getClass().getResource(dockIconStr));
    }

    private void showCytoPanel(CytoPanelState cytoPanelState) {
        this.setVisible(true);
        Container parent = this.getParent();
        if (parent instanceof BiModalJSplitPane) {
            BiModalJSplitPane biModalSplitPane = (BiModalJSplitPane)parent;
            biModalSplitPane.setMode(cytoPanelState, 1);
        }
    }

    private void hideCytoPanel(CytoPanelState cytoPanelState) {
        if (this.isFloating()) {
            this.DockCytoPanel();
        }
        this.setVisible(false);
        Container parent = this.getParent();
        if (parent instanceof BiModalJSplitPane) {
            BiModalJSplitPane biModalSplitPane = (BiModalJSplitPane)parent;
            biModalSplitPane.setMode(cytoPanelState, 2);
        }
    }

    void constructPanel() {
        this.initLabel();
        this.initButton();
        JPanel floatDockPanel = new JPanel(new BorderLayout());
        floatDockPanel.add((Component)this.floatLabel, "West");
        floatDockPanel.add((Component)this.floatButton, "East");
        floatDockPanel.setBorder(new EmptyBorder(2, 2, 2, 6));
        floatDockPanel.setBackground(this.FLOAT_PANEL_COLOR);
        FontMetrics fm = this.floatLabel.getFontMetrics(this.floatLabel.getFont());
        floatDockPanel.setMinimumSize(new Dimension((fm.stringWidth(this.getTitle()) + this.floatIcon.getIconWidth()) * 2, this.floatIcon.getIconHeight()));
        floatDockPanel.setPreferredSize(new Dimension((fm.stringWidth(this.getTitle()) + this.floatIcon.getIconWidth()) * 2, this.floatIcon.getIconHeight() + 2));
        this.setLayout(new BorderLayout());
        this.add((Component)floatDockPanel, "North");
        this.add((Component)this.tabbedPane, "Center");
    }

    public void addComponentToSouth(Component pComponent) {
        this.add(pComponent, "South");
    }

    public void removeComponentAtSouth(Component pComponent) {
        this.remove(pComponent);
    }

    private void initLabel() {
        this.floatLabel = new JLabel(this.getTitle());
        this.floatLabel.setFont(new Font("SansSerif", 0, 12));
        this.floatLabel.setBackground(this.FLOAT_PANEL_COLOR);
        this.floatLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
    }

    private void initButton() {
        this.floatButton = new JButton();
        this.floatButton.setIcon(this.floatIcon);
        this.floatButton.setToolTipText(TOOL_TIP_FLOAT);
        this.floatButton.setRolloverEnabled(true);
        this.floatButton.setMargin(new Insets(0, 0, 0, 0));
        this.floatButton.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.floatButton.setBorderPainted(false);
        this.floatButton.setSelected(false);
        this.floatButton.setBackground(this.FLOAT_PANEL_COLOR);
        this.floatButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                CytoPanelImp.this.floatButton.setBorder(new LineBorder(Color.GRAY, 1));
                CytoPanelImp.this.floatButton.setBorderPainted(true);
                CytoPanelImp.this.floatButton.setBackground(Color.LIGHT_GRAY);
            }

            public void mouseExited(MouseEvent e) {
                CytoPanelImp.this.floatButton.setBorder(new EmptyBorder(1, 1, 1, 1));
                CytoPanelImp.this.floatButton.setBorderPainted(false);
                CytoPanelImp.this.floatButton.setBackground(CytoPanelImp.this.FLOAT_PANEL_COLOR);
            }
        });
        this.floatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CytoPanelImp.this.isFloating()) {
                    CytoPanelImp.this.DockCytoPanel();
                } else {
                    CytoPanelImp.this.FloatCytoPanel();
                }
                CytoPanelImp.this.notifyListeners(0);
            }
        });
    }

    private void FloatCytoPanel() {
        this.showCytoPanel(CytoPanelState.FLOAT);
        if (!this.isFloating()) {
            this.externalFrame = new JDialog(Cytoscape.getDesktop());
            this.externalFrame.setAlwaysOnTop(true);
            this.addWindowListener();
            Container contentPane = this.externalFrame.getContentPane();
            contentPane.add((Component)this, "Center");
            this.externalFrame.setSize(this.getSize());
            this.externalFrame.validate();
            this.externalFrame.setTitle(this.getTitle());
            this.floatButton.setIcon(this.dockIcon);
            this.floatButton.setToolTipText(TOOL_TIP_DOCK);
            this.floatLabel.setText("");
            this.setLocationOfExternalFrame(this.externalFrame);
            this.externalFrame.setVisible(true);
            this.cytoPanelState = CytoPanelState.FLOAT;
            this.floatButton.setBorderPainted(false);
            this.validate();
            if (this.compassDirection == 6) {
                ((CytoPanelImp)Cytoscape.getDesktop().getCytoPanel(7)).validate();
            }
        }
    }

    private void DockCytoPanel() {
        this.showCytoPanel(CytoPanelState.DOCK);
        if (this.isFloating()) {
            this.externalFrame.remove(this);
            if (this.cytoPanelContainer == null) {
                CyLogger.getLogger().info("CytoPanel::DockCytoPanel() -cytoPanelContainer reference has not been set!");
                Cytoscape.exit(1);
            }
            this.cytoPanelContainer.insertCytoPanel(this, this.compassDirection);
            this.externalFrame.dispose();
            this.floatButton.setIcon(this.floatIcon);
            this.floatButton.setToolTipText(TOOL_TIP_FLOAT);
            this.floatLabel.setText(this.getTitle());
            this.cytoPanelState = CytoPanelState.DOCK;
            this.floatButton.setBorderPainted(false);
            this.validate();
            if (this.compassDirection == 6) {
                try {
                    this.getParent().getParent().validate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isFloating() {
        return this.cytoPanelState == CytoPanelState.FLOAT;
    }

    private boolean isHidden() {
        return this.cytoPanelState == CytoPanelState.HIDE;
    }

    private void addWindowListener() {
        this.externalFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CytoPanelImp.this.DockCytoPanel();
                CytoPanelImp.this.notifyListeners(0);
            }
        });
    }

    private void setLocationOfExternalFrame(JDialog externalWindow) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenDimension = tk.getScreenSize();
        Rectangle containerBounds = this.cytoPanelContainer.getBounds();
        containerBounds.setLocation(this.cytoPanelContainer.getLocationOnScreen());
        Point p = CytoPanelUtil.getLocationOfExternalFrame(screenDimension, containerBounds, externalWindow.getSize(), this.compassDirection, false);
        externalWindow.setLocation(p);
        externalWindow.setVisible(true);
    }

    private void notifyListeners(int notificationType) {
        block6: for (int lc = 0; lc < this.cytoPanelListenerList.size(); ++lc) {
            CytoPanelListener cytoPanelListener = (CytoPanelListener)this.cytoPanelListenerList.get(lc);
            switch (notificationType) {
                case 0: {
                    cytoPanelListener.onStateChange(this.cytoPanelState);
                    continue block6;
                }
                case 1: {
                    int selectedIndex = this.tabbedPane.getSelectedIndex();
                    cytoPanelListener.onComponentSelected(selectedIndex);
                    continue block6;
                }
                case 2: {
                    cytoPanelListener.onComponentAdded(this.getCytoPanelComponentCount());
                    continue block6;
                }
                case 3: {
                    cytoPanelListener.onComponentRemoved(this.getCytoPanelComponentCount());
                }
            }
        }
    }

    public int getCompassDirection() {
        return this.compassDirection;
    }
}

