/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.LineStyle;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.Serializable;

@Deprecated
public class LineType
implements Serializable {
    public static final LineType LINE_1 = new LineType("LINE_1");
    public static final LineType LINE_2 = new LineType("LINE_2");
    public static final LineType LINE_3 = new LineType("LINE_3");
    public static final LineType LINE_4 = new LineType("LINE_4");
    public static final LineType LINE_5 = new LineType("LINE_5");
    public static final LineType LINE_6 = new LineType("LINE_6");
    public static final LineType LINE_7 = new LineType("LINE_7");
    public static final LineType DASHED_1 = new LineType("DASHED_1");
    public static final LineType DASHED_2 = new LineType("DASHED_2");
    public static final LineType DASHED_3 = new LineType("DASHED_3");
    public static final LineType DASHED_4 = new LineType("DASHED_4");
    public static final LineType DASHED_5 = new LineType("DASHED_5");
    String name;
    Stroke stroke;
    private LineStyle type;
    private Float width;

    public LineType(String name) {
        this.name = name;
        this.type = LineStyle.SOLID;
        if (name.equals("LINE_2")) {
            this.width = Float.valueOf(2.0f);
        } else if (name.equals("LINE_3")) {
            this.width = Float.valueOf(3.0f);
        } else if (name.equals("LINE_4")) {
            this.width = Float.valueOf(4.0f);
        } else if (name.equals("LINE_5")) {
            this.width = Float.valueOf(5.0f);
        } else if (name.equals("LINE_6")) {
            this.width = Float.valueOf(6.0f);
        } else if (name.equals("LINE_7")) {
            this.width = Float.valueOf(7.0f);
        } else if (name.equals("DASHED_1")) {
            this.width = Float.valueOf(1.0f);
            this.type = LineStyle.LONG_DASH;
        } else if (name.equals("DASHED_2")) {
            this.width = Float.valueOf(2.0f);
            this.type = LineStyle.LONG_DASH;
        } else if (name.equals("DASHED_3")) {
            this.width = Float.valueOf(3.0f);
            this.type = LineStyle.LONG_DASH;
        } else if (name.equals("DASHED_4")) {
            this.width = Float.valueOf(4.0f);
            this.type = LineStyle.LONG_DASH;
        } else if (name.equals("DASHED_5")) {
            this.width = Float.valueOf(5.0f);
            this.type = LineStyle.LONG_DASH;
        } else {
            this.width = Float.valueOf(1.0f);
        }
        this.stroke = this.makeStroke();
    }

    public static LineType parseLineTypeText(String text) {
        String lttext = text.trim();
        if ((lttext = lttext.replaceAll("_", "")).equalsIgnoreCase("dashed1")) {
            return DASHED_1;
        }
        if (lttext.equalsIgnoreCase("dashed2")) {
            return DASHED_2;
        }
        if (lttext.equalsIgnoreCase("dashed3")) {
            return DASHED_3;
        }
        if (lttext.equalsIgnoreCase("dashed4")) {
            return DASHED_4;
        }
        if (lttext.equalsIgnoreCase("dashed5")) {
            return DASHED_5;
        }
        if (lttext.equalsIgnoreCase("line1")) {
            return LINE_1;
        }
        if (lttext.equalsIgnoreCase("line2")) {
            return LINE_2;
        }
        if (lttext.equalsIgnoreCase("line3")) {
            return LINE_3;
        }
        if (lttext.equalsIgnoreCase("line4")) {
            return LINE_4;
        }
        if (lttext.equalsIgnoreCase("line5")) {
            return LINE_5;
        }
        if (lttext.equalsIgnoreCase("line6")) {
            return LINE_6;
        }
        if (lttext.equalsIgnoreCase("line7")) {
            return LINE_7;
        }
        return LINE_1;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o instanceof LineType) {
            LineType other = (LineType)o;
            return this.name.equals(other.getName());
        }
        return false;
    }

    private Stroke makeStroke() {
        if (this.type == LineStyle.LONG_DASH) {
            float[] dash = new float[]{5.0f, 3.0f};
            return new BasicStroke(this.width.floatValue(), 0, 0, 1.0f, dash, 0.0f);
        }
        return new BasicStroke(this.width.floatValue());
    }

    public LineType(LineStyle type, Float width) {
        this.type = type;
        this.width = width;
        this.name = type.toString();
        this.stroke = type.getStroke(width.floatValue());
    }

    public float getWidth() {
        return this.width.floatValue();
    }

    public LineStyle getType() {
        return this.type;
    }
}

