/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.CyNetwork;
import cytoscape.logger.CyLogger;
import cytoscape.visual.ShapeNodeRealizer;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.ValueParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.border.DropShadowBorder;

public class PassThroughMapping
implements ObjectMapping {
    private static final Font TITLE_FONT = new Font("SansSerif", 1, 14);
    private static final Color TITLE_COLOR = new Color(10, 200, 255);
    private Class rangeClass;
    private String attrName;

    public PassThroughMapping(Object defaultObj, byte mapType) {
        this(defaultObj);
    }

    public PassThroughMapping(Object defaultObj) {
        if (defaultObj instanceof Byte) {
            defaultObj = ShapeNodeRealizer.getNodeShape((Byte)defaultObj);
        }
        this.rangeClass = defaultObj.getClass();
    }

    public PassThroughMapping(Object defaultObj, String attrName) {
        if (defaultObj instanceof Byte) {
            defaultObj = ShapeNodeRealizer.getNodeShape((Byte)defaultObj);
        }
        this.rangeClass = defaultObj.getClass();
        this.setControllingAttributeName(attrName, null, false);
    }

    public Object clone() {
        PassThroughMapping copy;
        try {
            copy = (PassThroughMapping)super.clone();
        }
        catch (CloneNotSupportedException e) {
            CyLogger.getLogger().warn("Critical error in PassThroughMapping - was not cloneable", e);
            return null;
        }
        copy.attrName = new String(this.attrName);
        return copy;
    }

    public Class getRangeClass() {
        return this.rangeClass;
    }

    public Class[] getAcceptedDataClasses() {
        Class[] ret = new Class[]{Object.class};
        return ret;
    }

    public String getControllingAttributeName() {
        return this.attrName;
    }

    public void setControllingAttributeName(String attrName, CyNetwork network, boolean preserveMapping) {
        this.attrName = attrName;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public JPanel getUI(JDialog parent, CyNetwork network) {
        JPanel p = new JPanel();
        JLabel l1 = new JLabel("This is a passthrough mapping;");
        JLabel l2 = new JLabel("it has no user-editable parameters.");
        p.setLayout(new GridLayout(2, 1));
        p.add(l1);
        p.add(l2);
        return p;
    }

    public Object calculateRangeValue(Map attrBundle) {
        if (attrBundle == null || this.attrName == null) {
            return null;
        }
        Object attrValue = attrBundle.get(this.attrName);
        if (attrValue == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (attrValue instanceof List) {
            int idx = 1;
            int length = ((List)attrValue).size();
            for (Object attrSubValue : (List)attrValue) {
                buf.append(attrSubValue);
                if (idx != length) {
                    buf.append("\n");
                }
                ++idx;
            }
            return buf.toString();
        }
        if (this.rangeClass.isInstance(attrValue)) {
            return attrValue;
        }
        if (this.rangeClass.equals(String.class)) {
            String stringConvert = attrValue.toString();
            if (stringConvert.length() > 20) {
                stringConvert = stringConvert.substring(0, 20) + "...";
            }
            return stringConvert;
        }
        return null;
    }

    public void applyProperties(Properties props, String baseKey, ValueParser parser) {
        String contKey = baseKey + ".controller";
        String contValue = props.getProperty(contKey);
        if (contValue != null) {
            this.setControllingAttributeName(contValue, null, false);
        }
    }

    public Properties getProperties(String baseKey) {
        Properties newProps = new Properties();
        String contKey = baseKey + ".controller";
        String contValue = this.getControllingAttributeName();
        if (contKey != null && contValue != null) {
            newProps.setProperty(contKey, contValue);
        }
        return newProps;
    }

    @Deprecated
    public JPanel getLegend(String visualAttr, byte b) {
        return this.getLegend(VisualPropertyType.getVisualPorpertyType(b));
    }

    public JPanel getLegend(VisualPropertyType vpt) {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JLabel title = new JLabel(vpt.getName() + " is displayed as " + this.attrName);
        title.setFont(TITLE_FONT);
        title.setForeground(TITLE_COLOR);
        title.setHorizontalAlignment(0);
        title.setVerticalAlignment(0);
        title.setHorizontalTextPosition(0);
        title.setVerticalTextPosition(0);
        title.setPreferredSize(new Dimension(200, 50));
        title.setBorder((Border)new DropShadowBorder());
        p.setBackground(Color.white);
        p.add((Component)title, 0);
        return p;
    }
}

