/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.continuous;

import cytoscape.CyNetwork;
import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.continuous.AddPointListener;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.mappings.continuous.DeletePointListener;
import cytoscape.visual.mappings.continuous.PointTextListener;
import cytoscape.visual.mappings.continuous.ValueListener;
import cytoscape.visual.ui.ValueDisplayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

@Deprecated
public class ContinuousUI
extends JPanel
implements ActionListener {
    public static final int LESSER = 0;
    public static final int EQUAL = 1;
    public static final int GREATER = 2;
    private ArrayList components;
    private Object defaultObject;
    private JDialog parentDialog;
    private ContinuousMapping cm;

    public ContinuousUI(JDialog jd, Object defaultObject, CyNetwork network, ContinuousMapping cMap) {
        this.parentDialog = jd;
        this.defaultObject = defaultObject;
        this.cm = cMap;
        this.init();
        this.createPointPanel();
    }

    private void init() {
        this.components = new ArrayList();
    }

    public void resetUI() {
        this.removeAll();
        this.createPointPanel();
        this.validate();
        this.parentDialog.validate();
    }

    public void actionPerformed(ActionEvent e) {
        this.cm.fireStateChanged();
    }

    public void setEnabled(boolean b) {
        for (int i = 0; i < this.components.size(); ++i) {
            JComponent component = (JComponent)this.components.get(i);
            component.setEnabled(b);
        }
    }

    public void createPointPanel() {
        this.setLayout(new BorderLayout());
        GridBagGroup grid = new GridBagGroup();
        JButton newPointButton = new JButton("Add Point");
        newPointButton.addActionListener(new AddPointListener(this, this.cm, this.defaultObject));
        MiscGB.insert(grid, (Component)newPointButton, 4, 0);
        this.createPointUI(grid);
        this.add((Component)grid.panel, "Center");
    }

    private void createPointUI(GridBagGroup grid) {
        for (int i = 0; i < this.cm.getPointCount(); ++i) {
            ContinuousMappingPoint point = this.cm.getPoint(i);
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(17);
            String textValue = numberFormat.format(point.getValue());
            JTextField text = new JTextField(textValue);
            text.setColumns(6);
            text.setMinimumSize(new Dimension(20, 20));
            text.setPreferredSize(new Dimension(30, 20));
            PointTextListener ptl = new PointTextListener(text, this.cm, this.parentDialog, i);
            text.addFocusListener(ptl);
            MiscGB.insert(grid, (Component)text, 1, i + 1);
            JButton bDel = new JButton("Del");
            bDel.addActionListener(new DeletePointListener(this, this.cm, i));
            MiscGB.insert(grid, (Component)bDel, 0, i + 1);
            this.createButtonAndVD(grid, 0, i);
            this.createButtonAndVD(grid, 1, i);
            this.createButtonAndVD(grid, 2, i);
        }
    }

    private void createButtonAndVD(GridBagGroup grid, int lesserEqualGreater, int i) {
        String[] buttonString = new String[]{"Below", "Equal", "Above"};
        ContinuousMappingPoint cmp = this.cm.getPoint(i);
        BoundaryRangeValues range = cmp.getRange();
        Object o = this.getValue(lesserEqualGreater, range);
        ValueDisplayer chooser = ValueDisplayer.getDisplayFor(this.parentDialog, "Select Appearance", o);
        ValueListener listener = new ValueListener(this, this.cm, i, lesserEqualGreater);
        chooser.addItemListener(listener);
        JButton button = new JButton(buttonString[lesserEqualGreater]);
        button.addActionListener(chooser.getInputListener());
        this.components.add(chooser);
        this.components.add(button);
        if (i == 0 && lesserEqualGreater == 0 || lesserEqualGreater == 1 || i == this.cm.getPointCount() - 1 && lesserEqualGreater == 2) {
            MiscGB.insert(grid, button, 2, i + lesserEqualGreater, 1, 1, 2);
            MiscGB.insert(grid, (Component)chooser, 3, i + lesserEqualGreater);
        }
    }

    private Object getValue(int lesserEqualGreater, BoundaryRangeValues range) {
        Object color;
        switch (lesserEqualGreater) {
            case 0: {
                color = range.lesserValue;
                break;
            }
            case 1: {
                color = range.equalValue;
                break;
            }
            default: {
                color = range.greaterValue;
            }
        }
        return color;
    }
}

