/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.NodeIcon;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Paint;
import java.util.Properties;
import javax.swing.Icon;

public class NodeFillColorProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.NODE_FILL_COLOR;
    }

    public Icon getIcon(final Object value) {
        NodeIcon icon = new NodeIcon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 0));
                super.paintIcon(c, g, x, y);
                this.g2d.translate(0, -2);
                this.g2d.setColor((Color)value);
                this.g2d.fill(this.newShape);
                this.g2d.translate(0, 2);
            }
        };
        return icon;
    }

    public void applyToNodeView(NodeView nv, Object o) {
        if (o == null || nv == null || !(o instanceof Color)) {
            return;
        }
        if (!((Color)o).equals(nv.getUnselectedPaint())) {
            nv.setUnselectedPaint((Paint)((Color)o));
        }
    }

    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.NODE_FILL_COLOR.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return new ColorParser().parseColor(s);
        }
        return null;
    }

    public Object getDefaultAppearanceObject() {
        return Color.white;
    }
}

