/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.FloatParser;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.NodeIcon;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Stroke;
import java.util.Properties;
import javax.swing.Icon;

public class NodeLineWidthProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.NODE_LINE_WIDTH;
    }

    public Icon getIcon(final Object value) {
        NodeIcon icon = new NodeIcon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 25));
                super.paintIcon(c, g, x, y);
                this.g2d.setFont(new Font("SansSerif", 1, 24));
                this.g2d.setColor(Color.DARK_GRAY);
                this.g2d.drawString(value.toString(), c.getX() + 7, c.getHeight() / 2 + 7);
                this.g2d.setFont(new Font("SansSerif", 1, 12));
            }
        };
        return icon;
    }

    public void applyToNodeView(NodeView nv, Object o) {
        if (o == null || nv == null) {
            return;
        }
        if (nv.getBorderWidth() != ((Number)o).floatValue()) {
            BasicStroke oldValue = (BasicStroke)nv.getBorder();
            BasicStroke newLine = new BasicStroke(((Number)o).floatValue(), oldValue.getEndCap(), oldValue.getLineJoin(), oldValue.getMiterLimit(), oldValue.getDashArray(), oldValue.getDashPhase());
            nv.setBorder((Stroke)newLine);
        }
    }

    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.NODE_LINE_WIDTH.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return new FloatParser().parseFloat(s);
        }
        return null;
    }

    public Object getDefaultAppearanceObject() {
        return new Float(1.0);
    }
}

