/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLInt64
extends MLNumericArray<Long> {
    public MLInt64(String string, int[] nArray, int n, int n2) {
        super(string, nArray, n, n2);
    }

    public MLInt64(String string, int[] nArray) {
        super(string, nArray, 14, 0);
    }

    public MLInt64(String string, Long[] longArray, int n) {
        super(string, 14, (Number[])longArray, n);
    }

    public MLInt64(String string, long[][] lArray) {
        this(string, MLInt64.long2DToLong(lArray), lArray.length);
    }

    public MLInt64(String string, long[] lArray, int n) {
        this(string, MLInt64.castToLong(lArray), n);
    }

    public Long[] createArray(int n, int n2) {
        return new Long[n * n2];
    }

    public long[][] getArray() {
        long[][] lArrayArray = new long[this.getM()][];
        for (int i = 0; i < this.getM(); ++i) {
            lArrayArray[i] = new long[this.getN()];
            for (int j = 0; j < this.getN(); ++j) {
                lArrayArray[i][j] = (Long)this.getReal(i, j);
            }
        }
        return lArrayArray;
    }

    private static Long[] castToLong(long[] lArray) {
        Long[] longArray = new Long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            longArray[i] = lArray[i];
        }
        return longArray;
    }

    private static Long[] long2DToLong(long[][] lArray) {
        Long[] longArray = new Long[lArray.length * lArray[0].length];
        for (int i = 0; i < lArray[0].length; ++i) {
            for (int j = 0; j < lArray.length; ++j) {
                longArray[j + i * lArray.length] = lArray[j][i];
            }
        }
        return longArray;
    }

    @Override
    public Long buldFromBytes(byte[] byArray) {
        if (byArray.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return ByteBuffer.wrap(byArray).getLong();
    }

    @Override
    public int getBytesAllocated() {
        return 8;
    }

    @Override
    public Class<Long> getStorageClazz() {
        return Long.class;
    }

    @Override
    public byte[] getByteArray(Long l) {
        int n = this.getBytesAllocated();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.putLong(l);
        return byteBuffer.array();
    }
}

