/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.actions.BitmapExportFilter;
import cytoscape.actions.ExportFilter;
import cytoscape.actions.PDFExportFilter;
import cytoscape.actions.PSExportFilter;
import cytoscape.actions.SVGExportFilter;
import cytoscape.dialogs.ExportAsGraphicsFileChooser;
import cytoscape.logger.CyLogger;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JOptionPane;
import javax.swing.event.MenuEvent;

public class ExportAsGraphicsAction
extends CytoscapeAction {
    private static ExportFilter BMP_FILTER = new BitmapExportFilter("bmp", "BMP");
    private static ExportFilter JPG_FILTER = new BitmapExportFilter("jpg", "JPEG");
    private static ExportFilter PDF_FILTER = new PDFExportFilter();
    private static ExportFilter PNG_FILTER = new BitmapExportFilter("png", "PNG");
    private static ExportFilter SVG_FILTER = new SVGExportFilter();
    private static ExportFilter EPS_FILTER = new PSExportFilter("eps", "EPS");
    private static ExportFilter[] FILTERS = new ExportFilter[]{PDF_FILTER, SVG_FILTER, EPS_FILTER, JPG_FILTER, PNG_FILTER, BMP_FILTER};
    protected static CyLogger logger = CyLogger.getLogger(ExportAsGraphicsAction.class);
    private static String TITLE = "Network View as Graphics";

    public ExportAsGraphicsAction() {
        super(TITLE + "...");
        this.setPreferredMenu("File.Export");
        this.setAcceleratorCombo(80, 3);
    }

    public void menuSelected(MenuEvent e) {
        this.enableForNetworkAndView();
    }

    public void actionPerformed(ActionEvent e) {
        final ExportAsGraphicsFileChooser chooser = new ExportAsGraphicsFileChooser(FILTERS);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ExportFilter filter = (ExportFilter)chooser.getSelectedFormat();
                filter.setExportTextAsFont(chooser.getExportTextAsFont());
                File file = chooser.getSelectedFile();
                chooser.dispose();
                FileOutputStream stream = null;
                try {
                    stream = new FileOutputStream(file);
                }
                catch (Exception exp) {
                    JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Could not create file " + file.getName() + "\n\nError: " + exp.getMessage());
                    return;
                }
                CyNetworkView view = Cytoscape.getCurrentNetworkView();
                filter.export(view, stream);
            }
        };
        chooser.addActionListener(listener);
        chooser.setVisible(true);
    }
}

