/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.bookmarks.DataSource;
import cytoscape.dialogs.plugins.PluginManageDialog;
import cytoscape.logger.CyLogger;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.ManagerUtil;
import cytoscape.plugin.PluginInquireAction;
import cytoscape.plugin.PluginManager;
import cytoscape.plugin.PluginManagerInquireTask;
import cytoscape.plugin.PluginStatus;
import cytoscape.task.Task;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.BookmarksUtil;
import cytoscape.util.CytoscapeAction;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class PluginManagerAction
extends CytoscapeAction {
    private String bookmarkCategory = "plugins";
    private CyLogger logger = CyLogger.getLogger(PluginManagerAction.class);

    public PluginManagerAction() {
        super("Manage Plugins");
        this.setPreferredMenu("Plugins");
    }

    public void actionPerformed(ActionEvent e) {
        PluginManageDialog dialog = new PluginManageDialog(Cytoscape.getDesktop());
        PluginManager Mgr = PluginManager.getPluginManager();
        if (Mgr.getLoadingErrors().size() > 0) {
            String message = "";
            for (Throwable t : Mgr.getLoadingErrors()) {
                message = message + t.getMessage() + "\n";
            }
            JOptionPane.showMessageDialog(Cytoscape.getDesktop(), message, "Plugin Manager Error", 0);
        }
        String DefaultUrl = CytoscapeInit.getProperties().getProperty("defaultPluginDownloadUrl");
        String DefaultTitle = "Cytoscape";
        try {
            Bookmarks theBookmarks = Cytoscape.getBookmarks();
            List<DataSource> DataSourceList = BookmarksUtil.getDataSourceList(this.bookmarkCategory, theBookmarks.getCategory());
            for (DataSource ds : DataSourceList) {
                if (!ds.getName().equals("Cytoscape")) continue;
                DefaultUrl = ds.getHref();
                DefaultTitle = ds.getName();
                break;
            }
        }
        catch (Exception E) {
            this.logger.warn("There was an error while reading the bookmarks file.", E);
        }
        List<DownloadableInfo> Current = Mgr.getDownloadables(PluginStatus.CURRENT);
        Map<String, List<DownloadableInfo>> InstalledInfo = ManagerUtil.sortByCategory(Current);
        for (String Category2 : InstalledInfo.keySet()) {
            dialog.addCategory(Category2, InstalledInfo.get(Category2), PluginManageDialog.PluginInstallStatus.INSTALLED);
        }
        PluginManagerInquireTask task = new PluginManagerInquireTask(DefaultUrl, new ManagerAction(dialog, DefaultTitle, DefaultUrl));
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.setOwner((Container)Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(false);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(true);
        jTaskConfig.displayCancelButton(false);
        TaskManager.executeTask((Task)task, (JTaskConfig)jTaskConfig);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ManagerAction
    extends PluginInquireAction {
        private CyLogger logger = CyLogger.getLogger(ManagerAction.class);
        private PluginManageDialog dialog;
        private String title;
        private String url;

        public ManagerAction(PluginManageDialog Dialog2, String Title, String Url) {
            this.dialog = Dialog2;
            this.title = Title;
            this.url = Url;
        }

        @Override
        public String getProgressBarMessage() {
            return "Attempting to connect to " + this.url;
        }

        @Override
        public void inquireAction(List<DownloadableInfo> Results) {
            PluginManager Mgr = PluginManager.getPluginManager();
            if (this.isExceptionThrown()) {
                if (this.getIOException() != null) {
                    this.logger.error(this.getIOException().getMessage(), this.getIOException());
                    this.dialog.setError(PluginManageDialog.CommonError.NOXML.toString());
                } else if (this.getJDOMException() != null) {
                    this.logger.error(this.getJDOMException().getMessage(), (Throwable)this.getJDOMException());
                    this.dialog.setError(PluginManageDialog.CommonError.BADXML.toString());
                } else {
                    this.logger.error(this.getException().getMessage(), this.getException());
                    this.dialog.setError(this.getException().getMessage());
                }
            } else {
                List<DownloadableInfo> Unique = ManagerUtil.getUnique(Mgr.getDownloadables(PluginStatus.CURRENT), Results);
                Map<String, List<DownloadableInfo>> AvailableInfo = ManagerUtil.sortByCategory(Unique);
                for (String Category2 : AvailableInfo.keySet()) {
                    this.dialog.addCategory(Category2, AvailableInfo.get(Category2), PluginManageDialog.PluginInstallStatus.AVAILABLE);
                }
            }
            this.dialog.setSiteName(this.title);
            this.dialog.setVisible(true);
        }
    }
}

