/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.util.CytoscapeAction;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.event.MenuEvent;

public class SelectAdjacentEdgesAction
extends CytoscapeAction {
    public SelectAdjacentEdgesAction() {
        super("Select adjacent edges");
        this.setPreferredMenu("Select.Edges");
        this.setAcceleratorCombo(69, 8);
    }

    public void actionPerformed(ActionEvent e) {
        CyNetwork network = Cytoscape.getCurrentNetwork();
        HashMap<CyEdge, CyEdge> edgeMap = new HashMap<CyEdge, CyEdge>();
        for (CyNode node : network.getSelectedNodes()) {
            int[] edgeIndices = network.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), true, true, true);
            if (edgeIndices == null) continue;
            for (int i = 0; i < edgeIndices.length; ++i) {
                CyEdge edge = (CyEdge)network.getEdge(edgeIndices[i]);
                edgeMap.put(edge, edge);
            }
        }
        network.setSelectedEdgeState(edgeMap.keySet(), true);
        if (Cytoscape.getCurrentNetworkView() != null) {
            Cytoscape.getCurrentNetworkView().updateView();
        }
    }

    public void menuSelected(MenuEvent e) {
        this.enableForNetwork();
    }
}

