/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.ontology.readers;

import cytoscape.data.ontology.DBReference;
import cytoscape.data.ontology.readers.DBXrefKeywords;
import cytoscape.util.URLUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCrossReferenceReader {
    private Map<String, DBReference> xref = new HashMap<String, DBReference>();
    private static final String DBXREF_RESOURCE_FILE = "/cytoscape/resources/GO.xrf_abbs";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readResourceFile() throws IOException {
        String line;
        URL resource = this.getClass().getResource(DBXREF_RESOURCE_FILE);
        BufferedReader bufRd = new BufferedReader(new InputStreamReader(URLUtil.getBasicInputStream(resource)));
        while ((line = bufRd.readLine()) != null) {
            if (!line.startsWith(DBXrefKeywords.ABBREVIATION.toString())) continue;
            int colonInx = line.indexOf(58);
            String abb = line.substring(colonInx + 1).trim();
            this.readEntry(abb, bufRd);
        }
        try {
            if (bufRd != null) {
                bufRd.close();
            }
        }
        catch (IOException ioe) {
        }
        finally {
            bufRd = null;
        }
    }

    private void readEntry(String abbreviation, BufferedReader rd) throws IOException {
        String line;
        String dbName = null;
        String urlSyntax = null;
        String genericUrl = null;
        String object = null;
        ArrayList<String> synonyms = new ArrayList<String>();
        while ((line = rd.readLine()) != null && line.trim().length() != 0) {
            int colonInx = line.indexOf(58);
            String key = line.substring(0, colonInx).trim();
            String val = line.substring(colonInx + 1).trim();
            if (key.equals(DBXrefKeywords.SYNONYM.toString())) {
                synonyms.add(val);
                continue;
            }
            if (key.equals(DBXrefKeywords.DATABASE.toString())) {
                dbName = val;
                continue;
            }
            if (key.equals(DBXrefKeywords.GENERIC_URL.toString())) {
                genericUrl = val;
                continue;
            }
            if (key.equals(DBXrefKeywords.URL_SYNTAX.toString())) {
                urlSyntax = val;
                continue;
            }
            if (!key.equals(DBXrefKeywords.OBJECT.toString())) continue;
            object = val;
        }
        DBReference ref = new DBReference(abbreviation, dbName, urlSyntax, genericUrl, object);
        if (synonyms.size() != 0) {
            ref.setSynonym(synonyms);
        }
        this.xref.put(abbreviation, ref);
    }

    public Map<String, DBReference> getXrefMap() {
        return this.xref;
    }
}

