/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.webservice;

import cytoscape.data.webservice.CyWebServiceEvent;
import cytoscape.data.webservice.CyWebServiceEventListener;
import cytoscape.data.webservice.CyWebServiceException;
import cytoscape.data.webservice.WebServiceClient;
import cytoscape.data.webservice.WebServiceClientManager;
import cytoscape.util.ModuleProperties;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebServiceClientImpl<S>
implements Serializable,
WebServiceClient<S>,
CyWebServiceEventListener {
    protected static final String DEF_NAME = "default";
    protected static final String DEF_DISPLAY_NAME = "Default Web Service Cilent";
    protected S clientStub;
    protected String clientID;
    protected String displayName;
    protected WebServiceClientManager.ClientType[] type;
    protected ModuleProperties props;
    protected Collection<Method> availableMethods = null;
    protected String description = "Description for " + this.displayName + " is not available.";

    public WebServiceClientImpl() {
        this(DEF_NAME, DEF_DISPLAY_NAME);
    }

    public WebServiceClientImpl(String serviceName, String displayName) {
        this(serviceName, displayName, new WebServiceClientManager.ClientType[]{WebServiceClientManager.ClientType.ATTRIBUTE});
    }

    public WebServiceClientImpl(String serviceName, String displayName, WebServiceClientManager.ClientType[] types) {
        this(serviceName, displayName, types, null);
    }

    public WebServiceClientImpl(String serviceName, String displayName, WebServiceClientManager.ClientType[] types, ModuleProperties props) {
        this(serviceName, displayName, types, props, null);
    }

    public WebServiceClientImpl(String serviceName, String displayName, WebServiceClientManager.ClientType[] types, ModuleProperties props, S clientStub) {
        this.clientID = serviceName;
        this.displayName = displayName;
        this.type = types;
        this.props = props;
        this.clientStub = clientStub;
        WebServiceClientManager.getCyWebServiceEventSupport().addCyWebServiceEventListener(this);
    }

    @Override
    public Collection<Method> getAccessibleMethods() {
        if (this.availableMethods == null) {
            Method[] methods;
            this.availableMethods = new ArrayList<Method>();
            Class<?> stubClass = this.clientStub.getClass();
            for (Method m : methods = stubClass.getMethods()) {
                if (!m.toString().startsWith("public")) continue;
                this.availableMethods.add(m);
            }
        }
        return this.availableMethods;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getClientID() {
        return this.clientID;
    }

    @Override
    public WebServiceClientManager.ClientType[] getClientType() {
        return this.type;
    }

    @Override
    public boolean isCompatibleType(WebServiceClientManager.ClientType ct) {
        for (WebServiceClientManager.ClientType t : this.type) {
            if (!t.equals((Object)ct)) continue;
            return true;
        }
        return false;
    }

    @Override
    public S getClientStub() {
        return this.clientStub;
    }

    @Override
    public ModuleProperties getProps() {
        return this.props;
    }

    @Override
    public void setProps(ModuleProperties props) {
        this.props = props;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setClientStub(S stub) {
        this.clientStub = stub;
    }

    @Override
    public abstract void executeService(CyWebServiceEvent var1) throws CyWebServiceException;
}

