/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.Cytoscape;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ExportBitmapOptionsDialog
extends JDialog {
    private JFormattedTextField zoomField;
    private JFormattedTextField widthInPixelsField;
    private JFormattedTextField heightInPixelsField;
    private JFormattedTextField widthInInchesField;
    private JFormattedTextField heightInInchesField;
    private JComboBox resolutionComboBox;
    private JButton okButton;
    private int originalWidth;
    private int originalHeight;

    public ExportBitmapOptionsDialog(int imageWidth, int imageHeight) {
        super((Frame)Cytoscape.getDesktop(), "Export Bitmap Options");
        this.originalWidth = imageWidth;
        this.originalHeight = imageHeight;
        this.setDefaultCloseOperation(2);
        Container content = this.getContentPane();
        JPanel sizePanel = new JPanel();
        sizePanel.setBorder(new TitledBorder(new EtchedBorder(), "Image Size"));
        sizePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel zoomLabel = new JLabel("Zoom: ");
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)zoomLabel, c);
        this.zoomField = new JFormattedTextField(new DecimalFormat());
        this.zoomField.setColumns(3);
        ZoomListener zoomListener = new ZoomListener(this.zoomField);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)this.zoomField, c);
        JLabel zoomPercentLabel = new JLabel("%");
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)zoomPercentLabel, c);
        JSeparator separator0 = new JSeparator();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)separator0, c);
        JLabel widthInPixelsLabel = new JLabel("Width: ");
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)widthInPixelsLabel, c);
        this.widthInPixelsField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.widthInPixelsField.setColumns(4);
        new WidthInPixelsListener(this.widthInPixelsField);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)this.widthInPixelsField, c);
        JLabel widthPixelsLabel = new JLabel("pixels");
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)widthPixelsLabel, c);
        JLabel heightInPixelsLabel = new JLabel("Height:");
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)heightInPixelsLabel, c);
        this.heightInPixelsField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.heightInPixelsField.setColumns(4);
        new HeightInPixelsListener(this.heightInPixelsField);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)this.heightInPixelsField, c);
        JLabel heightPixelsLabel = new JLabel("pixels");
        c.gridx = 2;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)heightPixelsLabel, c);
        JSeparator separator1 = new JSeparator();
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)separator1, c);
        JLabel widthInInchesLabel = new JLabel("Width: ");
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)widthInInchesLabel, c);
        this.widthInInchesField = new JFormattedTextField(new DecimalFormat());
        this.widthInInchesField.setColumns(4);
        new WidthInInchesListener(this.widthInInchesField);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)this.widthInInchesField, c);
        JLabel widthInchesLabel = new JLabel("inches");
        c.gridx = 2;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)widthInchesLabel, c);
        JLabel heightInInchesLabel = new JLabel("Height:");
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)heightInInchesLabel, c);
        this.heightInInchesField = new JFormattedTextField(new DecimalFormat());
        this.heightInInchesField.setColumns(4);
        new HeightInInchesListener(this.heightInInchesField);
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)this.heightInInchesField, c);
        JLabel heightInchesLabel = new JLabel("inches");
        c.gridx = 2;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)heightInchesLabel, c);
        JLabel resolutionLabel = new JLabel("Resolution:");
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)resolutionLabel, c);
        Integer[] resolutions = new Integer[]{new Integer(72), new Integer(100), new Integer(150), new Integer(300)};
        this.resolutionComboBox = new JComboBox<Integer>(resolutions);
        this.resolutionComboBox.addActionListener(zoomListener);
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        sizePanel.add((Component)this.resolutionComboBox, c);
        JLabel dpiLabel = new JLabel("DPI");
        c.gridx = 2;
        c.gridy = 7;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        sizePanel.add((Component)dpiLabel, c);
        this.okButton = new JButton("   OK   ");
        this.okButton.setDefaultCapable(true);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new CancelListener());
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(cancelButton);
        buttonsPanel.add(this.okButton);
        content.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        content.add((Component)sizePanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 0;
        c.anchor = 14;
        content.add((Component)buttonsPanel, c);
        this.updateOnZoom(1.0);
        this.setLocationRelativeTo(Cytoscape.getDesktop());
        this.pack();
    }

    public double getZoom() {
        return ((Number)this.zoomField.getValue()).doubleValue() / 100.0;
    }

    public void addActionListener(ActionListener l) {
        this.okButton.addActionListener(l);
    }

    private void updateOnZoom(double newZoom) {
        this.zoomField.setValue(new Double(newZoom * 100.0));
        int newWidth = (int)(newZoom * (double)this.originalWidth);
        int newHeight = (int)(newZoom * (double)this.originalHeight);
        this.widthInPixelsField.setValue(new Integer(newWidth));
        this.heightInPixelsField.setValue(new Integer(newHeight));
        double dpi = ((Number)this.resolutionComboBox.getSelectedItem()).doubleValue();
        double newWidthInches = (double)newWidth / dpi;
        double newHeightInches = (double)newHeight / dpi;
        this.widthInInchesField.setValue(new Double(newWidthInches));
        this.heightInInchesField.setValue(new Double(newHeightInches));
    }

    private void updateOnWidthPixels(int newWidthPixels) {
        double newZoom = (double)newWidthPixels / (double)this.originalWidth;
        this.updateOnZoom(newZoom);
    }

    private void updateOnHeightPixels(int newHeightPixels) {
        double newZoom = (double)newHeightPixels / (double)this.originalHeight;
        this.updateOnZoom(newZoom);
    }

    private void updateOnWidthInches(double newWidthInches) {
        double dpi = ((Number)this.resolutionComboBox.getSelectedItem()).doubleValue();
        this.updateOnWidthPixels((int)(newWidthInches * dpi));
    }

    private void updateOnHeightInches(double newHeightInches) {
        double dpi = ((Number)this.resolutionComboBox.getSelectedItem()).doubleValue();
        this.updateOnHeightPixels((int)(newHeightInches * dpi));
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ExportBitmapOptionsDialog.this.dispose();
        }
    }

    private class HeightInInchesListener
    extends FormattedFieldListener {
        public HeightInInchesListener(JFormattedTextField field) {
            super(field);
        }

        public void update() {
            double height = ((Number)ExportBitmapOptionsDialog.this.heightInInchesField.getValue()).doubleValue();
            ExportBitmapOptionsDialog.this.updateOnHeightInches(height);
        }
    }

    private class WidthInInchesListener
    extends FormattedFieldListener {
        public WidthInInchesListener(JFormattedTextField field) {
            super(field);
        }

        public void update() {
            double width = ((Number)ExportBitmapOptionsDialog.this.widthInInchesField.getValue()).doubleValue();
            ExportBitmapOptionsDialog.this.updateOnWidthInches(width);
        }
    }

    private class HeightInPixelsListener
    extends FormattedFieldListener {
        public HeightInPixelsListener(JFormattedTextField field) {
            super(field);
        }

        public void update() {
            int height = ((Number)ExportBitmapOptionsDialog.this.heightInPixelsField.getValue()).intValue();
            ExportBitmapOptionsDialog.this.updateOnHeightPixels(height);
        }
    }

    private class WidthInPixelsListener
    extends FormattedFieldListener {
        public WidthInPixelsListener(JFormattedTextField field) {
            super(field);
        }

        public void update() {
            int width = ((Number)ExportBitmapOptionsDialog.this.widthInPixelsField.getValue()).intValue();
            ExportBitmapOptionsDialog.this.updateOnWidthPixels(width);
        }
    }

    private class ZoomListener
    extends FormattedFieldListener {
        public ZoomListener(JFormattedTextField field) {
            super(field);
        }

        public void update() {
            double zoom = ((Number)ExportBitmapOptionsDialog.this.zoomField.getValue()).doubleValue();
            ExportBitmapOptionsDialog.this.updateOnZoom(zoom /= 100.0);
        }
    }

    private abstract class FormattedFieldListener
    extends FocusAdapter
    implements ActionListener {
        private JFormattedTextField field;

        public abstract void update();

        public FormattedFieldListener(JFormattedTextField field) {
            this.field = field;
            field.addActionListener(this);
            field.addFocusListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            this.update();
        }

        public void focusLost(FocusEvent l) {
            try {
                this.field.commitEdit();
            }
            catch (ParseException exp) {
                return;
            }
            this.update();
        }
    }
}

