/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.ding;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.logger.CyLogger;
import cytoscape.render.stateful.GraphLOD;
import cytoscape.view.CyNetworkView;
import ding.view.DGraphView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class CyGraphLOD
extends GraphLOD
implements PropertyChangeListener {
    protected int coarseDetailThreshold;
    protected int nodeBorderThreshold;
    protected int nodeLabelThreshold;
    protected int edgeArrowThreshold;
    protected int edgeLabelThreshold;
    protected static CyLogger logger = CyLogger.getLogger(CyGraphLOD.class);

    public CyGraphLOD() {
        this.init();
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "PREFERENCES_UPDATED") {
            this.init();
            Map<String, CyNetworkView> networkViewMap = Cytoscape.getNetworkViewMap();
            Iterator<CyNetworkView> foo = networkViewMap.values().iterator();
            while (foo.hasNext()) {
                ((DGraphView)foo.next()).setGraphLOD((GraphLOD)this);
            }
        }
    }

    protected void init() {
        this.coarseDetailThreshold = this.getInt("render.coarseDetailThreshold", 2000);
        this.nodeBorderThreshold = this.getInt("render.nodeBorderThreshold", 200);
        this.nodeLabelThreshold = this.getInt("render.nodeLabelThreshold", 100);
        this.edgeArrowThreshold = this.getInt("render.edgeArrowThreshold", 300);
        this.edgeLabelThreshold = this.getInt("render.edgeLabelThreshold", 120);
    }

    protected int getInt(String key, int defaultValue) {
        String val = CytoscapeInit.getProperties().getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        int ret = defaultValue;
        try {
            ret = Integer.parseInt(val);
        }
        catch (Exception e) {
            logger.warn("Property value for " + key + " must be an integer");
        }
        return ret;
    }

    protected boolean getBoolean(String key, boolean defaultValue) {
        String val = CytoscapeInit.getProperties().getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        boolean ret = defaultValue;
        try {
            ret = Pattern.compile("true", 2).matcher(val).matches();
        }
        catch (Exception e) {
            logger.warn("Property value for " + key + " must be a boolean");
        }
        return ret;
    }

    public byte renderEdges(int visibleNodeCount, int totalNodeCount, int totalEdgeCount) {
        if (totalEdgeCount >= Math.min(this.edgeArrowThreshold, this.edgeLabelThreshold)) {
            return 0;
        }
        return 1;
    }

    public boolean detail(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount + renderEdgeCount < this.coarseDetailThreshold;
    }

    public boolean nodeBorders(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount < this.nodeBorderThreshold;
    }

    public boolean nodeLabels(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount < this.nodeLabelThreshold;
    }

    public boolean customGraphics(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount < this.nodeBorderThreshold;
    }

    public boolean edgeArrows(int renderNodeCount, int renderEdgeCount) {
        return renderEdgeCount < this.edgeArrowThreshold;
    }

    public boolean dashedEdges(int renderNodeCount, int renderEdgeCount) {
        return true;
    }

    public boolean edgeAnchors(int renderNodeCount, int renderEdgeCount) {
        return true;
    }

    public boolean edgeLabels(int renderNodeCount, int renderEdgeCount) {
        return renderEdgeCount < this.edgeLabelThreshold;
    }

    public boolean textAsShape(int renderNodeCount, int renderEdgeCount) {
        return false;
    }
}

