/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.logger.CyLogger;
import cytoscape.plugin.Category;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.DownloadableType;
import cytoscape.plugin.PluginFileReader;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginManager;
import cytoscape.plugin.PluginStatus;
import cytoscape.plugin.PluginXml;
import cytoscape.plugin.ThemeInfo;
import cytoscape.plugin.TrackerException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginTracker {
    private static CyLogger logger = CyLogger.getLogger(PluginTracker.class);
    private Document trackerDoc;
    private File installFile;
    private HashMap<String, Element> infoObjMap;
    private Set<Element> corruptedElements;
    private boolean corruptedElementsFound = false;
    private String cytoVersTag = "cytoscapeVersion";
    private String nameTag = PluginXml.NAME.getTag();
    private String descTag = PluginXml.DESCRIPTION.getTag();
    private String classTag = PluginXml.CLASS_NAME.getTag();
    private String pluginVersTag = PluginXml.PLUGIN_VERSION.getTag();
    private String urlTag = PluginXml.URL.getTag();
    private String projUrlTag = PluginXml.PROJECT_URL.getTag();
    private String downloadUrlTag = PluginXml.DOWNLOAD_URL.getTag();
    private String categoryTag = PluginXml.CATEGORY.getTag();
    private String fileListTag = PluginXml.FILE_LIST.getTag();
    private String fileTag = PluginXml.FILE.getTag();
    private String pluginListTag = PluginXml.PLUGIN_LIST.getTag();
    private String pluginTag = PluginXml.PLUGIN.getTag();
    private String authorListTag = PluginXml.AUTHOR_LIST.getTag();
    private String authorTag = PluginXml.AUTHOR.getTag();
    private String instTag = PluginXml.INSTITUTION.getTag();
    private String uniqueIdTag = PluginXml.UNIQUE_ID.getTag();
    private String fileTypeTag = PluginXml.FILE_TYPE.getTag();
    private String licenseTag = PluginXml.LICENSE.getTag();
    private String installLocTag = PluginXml.INSTALL_LOCATION.getTag();

    protected PluginTracker(File Dir, String FileName) throws IOException, TrackerException {
        this.installFile = new File(Dir, FileName);
        this.init();
    }

    protected PluginTracker(File file) throws IOException, TrackerException {
        this.installFile = file;
        this.init();
    }

    protected File getTrackerFile() {
        return this.installFile;
    }

    private void init() throws IOException, TrackerException {
        this.corruptedElements = new HashSet<Element>();
        if (PluginManager.usingWebstartManager()) {
            this.installFile.delete();
        }
        if (this.installFile.exists() && this.installFile.length() > 0L) {
            SAXBuilder Builder2 = new SAXBuilder(false);
            try {
                this.trackerDoc = Builder2.build(this.installFile);
                this.removeMissingIdEntries();
                this.write();
            }
            catch (JDOMException jde) {
                this.installFile.delete();
                this.createCleanDoc();
                throw new TrackerException("Plugin tracking file is corrupted.  Please reinstall your plugins. Deleting " + this.installFile.getAbsolutePath(), jde);
            }
            finally {
                this.createPluginTable();
            }
        } else {
            this.createCleanDoc();
            this.createPluginTable();
        }
    }

    private void createCleanDoc() {
        logger.warn("Plugin tracker file: " + this.installFile.getAbsolutePath());
        this.trackerDoc = new Document();
        this.trackerDoc.setRootElement(new Element("CytoscapePlugin"));
        this.trackerDoc.getRootElement().addContent((Content)new Element(PluginStatus.CURRENT.getTagName()));
        this.trackerDoc.getRootElement().addContent((Content)new Element(PluginStatus.INSTALL.getTagName()));
        this.trackerDoc.getRootElement().addContent((Content)new Element(PluginStatus.DELETE.getTagName()));
        this.write();
    }

    private void removeMissingIdEntries() {
        List Plugins2 = this.trackerDoc.getRootElement().getChild(PluginStatus.CURRENT.getTagName()).getChildren(this.pluginTag);
        ArrayList<Element> PluginsToRemove = new ArrayList<Element>();
        for (Element plugin : Plugins2) {
            if (plugin.getChild(this.uniqueIdTag) != null && plugin.getChild(this.uniqueIdTag).getTextTrim().length() > 0) continue;
            PluginsToRemove.add(plugin);
        }
        for (Element child : PluginsToRemove) {
            this.trackerDoc.getRootElement().getChild(PluginStatus.CURRENT.getTagName()).removeContent((Content)child);
        }
    }

    protected List<PluginInfo> getPluginListByStatus(PluginStatus Status) {
        return this.getPluginContent(this.trackerDoc.getRootElement().getChild(Status.getTagName()));
    }

    protected List<DownloadableInfo> getDownloadableListByStatus(PluginStatus Status) {
        return this.getDownloadableContent(this.trackerDoc.getRootElement().getChild(Status.getTagName()));
    }

    protected List<ThemeInfo> getThemeListByStatus(PluginStatus Status) {
        return this.getThemeContent(this.trackerDoc.getRootElement().getChild(Status.getTagName()));
    }

    protected void addDownloadable(DownloadableInfo obj, PluginStatus Status) {
        Element Parent2 = this.trackerDoc.getRootElement().getChild(Status.getTagName());
        switch (obj.getType()) {
            case PLUGIN: {
                this.addPlugin((PluginInfo)obj, Status);
                break;
            }
            case THEME: {
                this.addTheme((ThemeInfo)obj, Status);
            }
        }
    }

    private void addTheme(ThemeInfo obj, PluginStatus Status) {
        Element ThemeParent = this.trackerDoc.getRootElement().getChild(Status.getTagName());
        Element Theme = this.getMatchingInfoObj(obj, Status);
        if (Theme != null) {
            Theme = this.updateBasicElement(obj, Theme);
            Theme.getChild(PluginXml.PLUGIN_LIST.getTag()).removeChildren(PluginXml.PLUGIN.getTag());
            for (PluginInfo plugin : obj.getPlugins()) {
                Element ThemePlugin = this.getMatchingInfoObj(plugin, Status);
                ThemePlugin = this.updatePluginElement(plugin, ThemePlugin);
                Theme.getChild(PluginXml.PLUGIN_LIST.getTag()).addContent((Content)ThemePlugin);
            }
        } else {
            Theme = this.createThemeContent(obj);
            ThemeParent.addContent((Content)Theme);
            this.infoObjMap.put(this.infoMapKey(obj, Status), Theme);
            logger.info("Adding theme " + obj.getName() + " status " + Status.name());
        }
        this.write();
    }

    private Element updateBasicElement(DownloadableInfo obj, Element element) {
        if (!obj.getCategory().equals(Category.NONE.getCategoryText())) {
            element.getChild(this.categoryTag).setText(obj.getCategory());
        }
        element.getChild(this.cytoVersTag).setText(obj.getCytoscapeVersion());
        element.getChild(this.descTag).setText(obj.getDescription());
        if (element.getChild(this.pluginVersTag) != null) {
            element.getChild(this.pluginVersTag).setText(obj.getObjectVersion());
        } else {
            Element PluginVersion = new Element(this.pluginVersTag);
            element.addContent((Content)PluginVersion.setText(obj.getObjectVersion()));
        }
        if (element.getChild(PluginXml.RELEASE_DATE.getTag()) != null) {
            element.getChild(PluginXml.RELEASE_DATE.getTag()).setText(obj.getReleaseDate());
        } else {
            Element ReleaseDate = new Element(PluginXml.RELEASE_DATE.getTag());
            element.addContent((Content)ReleaseDate.setText(obj.getReleaseDate()));
        }
        return element;
    }

    private Element updatePluginElement(PluginInfo obj, Element Plugin2) {
        if (!obj.getName().equals(obj.getPluginClassName())) {
            Plugin2.getChild(this.nameTag).setText(obj.getName());
        }
        Plugin2 = this.updateBasicElement(obj, Plugin2);
        Plugin2.getChild(this.installLocTag).setText(obj.getInstallLocation());
        if (obj.getPluginClassName() != null) {
            Plugin2.getChild(this.classTag).setText(obj.getPluginClassName());
        }
        Plugin2.removeChild(this.authorListTag);
        Element Authors = new Element(this.authorListTag);
        for (PluginInfo.AuthorInfo ai : obj.getAuthors()) {
            Element Author = new Element(this.authorTag);
            Author.addContent((Content)new Element(this.nameTag).setText(ai.getAuthor()));
            Author.addContent((Content)new Element(this.instTag).setText(ai.getInstitution()));
            Authors.addContent((Content)Author);
        }
        Plugin2.addContent((Content)Authors);
        return Plugin2;
    }

    private void addPlugin(PluginInfo obj, PluginStatus Status) {
        Element PluginParent = this.trackerDoc.getRootElement().getChild(Status.getTagName());
        Element PluginEl = this.getMatchingInfoObj(obj, Status);
        if (PluginEl != null) {
            this.updatePluginElement(obj, PluginEl);
            this.infoObjMap.put(this.infoMapKey(obj, Status), PluginEl);
        } else {
            Element NewPlugin = this.createPluginContent(obj);
            PluginParent.addContent((Content)NewPlugin);
            this.infoObjMap.put(this.infoMapKey(obj, Status), NewPlugin);
            logger.info("Adding plugin " + obj.getName() + " status " + Status.name());
        }
        this.write();
    }

    protected void removeDownloadable(DownloadableInfo obj, PluginStatus Status) {
        Element Parent2 = this.trackerDoc.getRootElement().getChild(Status.getTagName());
        Element InfoObj2 = this.getMatchingInfoObj(obj, Status);
        if (InfoObj2 != null) {
            Parent2.removeContent((Content)InfoObj2);
            this.infoObjMap.remove(this.infoMapKey(obj, Status));
            if (obj.getType().equals((Object)DownloadableType.THEME)) {
                ThemeInfo theme = (ThemeInfo)obj;
                for (PluginInfo themePlugin : theme.getPlugins()) {
                    this.infoObjMap.remove(this.infoMapKey(themePlugin, Status));
                }
            }
            logger.info("Removing plugin/theme " + obj.getName() + " status " + Status.name());
            this.write();
        }
    }

    protected Element getMatchingInfoObj(DownloadableInfo Obj, PluginStatus Status) {
        String Key2 = this.infoMapKey(Obj, Status);
        if (Key2 != null) {
            return this.infoObjMap.get(Key2);
        }
        return null;
    }

    private void createPluginTable() {
        this.infoObjMap = new HashMap();
        for (PluginStatus ps : PluginStatus.values()) {
            for (Element el : this.trackerDoc.getRootElement().getChild(ps.getTagName()).getChildren()) {
                if (el.getName().equals(PluginXml.THEME.getTag())) {
                    this.infoObjMap.put(this.infoMapKey(el, ps), el);
                    for (Element pEl : el.getChild(PluginXml.PLUGIN_LIST.getTag()).getChildren(PluginXml.PLUGIN.getTag())) {
                        String key = this.infoMapKey(pEl, ps);
                        this.infoObjMap.put(key, pEl);
                    }
                    continue;
                }
                if (el.getName().equals(PluginXml.PLUGIN.getTag())) {
                    String key = this.infoMapKey(el, ps);
                    this.infoObjMap.put(key, el);
                    continue;
                }
                logger.warn("Unknown tag in plugin tracker file: " + el.getName());
            }
        }
    }

    private String infoMapKey(DownloadableInfo Obj, PluginStatus Status) {
        return Obj.getID() != null ? Obj.getID() + "_" + Obj.getType().value() + "_" + Obj.getDownloadableURL() + "_" + Status.getTagName() : null;
    }

    private String infoMapKey(Element el, PluginStatus Status) {
        return el.getChildTextTrim(this.uniqueIdTag) + "_" + el.getName() + "_" + el.getChildTextTrim(this.downloadUrlTag) + "_" + Status.getTagName();
    }

    protected void write() {
        for (Element e : this.corruptedElements) {
            e.detach();
        }
        try {
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            FileWriter Writer2 = new FileWriter(this.installFile);
            out.output(this.trackerDoc, (Writer)Writer2);
            Writer2.close();
        }
        catch (IOException E) {
            logger.warn("Error writing plugin status file " + E.toString());
        }
    }

    public boolean hasCorruptedElements() {
        return this.corruptedElementsFound;
    }

    public int getTotalCorruptedElements() {
        return this.corruptedElements.size();
    }

    public void clearCorruptedElements() {
        this.corruptedElementsFound = false;
        this.corruptedElements.clear();
    }

    private void addCorruptedElement(Element e) {
        logger.warn("** Adding corrupted element **");
        this.corruptedElements.add(e);
        this.corruptedElementsFound = true;
    }

    public String toString() {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        return out.outputString(this.trackerDoc);
    }

    protected void delete() {
        if (this.installFile.exists()) {
            this.installFile.delete();
        }
    }

    private DownloadableInfo createBasicObject(Element e, DownloadableType Type2) {
        DownloadableInfo Info = null;
        if (e.getChildren().size() > 0 && e.getChild(this.uniqueIdTag) != null) {
            switch (Type2) {
                case PLUGIN: {
                    Info = new PluginInfo(e.getChildTextTrim(this.uniqueIdTag));
                    break;
                }
                case THEME: {
                    Info = new ThemeInfo(e.getChildTextTrim(this.uniqueIdTag));
                }
            }
            if (e.getChild(this.nameTag) == null || e.getChild(this.descTag) == null || e.getChild(this.cytoVersTag) == null || e.getChild(this.urlTag) == null || e.getChild(this.downloadUrlTag) == null) {
                return null;
            }
            Info.setName(e.getChildTextTrim(this.nameTag));
            Info.setDescription(e.getChildTextTrim(this.descTag));
            Info.addCytoscapeVersion(e.getChildTextTrim(this.cytoVersTag));
            Info.setObjectUrl(e.getChildTextTrim(this.urlTag));
            Info.setDownloadableURL(e.getChildTextTrim(this.downloadUrlTag));
            if (e.getChild(this.categoryTag) != null) {
                Info.setCategory(e.getChildTextTrim(this.categoryTag));
            }
            if (e.getChild(PluginXml.RELEASE_DATE.getTag()) != null) {
                Info.setReleaseDate(e.getChildTextTrim(PluginXml.RELEASE_DATE.getTag()));
            }
        }
        return Info;
    }

    private List<ThemeInfo> getThemeContent(Element ThemeParentTag) {
        ArrayList<ThemeInfo> Content2 = new ArrayList<ThemeInfo>();
        List Themes = ThemeParentTag.getChildren(PluginXml.THEME.getTag());
        for (Element CurrentTheme : Themes) {
            ThemeInfo themeInfo = (ThemeInfo)this.createBasicObject(CurrentTheme, DownloadableType.THEME);
            if (themeInfo == null || CurrentTheme.getChild(PluginXml.THEME_VERSION.getTag()) == null || CurrentTheme.getChild(PluginXml.PLUGIN_LIST.getTag()) == null || CurrentTheme.getChild(PluginXml.PLUGIN_LIST.getTag()).getChildren(PluginXml.PLUGIN.getTag()).size() <= 0) {
                this.addCorruptedElement(CurrentTheme);
                continue;
            }
            themeInfo.setObjectVersion(Double.valueOf(CurrentTheme.getChildTextTrim(PluginXml.THEME_VERSION.getTag())));
            Iterator pluginI = CurrentTheme.getChild(PluginXml.PLUGIN_LIST.getTag()).getChildren(PluginXml.PLUGIN.getTag()).iterator();
            while (pluginI.hasNext()) {
                PluginInfo pluginInfo = this.createPluginObject((Element)pluginI.next());
                if (pluginInfo == null) {
                    this.addCorruptedElement(CurrentTheme);
                    break;
                }
                pluginInfo.setParent(themeInfo);
                themeInfo.addPlugin(pluginInfo);
            }
            if (this.corruptedElements.contains(CurrentTheme)) continue;
            Content2.add(themeInfo);
        }
        return Content2;
    }

    private List<PluginInfo> getPluginContent(Element PluginParentTag) {
        ArrayList<PluginInfo> Content2 = new ArrayList<PluginInfo>();
        List Plugins2 = PluginParentTag.getChildren(this.pluginTag);
        for (Element CurrentPlugin : Plugins2) {
            PluginInfo Info = this.createPluginObject(CurrentPlugin);
            if (Info == null) {
                this.addCorruptedElement(CurrentPlugin);
                continue;
            }
            Content2.add(Info);
        }
        return Content2;
    }

    private List<DownloadableInfo> getDownloadableContent(Element Parent2) {
        ArrayList<DownloadableInfo> Content2 = new ArrayList<DownloadableInfo>();
        Content2.addAll(this.getPluginContent(Parent2));
        Content2.addAll(this.getThemeContent(Parent2));
        return Content2;
    }

    private PluginInfo createPluginObject(Element PluginElement) {
        PluginInfo Info = (PluginInfo)this.createBasicObject(PluginElement, DownloadableType.PLUGIN);
        if (Info == null || PluginElement.getChildren().size() <= 0 || PluginElement.getChild(this.classTag) == null || PluginElement.getChild(this.installLocTag) == null || PluginElement.getChild(this.pluginVersTag) == null || PluginElement.getChild(this.fileTypeTag) == null || PluginElement.getChild(this.fileListTag) == null) {
            return null;
        }
        Info.setPluginClassName(PluginElement.getChildTextTrim(this.classTag));
        Info.setInstallLocation(PluginElement.getChildTextTrim(this.installLocTag));
        Info.setObjectVersion(Double.valueOf(PluginElement.getChildTextTrim(this.pluginVersTag)));
        Info.setProjectUrl(PluginElement.getChildTextTrim(this.projUrlTag));
        String FileType2 = PluginElement.getChildTextTrim(this.fileTypeTag);
        if (FileType2.equalsIgnoreCase(PluginInfo.FileType.JAR.toString())) {
            Info.setFiletype(PluginInfo.FileType.JAR);
        } else if (FileType2.equalsIgnoreCase(PluginInfo.FileType.ZIP.toString())) {
            Info.setFiletype(PluginInfo.FileType.ZIP);
        }
        List Files = PluginElement.getChild(this.fileListTag).getChildren(this.fileTag);
        for (Element File2 : Files) {
            Info.addFileName(File2.getTextTrim());
        }
        if (PluginElement.getChild(this.authorListTag) != null) {
            List Authors = PluginElement.getChild(this.authorListTag).getChildren(this.authorTag);
            for (Element Author : Authors) {
                Info.addAuthor(Author.getChildTextTrim(this.nameTag), Author.getChildTextTrim(this.instTag));
            }
        }
        Info = PluginFileReader.addLicense(Info, PluginElement);
        return Info;
    }

    private Element createBasicContent(DownloadableInfo obj, Element e) {
        e.addContent((Content)new Element(this.uniqueIdTag).setText(obj.getID()));
        e.addContent((Content)new Element(this.nameTag).setText(obj.getName()));
        e.addContent((Content)new Element(this.descTag).setText(obj.getDescription()));
        e.addContent((Content)new Element(this.cytoVersTag).setText(obj.getCytoscapeVersion()));
        e.addContent((Content)new Element(this.urlTag).setText(obj.getObjectUrl()));
        e.addContent((Content)new Element(this.downloadUrlTag).setText(obj.getDownloadableURL()));
        e.addContent((Content)new Element(this.categoryTag).setText(obj.getCategory()));
        e.addContent((Content)new Element(PluginXml.RELEASE_DATE.getTag()).setText(obj.getReleaseDate()));
        return e;
    }

    private Element createThemeContent(ThemeInfo obj) {
        Element Theme = new Element(PluginXml.THEME.getTag());
        Theme = this.createBasicContent(obj, Theme);
        Theme.addContent((Content)new Element(PluginXml.THEME_VERSION.getTag()).setText(obj.getObjectVersion()));
        Element PluginList = new Element(PluginXml.PLUGIN_LIST.getTag());
        for (PluginInfo plugin : obj.getPlugins()) {
            PluginList.addContent((Content)this.createPluginContent(plugin));
        }
        Theme.addContent((Content)PluginList);
        return Theme;
    }

    private Element createPluginContent(PluginInfo obj) {
        Element Plugin2 = new Element(this.pluginTag);
        Plugin2 = this.createBasicContent(obj, Plugin2);
        Plugin2.addContent((Content)new Element(this.pluginVersTag).setText(obj.getObjectVersion()));
        Plugin2.addContent((Content)new Element(this.classTag).setText(obj.getPluginClassName()));
        Plugin2.addContent((Content)new Element(this.projUrlTag).setText(obj.getProjectUrl()));
        Plugin2.addContent((Content)new Element(this.fileTypeTag).setText(obj.getFileType().toString()));
        Plugin2.addContent((Content)new Element(this.installLocTag).setText(obj.getInstallLocation()));
        Element License2 = new Element(this.licenseTag);
        License2.addContent((Content)new Element("text").setText(obj.getLicenseText()));
        Plugin2.addContent((Content)License2);
        Element AuthorList = new Element(this.authorListTag);
        for (PluginInfo.AuthorInfo CurrentAuthor : obj.getAuthors()) {
            Element Author = new Element(this.authorTag);
            Author.addContent((Content)new Element(this.nameTag).setText(CurrentAuthor.getAuthor()));
            Author.addContent((Content)new Element(this.instTag).setText(CurrentAuthor.getInstitution()));
            AuthorList.addContent((Content)Author);
        }
        Plugin2.addContent((Content)AuthorList);
        Element FileList = new Element(this.fileListTag);
        for (String FileName : obj.getFileList()) {
            FileList.addContent((Content)new Element(this.fileTag).setText(FileName));
        }
        Plugin2.addContent((Content)FileList);
        return Plugin2;
    }
}

