/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.logger.CyLogger;
import cytoscape.task.TaskMonitor;
import cytoscape.util.CyFileFilter;
import cytoscape.util.URLUtil;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public abstract class FileUtil {
    protected static CyLogger logger = CyLogger.getLogger(FileUtil.class);
    public static int LOAD = 0;
    public static int SAVE = 1;
    public static int CUSTOM = LOAD + SAVE;
    public static final String urlPattern = "^(jar\\:)?(\\w+\\:\\/+\\S+)(\\!\\/\\S*)?$";

    public static File getFile(String title, int load_save_custom) {
        return FileUtil.getFile(title, load_save_custom, new CyFileFilter[0], null, null);
    }

    public static File getFile(String title, int load_save_custom, CyFileFilter[] filters) {
        return FileUtil.getFile(title, load_save_custom, filters, null, null);
    }

    public static File getFile(String title, int load_save_custom, CyFileFilter[] filters, String start_dir, String custom_approve_text) {
        File[] result = FileUtil.getFiles(title, load_save_custom, filters, start_dir, custom_approve_text, false);
        return result == null || result.length <= 0 ? null : result[0];
    }

    public static File[] getFiles(String title, int load_save_custom, CyFileFilter[] filters) {
        return FileUtil.getFiles(null, title, load_save_custom, filters, null, null, true);
    }

    public static File[] getFiles(Component parent, String title, int load_save_custom, CyFileFilter[] filters) {
        return FileUtil.getFiles(parent, title, load_save_custom, filters, null, null, true);
    }

    public static File[] getFiles(String title, int load_save_custom, CyFileFilter[] filters, String start_dir, String custom_approve_text) {
        return FileUtil.getFiles(null, title, load_save_custom, filters, start_dir, custom_approve_text, true);
    }

    public static File[] getFiles(String title, int load_save_custom, CyFileFilter[] filters, String start_dir, String custom_approve_text, boolean multiselect) {
        return FileUtil.getFiles(null, title, load_save_custom, filters, start_dir, custom_approve_text, multiselect);
    }

    public static File[] getFiles(Component parent, String title, int load_save_custom, CyFileFilter[] filters, String start_dir, String custom_approve_text, boolean multiselect) {
        if (parent == null) {
            parent = Cytoscape.getDesktop();
        }
        File start = null;
        start = start_dir == null ? CytoscapeInit.getMRUD() : new File(start_dir);
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac")) {
            FileDialog chooser = new FileDialog((Frame)Cytoscape.getDesktop(), title, load_save_custom);
            CyFileFilter fileFilter = new CyFileFilter();
            for (int i = 0; i < filters.length; ++i) {
                Iterator iter = filters[i].getExtensionSet().iterator();
                while (iter.hasNext()) {
                    fileFilter.addExtension((String)iter.next());
                }
            }
            fileFilter.setDescription("All network files");
            chooser.setFilenameFilter(fileFilter);
            chooser.setVisible(true);
            if (chooser.getFile() != null) {
                File[] result = new File[]{new File(chooser.getDirectory() + "/" + chooser.getFile())};
                if (chooser.getDirectory() != null) {
                    CytoscapeInit.setMRUD(new File(chooser.getDirectory()));
                }
                return result;
            }
            return null;
        }
        JFileChooser chooser = new JFileChooser(start);
        chooser.setMultiSelectionEnabled(multiselect);
        chooser.setDialogTitle(title);
        for (int i = 0; i < filters.length; ++i) {
            chooser.addChoosableFileFilter(filters[i]);
        }
        File[] result = null;
        File tmp = null;
        if (load_save_custom == LOAD) {
            if (chooser.showOpenDialog(parent) == 0) {
                if (multiselect) {
                    result = chooser.getSelectedFiles();
                } else {
                    tmp = chooser.getSelectedFile();
                    if (tmp != null) {
                        result = new File[]{tmp};
                    }
                }
            }
        } else if (load_save_custom == SAVE) {
            if (chooser.showSaveDialog(parent) == 0) {
                if (multiselect) {
                    result = chooser.getSelectedFiles();
                } else {
                    tmp = chooser.getSelectedFile();
                    if (tmp != null) {
                        result = new File[]{tmp};
                    }
                }
                for (int i = 0; i < result.length; ++i) {
                    int answer;
                    if (!result[i].exists() || (answer = JOptionPane.showConfirmDialog(chooser, "The file '" + result[i].getName() + "' already exists, are you sure you want to overwrite it?", "File exists", 0, 2)) != 1) continue;
                    return null;
                }
            }
        } else if (chooser.showDialog(parent, custom_approve_text) == 0) {
            if (multiselect) {
                result = chooser.getSelectedFiles();
            } else {
                tmp = chooser.getSelectedFile();
                if (tmp != null) {
                    result = new File[]{tmp};
                }
            }
        }
        if (result != null && start_dir == null) {
            CytoscapeInit.setMRUD(chooser.getCurrentDirectory());
        }
        return result;
    }

    public static InputStream getInputStream(String name) {
        return FileUtil.getInputStream(name, null);
    }

    public static InputStream getInputStream(String name, TaskMonitor monitor) {
        InputStream in;
        block4: {
            in = null;
            try {
                if (name.matches(urlPattern)) {
                    URL u = new URL(name);
                    in = URLUtil.getBasicInputStream(u);
                } else {
                    in = new FileInputStream(name);
                }
            }
            catch (IOException ioe) {
                logger.error("Unable to open file '" + name + "': " + ioe.getMessage());
                if (monitor == null) break block4;
                monitor.setException((Throwable)ioe, ioe.getMessage());
            }
        }
        return in;
    }

    public static String getInputString(String filename) {
        try {
            InputStream stream = FileUtil.getInputStream(filename);
            return FileUtil.getInputString(stream);
        }
        catch (IOException ioe) {
            logger.warn("Couldn't create string from '" + filename + "': " + ioe.getMessage());
            return null;
        }
    }

    public static String getInputString(InputStream inputStream) throws IOException {
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String line = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = br.readLine()) != null) {
            sb.append(line + lineSep);
        }
        return sb.toString();
    }
}

