/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetSocketAddress;
import java.net.Proxy;

public class ProxyHandler
implements PropertyChangeListener {
    public static final String PROXY_HOST_PROPERTY_NAME = "proxy.server";
    public static final String PROXY_TYPE_PROPERTY_NAME = "proxy.server.type";
    public static final String PROXY_PORT_PROPERTY_NAME = "proxy.server.port";
    private static Proxy proxyServer = null;

    private ProxyHandler() {
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public static Proxy getProxyServer() {
        if (proxyServer == null) {
            ProxyHandler.loadProxyServer();
        }
        return proxyServer;
    }

    private static void loadProxyServer() {
        String proxyName = CytoscapeInit.getProperties().getProperty(PROXY_HOST_PROPERTY_NAME);
        if (proxyName == null || proxyName.equals("")) {
            proxyServer = null;
            return;
        }
        String proxyT = CytoscapeInit.getProperties().getProperty(PROXY_TYPE_PROPERTY_NAME);
        if (proxyT == null || proxyT.equals("")) {
            proxyServer = null;
            return;
        }
        Proxy.Type proxyType = Proxy.Type.valueOf(proxyT);
        String proxyP = CytoscapeInit.getProperties().getProperty(PROXY_PORT_PROPERTY_NAME);
        if (proxyP == null || proxyP.equals("")) {
            proxyServer = null;
            return;
        }
        int proxyPort = Integer.parseInt(proxyP);
        proxyServer = new Proxy(proxyType, new InetSocketAddress(proxyName, proxyPort));
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "PREFERENCES_UPDATED") {
            Proxy savedProxy = proxyServer;
            ProxyHandler.loadProxyServer();
            if (proxyServer == null && savedProxy != null || proxyServer != null && !proxyServer.equals(savedProxy)) {
                Cytoscape.firePropertyChange("PROXY_MODIFIED", savedProxy, proxyServer);
            }
        }
    }

    static {
        new ProxyHandler();
    }
}

