/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTask;
import cytoscape.util.ProxyHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public class URLUtil {
    private static final String GZIP = ".gz";
    private static final String ZIP = ".zip";
    private static final String JAR = ".jar";
    private static int msConnectionTimeout = 2000;
    public static boolean STOP = false;

    public static InputStream getInputStream(URL source) throws IOException {
        InputStream proxyIs = URLUtil.getBasicInputStream(source);
        InputStream newIs = source.toString().toLowerCase().endsWith(GZIP) ? new GZIPInputStream(proxyIs) : (source.toString().toLowerCase().endsWith(ZIP) ? new ZipInputStream(proxyIs) : (source.toString().toLowerCase().endsWith(JAR) ? new JarInputStream(proxyIs) : proxyIs));
        return newIs;
    }

    public static InputStream getBasicInputStream(URL source) throws IOException {
        if (source == null) {
            throw new IllegalStateException("getBasicInputStream was given a null 'source' argument.");
        }
        URLConnection uc = URLUtil.getURLConnection(source);
        return uc.getInputStream();
    }

    public static URLConnection getURLConnection(URL source) throws IOException {
        if (source == null) {
            throw new IllegalStateException("getURLConnection was given a null 'source' argument.");
        }
        Proxy cytoProxy = ProxyHandler.getProxyServer();
        URLConnection uc = null;
        if (cytoProxy == null) {
            uc = source.openConnection();
        } else {
            try {
                uc = source.openConnection(cytoProxy);
            }
            catch (UnsupportedOperationException e) {
                uc = source.openConnection();
            }
        }
        uc.setUseCaches(false);
        uc.setConnectTimeout(msConnectionTimeout);
        return uc;
    }

    public static void download(String urlString, File downloadFile, TaskMonitor taskMonitor) throws IOException {
        URL url = new URL(urlString);
        InputStream is = null;
        int maxCount = 0;
        int progressCount = 0;
        URLConnection conn = URLUtil.getURLConnection(url);
        maxCount = conn.getContentLength();
        is = conn.getInputStream();
        FileOutputStream os = new FileOutputStream(downloadFile);
        double percent = 0.0;
        byte[] buffer = new byte[1];
        while (is.read(buffer) != -1 && !STOP) {
            progressCount += buffer.length;
            if (taskMonitor != null) {
                JTask jTask;
                percent = (double)progressCount / (double)maxCount * 100.0;
                if (maxCount == -1) {
                    percent = -1.0;
                }
                if ((jTask = (JTask)taskMonitor).haltRequested()) {
                    downloadFile = null;
                    taskMonitor.setStatus("Canceling the download ...");
                    taskMonitor.setPercentCompleted(100);
                    break;
                }
                taskMonitor.setPercentCompleted((int)percent);
            }
            os.write(buffer);
        }
        os.flush();
        os.close();
        is.close();
        if (STOP) {
            downloadFile.delete();
        }
    }

    public static String download(URL source) throws IOException {
        int c;
        InputStream is = URLUtil.getInputStream(source);
        StringBuffer buffer = new StringBuffer();
        while ((c = is.read()) != -1) {
            buffer.append((char)c);
        }
        is.close();
        return buffer.toString();
    }
}

