/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyNetwork;
import cytoscape.visual.Appearance;
import cytoscape.visual.AppearanceCalculator;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.ObjectMapping;
import giny.model.GraphObject;
import giny.model.Node;
import java.util.Properties;

public class NodeAppearanceCalculator
extends AppearanceCalculator {
    private NodeAppearance defaultAppearance = new NodeAppearance();

    public NodeAppearanceCalculator() {
    }

    public NodeAppearanceCalculator(String name, Properties nacProps, String baseKey, CalculatorCatalog catalog) {
        super(name, nacProps, baseKey, catalog, new NodeAppearance());
        this.defaultAppearance = (NodeAppearance)this.tmpDefaultAppearance;
    }

    public NodeAppearanceCalculator(NodeAppearanceCalculator toCopy) {
        super(toCopy);
    }

    public NodeAppearance calculateNodeAppearance(Node node, CyNetwork network) {
        NodeAppearance appr = new NodeAppearance();
        this.calculateNodeAppearance(appr, node, network);
        return appr;
    }

    public Object clone() {
        NodeAppearanceCalculator copy = new NodeAppearanceCalculator();
        NodeAppearance defAppr = new NodeAppearance();
        for (VisualPropertyType type : VisualPropertyType.getNodeVisualPropertyList()) {
            defAppr.set(type, this.defaultAppearance.get(type));
        }
        defAppr.setNodeSizeLocked(this.defaultAppearance.getNodeSizeLocked());
        copy.setDefaultAppearance(defAppr);
        for (Calculator cal : this.calcs) {
            ObjectMapping mCopy = (ObjectMapping)cal.getMapping(0).clone();
            BasicCalculator bCalc = new BasicCalculator(((Object)cal).toString(), mCopy, cal.getVisualPropertyType());
            copy.setCalculator(bCalc);
        }
        return copy;
    }

    public void calculateNodeAppearance(NodeAppearance appr, Node node, CyNetwork network) {
        appr.copy(this.defaultAppearance);
        for (Calculator nc : this.calcs) {
            nc.apply((Appearance)appr, node, network);
        }
        appr.applyBypass((GraphObject)node);
    }

    public NodeAppearance getDefaultAppearance() {
        return this.defaultAppearance;
    }

    public void setDefaultAppearance(NodeAppearance n) {
        this.defaultAppearance = n;
    }

    public String getDescription() {
        return this.getDescription("NodeAppearanceCalculator", this.defaultAppearance);
    }

    public void applyProperties(String name, Properties nacProps, String baseKey, CalculatorCatalog catalog) {
        this.applyProperties(this.defaultAppearance, name, nacProps, baseKey, catalog);
    }

    public Properties getProperties(String baseKey) {
        return this.getProperties(this.defaultAppearance, baseKey);
    }

    protected void copyDefaultAppearance(AppearanceCalculator toCopy) {
        this.defaultAppearance = (NodeAppearance)((NodeAppearanceCalculator)toCopy).getDefaultAppearance().clone();
    }

    public boolean getNodeSizeLocked() {
        return this.defaultAppearance.getNodeSizeLocked();
    }

    public void setNodeSizeLocked(boolean b) {
        this.defaultAppearance.setNodeSizeLocked(b);
    }
}

