/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.CytoscapeInit;
import cytoscape.logger.CyLogger;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorCatalogFactory;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearance;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.SubjectBase;
import cytoscape.visual.VisualStyle;
import ding.view.DGraphView;
import ding.view.DingCanvas;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.Paint;
import java.util.Iterator;

public class VisualMappingManager
extends SubjectBase {
    private CalculatorCatalog catalog;
    private CyNetworkView networkView;
    private VisualStyle activeVS;
    private NodeAppearance myNodeApp = new NodeAppearance();
    private EdgeAppearance myEdgeApp = new EdgeAppearance();
    private GlobalAppearance myGlobalApp = new GlobalAppearance();
    private static final String DEF_STYLE_NAME = "default";

    public VisualMappingManager(CyNetworkView networkView) {
        VisualStyle vs;
        this.networkView = networkView;
        this.loadCalculatorCatalog();
        String defStyle = CytoscapeInit.getProperties().getProperty("defaultVisualStyle");
        if (defStyle == null) {
            defStyle = DEF_STYLE_NAME;
        }
        if ((vs = this.catalog.getVisualStyle(defStyle)) == null) {
            vs = this.catalog.getVisualStyle(DEF_STYLE_NAME);
        }
        this.setVisualStyle(vs);
    }

    public void loadCalculatorCatalog() {
        this.loadCalculatorCatalog(null);
    }

    public void loadCalculatorCatalog(String vizmapLocation) {
        if (this.catalog == null) {
            this.catalog = CalculatorCatalogFactory.loadCalculatorCatalog();
        } else if (vizmapLocation != null) {
            this.catalog = CalculatorCatalogFactory.loadCalculatorCatalog();
        }
    }

    public void setNetworkView(CyNetworkView new_view) {
        this.networkView = new_view;
    }

    public CyNetworkView getNetworkView() {
        return this.networkView;
    }

    public CyNetwork getNetwork() {
        return this.networkView.getNetwork();
    }

    public CalculatorCatalog getCalculatorCatalog() {
        return this.catalog;
    }

    public VisualStyle getVisualStyle() {
        return this.activeVS;
    }

    public VisualStyle setVisualStyle(VisualStyle vs) {
        if (vs != null && vs != this.activeVS) {
            VisualStyle tmp = this.activeVS;
            this.activeVS = vs;
            this.fireStateChanged();
            return tmp;
        }
        return this.activeVS;
    }

    public VisualStyle setVisualStyle(String newVSName) {
        VisualStyle vs = this.catalog.getVisualStyle(newVSName);
        if (vs != null) {
            return this.setVisualStyle(vs);
        }
        return this.activeVS;
    }

    public void applyNodeAppearances() {
        this.applyNodeAppearances(this.getNetwork(), this.getNetworkView());
    }

    public void applyNodeAppearances(CyNetwork network, CyNetworkView network_view) {
        NodeAppearanceCalculator nodeAppearanceCalculator = this.activeVS.getNodeAppearanceCalculator();
        Iterator i = network_view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nodeView = (NodeView)i.next();
            Node node = nodeView.getNode();
            nodeAppearanceCalculator.calculateNodeAppearance(this.myNodeApp, node, network);
            this.myNodeApp.applyAppearance(nodeView);
        }
    }

    public void applyEdgeAppearances() {
        this.applyEdgeAppearances(this.getNetwork(), this.getNetworkView());
    }

    public void applyEdgeAppearances(CyNetwork network, CyNetworkView network_view) {
        EdgeAppearanceCalculator edgeAppearanceCalculator = this.activeVS.getEdgeAppearanceCalculator();
        Iterator i = network_view.getEdgeViewsIterator();
        while (i.hasNext()) {
            EdgeView edgeView = (EdgeView)i.next();
            if (edgeView == null) continue;
            edgeAppearanceCalculator.calculateEdgeAppearance(this.myEdgeApp, edgeView.getEdge(), network);
            this.myEdgeApp.applyAppearance(edgeView);
        }
    }

    public void applyGlobalAppearances() {
        this.applyGlobalAppearances(this.getNetwork(), this.getNetworkView());
    }

    public void applyGlobalAppearances(CyNetwork network, CyNetworkView network_view) {
        GlobalAppearanceCalculator globalAppearanceCalculator = this.activeVS.getGlobalAppearanceCalculator();
        globalAppearanceCalculator.calculateGlobalAppearance(this.myGlobalApp, network);
        if (network_view instanceof DGraphView) {
            DingCanvas backgroundCanvas = ((DGraphView)network_view).getCanvas(DGraphView.Canvas.BACKGROUND_CANVAS);
            backgroundCanvas.setBackground(this.myGlobalApp.getBackgroundColor());
        } else {
            CyLogger.getLogger().info("VisualMappingManager.applyGlobalAppearances() - DGraphView not found!");
            network_view.setBackgroundPaint(this.myGlobalApp.getBackgroundColor());
        }
        Iterator nodeIt = network.nodesIterator();
        while (nodeIt.hasNext()) {
            network_view.getNodeView((CyNode)nodeIt.next()).setSelectedPaint((Paint)this.myGlobalApp.getNodeSelectionColor());
        }
        Iterator edgeIt = network.edgesIterator();
        while (edgeIt.hasNext()) {
            network_view.getEdgeView((CyEdge)edgeIt.next()).setSelectedPaint((Paint)this.myGlobalApp.getEdgeSelectionColor());
        }
    }

    public void applyAppearances() {
        this.applyNodeAppearances();
        this.applyEdgeAppearances();
        this.applyGlobalAppearances();
    }

    public void vizmapNode(NodeView nodeView, CyNetworkView network_view) {
        CyNode node = (CyNode)nodeView.getNode();
        NodeAppearanceCalculator nodeAppearanceCalculator = this.activeVS.getNodeAppearanceCalculator();
        nodeAppearanceCalculator.calculateNodeAppearance(this.myNodeApp, node, network_view.getNetwork());
        this.myNodeApp.applyAppearance(nodeView);
    }

    public void vizmapEdge(EdgeView edgeView, CyNetworkView network_view) {
        CyEdge edge = (CyEdge)edgeView.getEdge();
        EdgeAppearanceCalculator edgeAppearanceCalculator = this.activeVS.getEdgeAppearanceCalculator();
        edgeAppearanceCalculator.calculateEdgeAppearance(this.myEdgeApp, edge, network_view.getNetwork());
        this.myEdgeApp.applyAppearance(edgeView);
    }
}

