/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.continuous;

import cytoscape.logger.CyLogger;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.mappings.continuous.ContinuousUI;
import cytoscape.visual.ui.ValueDisplayer;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ValueListener
implements ItemListener {
    private ContinuousUI ui;
    private ContinuousMapping cm;
    private int index;
    private int offset;

    public ValueListener(ContinuousUI ui, ContinuousMapping cm, int index, int offset) {
        this.ui = ui;
        this.cm = cm;
        this.index = index;
        this.offset = offset;
    }

    public void itemStateChanged(ItemEvent e) {
        CyLogger.getLogger().info("SIGNAL______________________" + ((ValueDisplayer)e.getItemSelectable()).getValue());
        Object o = ((ValueDisplayer)e.getItemSelectable()).getValue();
        ContinuousMappingPoint point = this.cm.getPoint(this.index);
        BoundaryRangeValues range = point.getRange();
        if (this.offset == 0) {
            range.lesserValue = o;
        } else if (this.offset == 1) {
            range.equalValue = o;
            int numPoints = this.cm.getAllPoints().size();
            if (numPoints > 1) {
                if (this.index == 0) {
                    range.greaterValue = o;
                } else if (this.index == numPoints - 1) {
                    range.lesserValue = o;
                } else {
                    range.lesserValue = o;
                    range.greaterValue = o;
                }
            }
        } else if (this.offset == 2) {
            range.greaterValue = o;
        }
        this.ui.resetUI();
    }
}

