/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.discrete;

import cytoscape.visual.mappings.MappingUtil;
import cytoscape.visual.parsers.ObjectToString;
import java.util.Properties;
import java.util.TreeMap;

public class DiscreteMappingWriter {
    private String attrName;
    private String baseKey;
    private TreeMap map;

    public DiscreteMappingWriter(String attrName, String baseKey, TreeMap map) {
        this.attrName = attrName;
        this.baseKey = baseKey;
        this.map = map;
    }

    public Properties getProperties() {
        Properties newProps = new Properties();
        if (this.attrName == null) {
            return newProps;
        }
        String contKey = this.baseKey + ".controller";
        newProps.setProperty(contKey, this.attrName);
        String contTypeKey = this.baseKey + ".controllerType";
        newProps.setProperty(contTypeKey, MappingUtil.getAttributeTypeString(this.baseKey, this.attrName));
        String mapKey = this.baseKey + ".map.";
        for (Object key : this.map.keySet()) {
            Object value = this.map.get(key);
            if (value == null) continue;
            String stringValue = ObjectToString.getStringValue(value);
            newProps.setProperty(mapKey + key.toString(), stringValue);
        }
        return newProps;
    }
}

