/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.FloatParser;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.LineTypeIcon;
import giny.view.EdgeView;
import giny.view.Label;
import java.awt.Color;
import java.awt.Font;
import java.util.Properties;
import javax.swing.Icon;

public class EdgeFontSizeProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.EDGE_FONT_SIZE;
    }

    public Icon getIcon(Object value) {
        LineTypeIcon icon = new LineTypeIcon();
        icon.setColor(new Color(10, 10, 10, 20));
        icon.setText(value.toString());
        icon.setBottomPadding(-7);
        return icon;
    }

    public void applyToEdgeView(EdgeView ev, Object o) {
        if (o == null || ev == null) {
            return;
        }
        Label edgelabel = ev.getLabel();
        Font f = edgelabel.getFont();
        float newFontSize = ((Number)o).floatValue();
        if (newFontSize != f.getSize2D()) {
            edgelabel.setFont(f.deriveFont(newFontSize));
        }
    }

    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.EDGE_FONT_SIZE.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return new FloatParser().parseFloat(s);
        }
        return null;
    }

    public Object getDefaultAppearanceObject() {
        return new Float(10.0f);
    }
}

