/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.Cytoscape;
import cytoscape.visual.ArrowShape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.ArrowIcon;
import giny.view.EdgeView;
import java.awt.Color;
import java.awt.Paint;
import java.util.Properties;
import javax.swing.Icon;

public class EdgeTargetArrowColorProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.EDGE_TGTARROW_COLOR;
    }

    public Icon getIcon(Object value) {
        ArrowShape arrowShape = (ArrowShape)((Object)VisualPropertyType.EDGE_TGTARROW_SHAPE.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle()));
        ArrowIcon icon = new ArrowIcon(arrowShape.getShape());
        icon.setColor((Color)value);
        icon.setLeftPadding(20);
        icon.setBottomPadding(-6);
        return icon;
    }

    public void applyToEdgeView(EdgeView ev, Object o) {
        if (o == null || ev == null) {
            return;
        }
        Color newTargetArrowColor = (Color)o;
        if (newTargetArrowColor != ev.getTargetEdgeEndPaint()) {
            ev.setTargetEdgeEndPaint((Paint)newTargetArrowColor);
        }
    }

    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.EDGE_TGTARROW_COLOR.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return new ColorParser().parseColor(s);
        }
        return null;
    }

    public Object getDefaultAppearanceObject() {
        return Color.black;
    }
}

