/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.LineStyle;
import cytoscape.visual.LineType;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.LineTypeParser;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.NodeIcon;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Stroke;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeLineTypeProp
extends AbstractVisualProperty {
    @Override
    public VisualPropertyType getType() {
        return VisualPropertyType.NODE_LINETYPE;
    }

    @Override
    public Map<Object, Icon> getIconSet() {
        return LineStyle.getIconSet();
    }

    @Override
    public Icon getIcon(Object value) {
        return new NodeIcon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.paintIcon(c, g, x, y);
                this.g2d.setStroke(new BasicStroke(5.0f));
                this.g2d.drawLine(c.getX() + 10, (int)(this.shape.getBounds().getCenterY() + 5.0), (int)this.shape.getBounds2D().getMaxX() * 2, (int)this.shape.getBounds().getCenterY() + 5);
            }
        };
    }

    @Override
    public void applyToNodeView(NodeView nv, Object o) {
        if (o == null || nv == null) {
            return;
        }
        Stroke newBorderLine = ((LineType)o).getStroke();
        if (!newBorderLine.equals(nv.getBorder())) {
            nv.setBorder(newBorderLine);
        }
    }

    @Override
    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.NODE_LINETYPE.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return new LineTypeParser().parseLineType(s);
        }
        return null;
    }

    @Override
    public Object getDefaultAppearanceObject() {
        return LineType.LINE_1;
    }
}

