/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.NodeIcon;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Properties;
import javax.swing.Icon;

public class NodeToolTipProp
extends AbstractVisualProperty {
    private StringBuilder buf = new StringBuilder();

    public VisualPropertyType getType() {
        return VisualPropertyType.NODE_TOOLTIP;
    }

    public Icon getIcon(final Object value) {
        NodeIcon icon = new NodeIcon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 25));
                super.paintIcon(c, g, x, y);
                this.g2d.setFont(new Font("SansSerif", 1, 8));
                this.g2d.setColor(Color.DARK_GRAY);
                String defLabel = value.toString();
                if (defLabel.length() > 15) {
                    defLabel = defLabel.substring(0, 14) + "...";
                }
                this.g2d.drawString(defLabel, c.getX() + 7, c.getHeight() / 2);
                this.g2d.setFont(new Font("SansSerif", 1, 12));
            }
        };
        icon.setBottomPadding(-2);
        return icon;
    }

    public void applyToNodeView(NodeView nv, Object o) {
        if (o == null || nv == null) {
            return;
        }
        if (((String)o).startsWith("<html>")) {
            nv.setToolTip((String)o);
            return;
        }
        if (((String)o).equals("")) {
            nv.setToolTip(null);
            return;
        }
        this.buf = new StringBuilder();
        this.buf.append("<html><body bgcolor=\"white\"><Div Align=\"center\"><Font Size=\"4\">");
        this.buf.append(((String)o).replaceAll("\\n", "<br>"));
        this.buf.append("</Font></div></body></html>");
        nv.setToolTip(this.buf.toString());
    }

    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.NODE_TOOLTIP.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return s;
        }
        return null;
    }

    public Object getDefaultAppearanceObject() {
        return "";
    }
}

